/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Mit dieser Attributliste wird spezifiziert, für welche Attributgruppen die Parameter (Anzahl der Archivdatensätze, Containergröße in
					Byte und die Zeitspanne der Container) gelten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlAttributgruppen implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			 _attributgruppe
			;
	
		/**
		Attribut zur Referenzierung von Attributgruppen.
		<p>
		
		</p>
		
		@return der Wert von Attributgruppe.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			 getAttributgruppe() {
			return _attributgruppe;
		}
	
		/**
		Attribut zur Referenzierung von Attributgruppen.
		<p>
		
		</p>
		
		@param _attributgruppe der neue Wert von Attributgruppe.
		*/
		public void setAttributgruppe(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
		 _attributgruppe) {
			this._attributgruppe = _attributgruppe;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soAttributgruppe = getAttributgruppe();
					final SystemObject tmpAttributgruppe;
						if (soAttributgruppe instanceof SystemObject) {
							tmpAttributgruppe = (SystemObject)soAttributgruppe;
						} else if(soAttributgruppe instanceof SystemObjekt){
							tmpAttributgruppe = ((SystemObjekt)soAttributgruppe).getSystemObject();
						} else{
							tmpAttributgruppe = null;
						}
					datum.getReferenceValue("Attributgruppe").setSystemObject(tmpAttributgruppe);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idAttributgruppe = daten.getReferenceValue("Attributgruppe").getId();
					final SystemObjekt tmpAttributgruppe;
					if (idAttributgruppe == 0) {
						tmpAttributgruppe = null;
					} else {
						final SystemObject soAttributgruppe = factory.getDav().getDataModel().getObject(idAttributgruppe);
						if (soAttributgruppe == null) {
								tmpAttributgruppe = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AttributgruppeUngueltig(idAttributgruppe);
						} else {
							tmpAttributgruppe = factory.getModellobjekt(soAttributgruppe);
						}
					}
					setAttributgruppe((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
					) tmpAttributgruppe);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAttributgruppen clone() {
		AtlAttributgruppen klon = new AtlAttributgruppen();
		
						klon.setAttributgruppe(getAttributgruppe());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
