/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Auswahl von Objekten über die Vorgabe von Bereichen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 27
 */
public class AtlBereiche implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsVerantwortlicher
			> _konfigurationsverantwortlicher = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsVerantwortlicher
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			> _konfigurationsbereich = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			> _typ = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			>(0, true);
			@Defaultwert(wert = "")
			private String
			 _mengenbezeichnung
			= new String
			()
			;
	
		/**
		Referenz auf Konfigurationsverantwortliche.
		<p>
		&lt;absatz&gt;
		                             Über dieses Array können Konfigurationsverantwortliche angegeben werden.
		                             Die Auswahl eines Konfigurationsverantwortlichens bedeutet, dass alle Konfigurationsbereiche
		                             dieses Konfigurationsverantwortlichens betrachtet werden.
		                             Wenn das Array Konfigurationsverantwortliche leer ist, ist kein Konfigurationsverantwortlicher
		                             und damit kein Konfigurationsbereich ausgewählt.
		                         &lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von Konfigurationsverantwortlicher.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsVerantwortlicher
			> getKonfigurationsverantwortlicher() {
			return _konfigurationsverantwortlicher;
		}
	
	
		/**
		Referenz auf Konfigurationsbereiche.
		<p>
		&lt;absatz&gt;
		                        Über dieses Array können Konfigurationsbereiche angegeben werden. Die Auswahl eines Konfigurationsbereichs bedeutet,
		                        dass alle Konfigurationsobjekte dieses Konfigurationsbereichs betrachtet werden.
		                        Wenn das Array Konfigurationsbereich leer ist, ist kein Konfigurationsbereich ausgewählt.
		                        &lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von Konfigurationsbereich.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			> getKonfigurationsbereich() {
			return _konfigurationsbereich;
		}
	
	
		/**
		Referenz auf Typobjekte.
		<p>
		&lt;absatz&gt;
		                            Über dieses Array werden die bisher ausgewählten Objekte auf die angegebenen Typobjekte beschränkt.
		                            Wenn die beiden Arrays Konfigurationsverantwortliche und Konfigurationsbereich beide zu keiner
		                            (Vor)Auswahl von Konfigurationsbereichen geführt haben, wird an dieser Stelle die gesamte
		                            Konfiguration betrachtet.
		                            D.h., wenn hier z.B. als Typ MessQuerschnitt angegeben wird, werden nur noch Konfigurationsobjekte
		                            betrachtet, die von diesem Typ stammen.
		                            Wenn das Array Typen leer ist, erfolgt keine Filterung nach Objekttypen.
		                            Damit sind alle bisher ausgewählten Konfigurationsobjekte ausgewählt
		                            (Also entweder alle Konfigurationsobjekte der (vor)ausgewählten Bereiche oder alle Konfigurationsobjekte der Konfiguration).
		                        &lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von Typ.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			> getTyp() {
			return _typ;
		}
	
	
		/**
		Mengenname.
		<p>
		&lt;absatz&gt;
		                            Über die Vorgabe eines Mengennamens können die Objekte ausgewählt werden, die in Mengen dieses Namens
		                            bei den ausgewählten Objekten enthalten sind. Ist hier z.B. als Menge "FahrStreifen" angegeben,
		                            wird für alle bisher ausgewählten Objekte geprüft, ob an dem Konfigurationsobjekt eine Menge
		                            dieses Namens vorhanden ist und für diesen Fall werden die enthaltenen Konfigurationsobjekte betrachtet.
		                            Wenn hier keine Angabe erfolgt, bleibt die Auswahl bestehen.
		                         &lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von Mengenbezeichnung.
		*/
			public String
			 getMengenbezeichnung() {
			return _mengenbezeichnung;
		}
	
		/**
		Mengenname.
		<p>
		&lt;absatz&gt;
		                            Über die Vorgabe eines Mengennamens können die Objekte ausgewählt werden, die in Mengen dieses Namens
		                            bei den ausgewählten Objekten enthalten sind. Ist hier z.B. als Menge "FahrStreifen" angegeben,
		                            wird für alle bisher ausgewählten Objekte geprüft, ob an dem Konfigurationsobjekt eine Menge
		                            dieses Namens vorhanden ist und für diesen Fall werden die enthaltenen Konfigurationsobjekte betrachtet.
		                            Wenn hier keine Angabe erfolgt, bleibt die Auswahl bestehen.
		                         &lt;&#47;absatz&gt;
		</p>
		
		@param _mengenbezeichnung der neue Wert von Mengenbezeichnung.
		*/
		public void setMengenbezeichnung(String
		 _mengenbezeichnung) {
			if (_mengenbezeichnung.length() > 64) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 64 + " Zeichen sein.");
			}
			this._mengenbezeichnung = _mengenbezeichnung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayKonfigurationsverantwortlicher = datum.getReferenceArray("Konfigurationsverantwortlicher");
					arrayKonfigurationsverantwortlicher.setLength(getKonfigurationsverantwortlicher().size());
					for (int i = 0; i < arrayKonfigurationsverantwortlicher.getLength(); ++i) {
						final Object soKonfigurationsverantwortlicher = getKonfigurationsverantwortlicher().get(i);
						final SystemObject tmpKonfigurationsverantwortlicher;
						if (soKonfigurationsverantwortlicher instanceof SystemObject) {
							tmpKonfigurationsverantwortlicher = (SystemObject)soKonfigurationsverantwortlicher;
						} else if(soKonfigurationsverantwortlicher instanceof SystemObjekt){
							tmpKonfigurationsverantwortlicher = ((SystemObjekt)soKonfigurationsverantwortlicher).getSystemObject();
						} else{
							tmpKonfigurationsverantwortlicher = null;
						}
						arrayKonfigurationsverantwortlicher.getReferenceValue(i).setSystemObject(tmpKonfigurationsverantwortlicher);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayKonfigurationsbereich = datum.getReferenceArray("Konfigurationsbereich");
					arrayKonfigurationsbereich.setLength(getKonfigurationsbereich().size());
					for (int i = 0; i < arrayKonfigurationsbereich.getLength(); ++i) {
						final Object soKonfigurationsbereich = getKonfigurationsbereich().get(i);
						final SystemObject tmpKonfigurationsbereich;
						if (soKonfigurationsbereich instanceof SystemObject) {
							tmpKonfigurationsbereich = (SystemObject)soKonfigurationsbereich;
						} else if(soKonfigurationsbereich instanceof SystemObjekt){
							tmpKonfigurationsbereich = ((SystemObjekt)soKonfigurationsbereich).getSystemObject();
						} else{
							tmpKonfigurationsbereich = null;
						}
						arrayKonfigurationsbereich.getReferenceValue(i).setSystemObject(tmpKonfigurationsbereich);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayTyp = datum.getReferenceArray("Typ");
					arrayTyp.setLength(getTyp().size());
					for (int i = 0; i < arrayTyp.getLength(); ++i) {
						final Object soTyp = getTyp().get(i);
						final SystemObject tmpTyp;
						if (soTyp instanceof SystemObject) {
							tmpTyp = (SystemObject)soTyp;
						} else if(soTyp instanceof SystemObjekt){
							tmpTyp = ((SystemObjekt)soTyp).getSystemObject();
						} else{
							tmpTyp = null;
						}
						arrayTyp.getReferenceValue(i).setSystemObject(tmpTyp);
					}
				// ZeichenkettenAttributTyp
				if (getMengenbezeichnung() != null) {
					datum.getTextValue("Mengenbezeichnung").setText(getMengenbezeichnung());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayKonfigurationsverantwortlicher = daten.getReferenceArray("Konfigurationsverantwortlicher");
					for (int i = 0; i < arrayKonfigurationsverantwortlicher.getLength(); ++i) {
						final long idKonfigurationsverantwortlicher = daten.getReferenceArray("Konfigurationsverantwortlicher").getReferenceValue(i).getId();
						final SystemObjekt tmpKonfigurationsverantwortlicher;
						if (idKonfigurationsverantwortlicher == 0) {
							tmpKonfigurationsverantwortlicher = null;
						} else {
							final SystemObject soKonfigurationsverantwortlicher = factory.getDav().getDataModel().getObject(idKonfigurationsverantwortlicher);
							if (soKonfigurationsverantwortlicher == null) {
									tmpKonfigurationsverantwortlicher = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.KonfigurationsVerantwortlicherUngueltig(idKonfigurationsverantwortlicher);
							} else {
								tmpKonfigurationsverantwortlicher = factory.getModellobjekt(soKonfigurationsverantwortlicher);
							}
						}
							getKonfigurationsverantwortlicher().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsVerantwortlicher
							) tmpKonfigurationsverantwortlicher);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayKonfigurationsbereich = daten.getReferenceArray("Konfigurationsbereich");
					for (int i = 0; i < arrayKonfigurationsbereich.getLength(); ++i) {
						final long idKonfigurationsbereich = daten.getReferenceArray("Konfigurationsbereich").getReferenceValue(i).getId();
						final SystemObjekt tmpKonfigurationsbereich;
						if (idKonfigurationsbereich == 0) {
							tmpKonfigurationsbereich = null;
						} else {
							final SystemObject soKonfigurationsbereich = factory.getDav().getDataModel().getObject(idKonfigurationsbereich);
							if (soKonfigurationsbereich == null) {
									tmpKonfigurationsbereich = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.KonfigurationsBereichUngueltig(idKonfigurationsbereich);
							} else {
								tmpKonfigurationsbereich = factory.getModellobjekt(soKonfigurationsbereich);
							}
						}
							getKonfigurationsbereich().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
							) tmpKonfigurationsbereich);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayTyp = daten.getReferenceArray("Typ");
					for (int i = 0; i < arrayTyp.getLength(); ++i) {
						final long idTyp = daten.getReferenceArray("Typ").getReferenceValue(i).getId();
						final SystemObjekt tmpTyp;
						if (idTyp == 0) {
							tmpTyp = null;
						} else {
							final SystemObject soTyp = factory.getDav().getDataModel().getObject(idTyp);
							if (soTyp == null) {
									tmpTyp = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.TypUngueltig(idTyp);
							} else {
								tmpTyp = factory.getModellobjekt(soTyp);
							}
						}
							getTyp().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
							) tmpTyp);
					}
				// ZeichenkettenAttributTyp
					setMengenbezeichnung(daten.getTextValue("Mengenbezeichnung").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBereiche clone() {
		AtlBereiche klon = new AtlBereiche();
		
					klon._konfigurationsverantwortlicher = getKonfigurationsverantwortlicher().clone();
					klon._konfigurationsbereich = getKonfigurationsbereich().clone();
					klon._typ = getTyp().clone();
						klon.setMengenbezeichnung(getMengenbezeichnung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
