/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält die Parameter (Anzahl der Archivdatensätze, Containergröße in Byte und die Zeitspanne der Container) für die ausgewählten
					Attributgruppen, die angeben, wann ein Container des Archivsystems abzuschließen ist.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlContainerAbschlussAusnahmen implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAttributgruppen
			> _attributgruppen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAttributgruppen
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlContainerAbschlussEinstellungen
			 _einstellungen
			= new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlContainerAbschlussEinstellungen
			()
			;
	
		/**
		Mit dieser Attributliste wird spezifiziert, für welche Attributgruppen die Parameter (Anzahl der Archivdatensätze, Containergröße in
							Byte und die Zeitspanne der Container) gelten.
		<p>
		
		</p>
		
		@return der Wert von Attributgruppen.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAttributgruppen
			> getAttributgruppen() {
			return _attributgruppen;
		}
	
	
		/**
		Mit dieser Attributliste wird spezifiziert, wann ein Container des Archivsystems abgeschlossen wird.
		<p>
		
		</p>
		
		@return der Wert von Einstellungen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlContainerAbschlussEinstellungen
			 getEinstellungen() {
			return _einstellungen;
		}
	
		/**
		Mit dieser Attributliste wird spezifiziert, wann ein Container des Archivsystems abgeschlossen wird.
		<p>
		
		</p>
		
		@param _einstellungen der neue Wert von Einstellungen.
		*/
		public void setEinstellungen(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlContainerAbschlussEinstellungen
		 _einstellungen) {
			this._einstellungen = _einstellungen;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayAttributgruppen = datum.getArray("Attributgruppen");
					arrayAttributgruppen.setLength(getAttributgruppen().size());
					for (int i = 0; i < arrayAttributgruppen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAttributgruppen
						 atl = getAttributgruppen().get(i);
						atl.bean2Atl(arrayAttributgruppen.getItem(i), factory);
	
					}
				// AttributListenDefinition
					getEinstellungen().bean2Atl(datum.getItem("Einstellungen"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayAttributgruppen = daten.getArray("Attributgruppen");
					for (int i = 0; i < arrayAttributgruppen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAttributgruppen
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAttributgruppen
						 ();
						atl.atl2Bean(arrayAttributgruppen.getItem(i), factory);
						getAttributgruppen().add(atl);
					}
				// AttributListenDefinition
					getEinstellungen().atl2Bean(daten.getItem("Einstellungen"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlContainerAbschlussAusnahmen clone() {
		AtlContainerAbschlussAusnahmen klon = new AtlContainerAbschlussAusnahmen();
		
					klon._attributgruppen = getAttributgruppen().clone();
						klon._einstellungen = getEinstellungen().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
