/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Mit dieser Attributliste wird spezifiziert, wann ein Container des Archivsystems abgeschlossen wird.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlContainerAbschlussEinstellungen implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttMaxAnzahlArchivdatensaetze
			 _maxAnzahlArchivdatensaetze
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttMaxContainergroesse
			 _maxContainergroesse
			;
			private 	RelativerZeitstempel
			 _maxZeitspanneContainer
			;
	
		/**
		Attribut zur Speicherung der maximalen Anzahl von Archivdatensätzen.
		<p>
		
		</p>
		
		@return der Wert von MaxAnzahlArchivdatensaetze.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttMaxAnzahlArchivdatensaetze
			 getMaxAnzahlArchivdatensaetze() {
			return _maxAnzahlArchivdatensaetze;
		}
	
		/**
		Attribut zur Speicherung der maximalen Anzahl von Archivdatensätzen.
		<p>
		
		</p>
		
		@param _maxAnzahlArchivdatensaetze der neue Wert von MaxAnzahlArchivdatensaetze.
		*/
		public void setMaxAnzahlArchivdatensaetze(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttMaxAnzahlArchivdatensaetze
		 _maxAnzahlArchivdatensaetze) {
			this._maxAnzahlArchivdatensaetze = _maxAnzahlArchivdatensaetze;
		}
	
		/**
		Attribut zur Speicherung der maximalen Containergröße in Byte. Auf 1 GByte beschränkt.
		<p>
		
		</p>
		
		@return der Wert von MaxContainergroesse.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttMaxContainergroesse
			 getMaxContainergroesse() {
			return _maxContainergroesse;
		}
	
		/**
		Attribut zur Speicherung der maximalen Containergröße in Byte. Auf 1 GByte beschränkt.
		<p>
		
		</p>
		
		@param _maxContainergroesse der neue Wert von MaxContainergroesse.
		*/
		public void setMaxContainergroesse(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttMaxContainergroesse
		 _maxContainergroesse) {
			this._maxContainergroesse = _maxContainergroesse;
		}
	
		/**
		Angabe einer Zeitdauer.
		<p>
		
		</p>
		
		@return der Wert von MaxZeitspanneContainer.
		*/
			public 	RelativerZeitstempel
			 getMaxZeitspanneContainer() {
			return _maxZeitspanneContainer;
		}
	
		/**
		Angabe einer Zeitdauer.
		<p>
		
		</p>
		
		@param _maxZeitspanneContainer der neue Wert von MaxZeitspanneContainer.
		*/
		public void setMaxZeitspanneContainer(	RelativerZeitstempel
		 _maxZeitspanneContainer) {
			this._maxZeitspanneContainer = _maxZeitspanneContainer;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getMaxAnzahlArchivdatensaetze() != null) {
	                if (getMaxAnzahlArchivdatensaetze().isZustand()) {
	                    datum.getUnscaledValue("MaxAnzahlArchivdatensätze").setText(getMaxAnzahlArchivdatensaetze().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("MaxAnzahlArchivdatensätze").set(getMaxAnzahlArchivdatensaetze().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getMaxContainergroesse() != null) {
	                if (getMaxContainergroesse().isZustand()) {
	                    datum.getUnscaledValue("MaxContainergröße").setText(getMaxContainergroesse().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("MaxContainergröße").set(getMaxContainergroesse().getValue());
	                }
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("MaxZeitspanneContainer").setMillis(getMaxZeitspanneContainer().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setMaxAnzahlArchivdatensaetze(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttMaxAnzahlArchivdatensaetze
						(daten.
							getUnscaledValue
						("MaxAnzahlArchivdatensätze").
								intValue
						()));
				// GanzzahlAttributTyp
						setMaxContainergroesse(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttMaxContainergroesse
						(daten.
							getUnscaledValue
						("MaxContainergröße").
								intValue
						()));
				// ZeitstempelAttributTyp
					setMaxZeitspanneContainer(new
						RelativerZeitstempel
						(daten.getTimeValue("MaxZeitspanneContainer").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlContainerAbschlussEinstellungen clone() {
		AtlContainerAbschlussEinstellungen klon = new AtlContainerAbschlussEinstellungen();
		
						klon.setMaxAnzahlArchivdatensaetze(getMaxAnzahlArchivdatensaetze());
						klon.setMaxContainergroesse(getMaxContainergroesse());
						klon.setMaxZeitspanneContainer(getMaxZeitspanneContainer());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
