/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Mit dieser Attributliste wird spezifiziert, für welche Tupel bestehend aus Konfigurationsobjekt, Attributgruppe und Aspekt die
					folgenden Einstellungen gelten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlDatenSpezifikationParametrierung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	Object
			> _objekt = new Feld<	Object
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			> _attributGruppe = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
			 _simulationsVariante
			;
	
		/**
		Mit diesem Attribut können beliebig viele Konfigurationsobjekte angegeben werden, für die Datensätze archiviert werden sollen. Die
								Spezifikation der gewünschten Konfigurationsobjekte erfolgt über die direkte Angabe von einzelnen Konfigurationsobjekten (z.B. über die
								PID), über die Angabe einer Menge (z.B. Menge der MQ) und durch die Angabe von Typen (z.B. Typ MQ). Bei der Angabe von Objekttypen
								werden alle Konfigurationsobjekte dieses Typs aus den Konfigurationsbereichen ausgewählt, die über das Attribut "Bereich" spezifiziert
								wurden (Kein Eintrag bedeutet: alle Objekte ausgewählt).
		<p>
		
		</p>
		
		@return der Wert von Objekt.
		*/
			public Feld<	Object
			> getObjekt() {
			return _objekt;
		}
	
	
		/**
		Mit diesem Attribut werden die Attributgruppen spezifiziert, die für die ausgewählten Konfigurationsobjekte durch die
								Parametrierung verwaltet werden sollen (Kein Eintrag bedeutet: alle Attributtgruppen ausgewählt)..
		<p>
		
		</p>
		
		@return der Wert von AttributGruppe.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			> getAttributGruppe() {
			return _attributGruppe;
		}
	
	
		/**
		Mit diesem Attribut werden die Simulationsvarianten spezifiziert, unter denen die angegebenen Attributgruppen unter den
								angegebenen Aspekten für die ausgewählten Konfigurationsobjekte verwaltet werden sollen..
		<p>
		
		</p>
		
		@return der Wert von SimulationsVariante.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
			 getSimulationsVariante() {
			return _simulationsVariante;
		}
	
		/**
		Mit diesem Attribut werden die Simulationsvarianten spezifiziert, unter denen die angegebenen Attributgruppen unter den
								angegebenen Aspekten für die ausgewählten Konfigurationsobjekte verwaltet werden sollen..
		<p>
		
		</p>
		
		@param _simulationsVariante der neue Wert von SimulationsVariante.
		*/
		public void setSimulationsVariante(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
		 _simulationsVariante) {
			this._simulationsVariante = _simulationsVariante;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayObjekt = datum.getReferenceArray("Objekt");
					arrayObjekt.setLength(getObjekt().size());
					for (int i = 0; i < arrayObjekt.getLength(); ++i) {
						final Object soObjekt = getObjekt().get(i);
						final SystemObject tmpObjekt;
						if (soObjekt instanceof SystemObject) {
							tmpObjekt = (SystemObject)soObjekt;
						} else if(soObjekt instanceof SystemObjekt){
							tmpObjekt = ((SystemObjekt)soObjekt).getSystemObject();
						} else{
							tmpObjekt = null;
						}
						arrayObjekt.getReferenceValue(i).setSystemObject(tmpObjekt);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAttributGruppe = datum.getReferenceArray("AttributGruppe");
					arrayAttributGruppe.setLength(getAttributGruppe().size());
					for (int i = 0; i < arrayAttributGruppe.getLength(); ++i) {
						final Object soAttributGruppe = getAttributGruppe().get(i);
						final SystemObject tmpAttributGruppe;
						if (soAttributGruppe instanceof SystemObject) {
							tmpAttributGruppe = (SystemObject)soAttributGruppe;
						} else if(soAttributGruppe instanceof SystemObjekt){
							tmpAttributGruppe = ((SystemObjekt)soAttributGruppe).getSystemObject();
						} else{
							tmpAttributGruppe = null;
						}
						arrayAttributGruppe.getReferenceValue(i).setSystemObject(tmpAttributGruppe);
					}
				// GanzzahlAttributTyp
				if (getSimulationsVariante() != null) {
	                if (getSimulationsVariante().isZustand()) {
	                    datum.getUnscaledValue("SimulationsVariante").setText(getSimulationsVariante().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SimulationsVariante").set(getSimulationsVariante().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayObjekt = daten.getReferenceArray("Objekt");
					for (int i = 0; i < arrayObjekt.getLength(); ++i) {
						final long idObjekt = daten.getReferenceArray("Objekt").getReferenceValue(i).getId();
						final SystemObjekt tmpObjekt;
						if (idObjekt == 0) {
							tmpObjekt = null;
						} else {
							final SystemObject soObjekt = factory.getDav().getDataModel().getObject(idObjekt);
							if (soObjekt == null) {
									tmpObjekt = new BaseUngueltigesSystemObjekt(idObjekt);
							} else {
								tmpObjekt = factory.getModellobjekt(soObjekt);
							}
						}
							getObjekt().add((	Object
							) tmpObjekt);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAttributGruppe = daten.getReferenceArray("AttributGruppe");
					for (int i = 0; i < arrayAttributGruppe.getLength(); ++i) {
						final long idAttributGruppe = daten.getReferenceArray("AttributGruppe").getReferenceValue(i).getId();
						final SystemObjekt tmpAttributGruppe;
						if (idAttributGruppe == 0) {
							tmpAttributGruppe = null;
						} else {
							final SystemObject soAttributGruppe = factory.getDav().getDataModel().getObject(idAttributGruppe);
							if (soAttributGruppe == null) {
									tmpAttributGruppe = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AttributgruppeUngueltig(idAttributGruppe);
							} else {
								tmpAttributGruppe = factory.getModellobjekt(soAttributGruppe);
							}
						}
							getAttributGruppe().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
							) tmpAttributGruppe);
					}
				// GanzzahlAttributTyp
						setSimulationsVariante(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
						(daten.
							getUnscaledValue
						("SimulationsVariante").
								shortValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlDatenSpezifikationParametrierung clone() {
		AtlDatenSpezifikationParametrierung klon = new AtlDatenSpezifikationParametrierung();
		
					klon._objekt = getObjekt().clone();
					klon._attributGruppe = getAttributGruppe().clone();
						klon.setSimulationsVariante(getSimulationsVariante());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
