/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt ein Objekt der HierarchieDefinition.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class AtlDefaultParameter implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Object
			 _systemobjekt
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			 _objekttyp
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			 _attributgruppe
			;
			private String
			 _parameter
			= new String
			()
			;
	
		/**
		Attribut zur Referenzierung von beliebigen Objekten.
		<p>
		
		</p>
		
		@return der Wert von Systemobjekt.
		*/
			public 	Object
			 getSystemobjekt() {
			return _systemobjekt;
		}
	
		/**
		Attribut zur Referenzierung von beliebigen Objekten.
		<p>
		
		</p>
		
		@param _systemobjekt der neue Wert von Systemobjekt.
		*/
		public void setSystemobjekt(	Object
		 _systemobjekt) {
			this._systemobjekt = _systemobjekt;
		}
	
		/**
		Attribut zur Referenzierung von Objekttypen.
		<p>
		
		</p>
		
		@return der Wert von Objekttyp.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			 getObjekttyp() {
			return _objekttyp;
		}
	
		/**
		Attribut zur Referenzierung von Objekttypen.
		<p>
		
		</p>
		
		@param _objekttyp der neue Wert von Objekttyp.
		*/
		public void setObjekttyp(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
		 _objekttyp) {
			this._objekttyp = _objekttyp;
		}
	
		/**
		Attribut zur Referenzierung von Attributgruppen.
		<p>
		
		</p>
		
		@return der Wert von Attributgruppe.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			 getAttributgruppe() {
			return _attributgruppe;
		}
	
		/**
		Attribut zur Referenzierung von Attributgruppen.
		<p>
		
		</p>
		
		@param _attributgruppe der neue Wert von Attributgruppe.
		*/
		public void setAttributgruppe(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
		 _attributgruppe) {
			this._attributgruppe = _attributgruppe;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Parameter.
		*/
			public String
			 getParameter() {
			return _parameter;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _parameter der neue Wert von Parameter.
		*/
		public void setParameter(String
		 _parameter) {
			if (_parameter.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._parameter = _parameter;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soSystemobjekt = getSystemobjekt();
					final SystemObject tmpSystemobjekt;
						if (soSystemobjekt instanceof SystemObject) {
							tmpSystemobjekt = (SystemObject)soSystemobjekt;
						} else if(soSystemobjekt instanceof SystemObjekt){
							tmpSystemobjekt = ((SystemObjekt)soSystemobjekt).getSystemObject();
						} else{
							tmpSystemobjekt = null;
						}
					datum.getReferenceValue("Systemobjekt").setSystemObject(tmpSystemobjekt);
				// ObjektReferenzAttributTyp
					final Object soObjekttyp = getObjekttyp();
					final SystemObject tmpObjekttyp;
						if (soObjekttyp instanceof SystemObject) {
							tmpObjekttyp = (SystemObject)soObjekttyp;
						} else if(soObjekttyp instanceof SystemObjekt){
							tmpObjekttyp = ((SystemObjekt)soObjekttyp).getSystemObject();
						} else{
							tmpObjekttyp = null;
						}
					datum.getReferenceValue("Objekttyp").setSystemObject(tmpObjekttyp);
				// ObjektReferenzAttributTyp
					final Object soAttributgruppe = getAttributgruppe();
					final SystemObject tmpAttributgruppe;
						if (soAttributgruppe instanceof SystemObject) {
							tmpAttributgruppe = (SystemObject)soAttributgruppe;
						} else if(soAttributgruppe instanceof SystemObjekt){
							tmpAttributgruppe = ((SystemObjekt)soAttributgruppe).getSystemObject();
						} else{
							tmpAttributgruppe = null;
						}
					datum.getReferenceValue("Attributgruppe").setSystemObject(tmpAttributgruppe);
				// ZeichenkettenAttributTyp
				if (getParameter() != null) {
					datum.getTextValue("Parameter").setText(getParameter());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idSystemobjekt = daten.getReferenceValue("Systemobjekt").getId();
					final SystemObjekt tmpSystemobjekt;
					if (idSystemobjekt == 0) {
						tmpSystemobjekt = null;
					} else {
						final SystemObject soSystemobjekt = factory.getDav().getDataModel().getObject(idSystemobjekt);
						if (soSystemobjekt == null) {
								tmpSystemobjekt = new BaseUngueltigesSystemObjekt(idSystemobjekt);
						} else {
							tmpSystemobjekt = factory.getModellobjekt(soSystemobjekt);
						}
					}
					setSystemobjekt((	Object
					) tmpSystemobjekt);
				// ObjektReferenzAttributTyp
					final long idObjekttyp = daten.getReferenceValue("Objekttyp").getId();
					final SystemObjekt tmpObjekttyp;
					if (idObjekttyp == 0) {
						tmpObjekttyp = null;
					} else {
						final SystemObject soObjekttyp = factory.getDav().getDataModel().getObject(idObjekttyp);
						if (soObjekttyp == null) {
								tmpObjekttyp = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.TypUngueltig(idObjekttyp);
						} else {
							tmpObjekttyp = factory.getModellobjekt(soObjekttyp);
						}
					}
					setObjekttyp((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
					) tmpObjekttyp);
				// ObjektReferenzAttributTyp
					final long idAttributgruppe = daten.getReferenceValue("Attributgruppe").getId();
					final SystemObjekt tmpAttributgruppe;
					if (idAttributgruppe == 0) {
						tmpAttributgruppe = null;
					} else {
						final SystemObject soAttributgruppe = factory.getDav().getDataModel().getObject(idAttributgruppe);
						if (soAttributgruppe == null) {
								tmpAttributgruppe = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AttributgruppeUngueltig(idAttributgruppe);
						} else {
							tmpAttributgruppe = factory.getModellobjekt(soAttributgruppe);
						}
					}
					setAttributgruppe((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
					) tmpAttributgruppe);
				// ZeichenkettenAttributTyp
					setParameter(daten.getTextValue("Parameter").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlDefaultParameter clone() {
		AtlDefaultParameter klon = new AtlDefaultParameter();
		
						klon.setSystemobjekt(getSystemobjekt());
						klon.setObjekttyp(getObjekttyp());
						klon.setAttributgruppe(getAttributgruppe());
						klon.setParameter(getParameter());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
