/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter, die für die Durchsatzprüfung einer Verbindung benutzt werden sollen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlDurchsatzPruefungsParameter implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _pufferFuellgrad
			;
			private 	RelativerZeitstempel
			 _pruefIntervall
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttDurchsatz
			 _mindestDurchsatz
			;
	
		/**
		Wenn der Sendepuffer über den hier spezifizierten Anteil gefüllt ist, dann wird die Durchsatzprüfung aktiviert.
		<p>
		
		</p>
		
		@return der Wert von PufferFuellgrad.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 getPufferFuellgrad() {
			return _pufferFuellgrad;
		}
	
		/**
		Wenn der Sendepuffer über den hier spezifizierten Anteil gefüllt ist, dann wird die Durchsatzprüfung aktiviert.
		<p>
		
		</p>
		
		@param _pufferFuellgrad der neue Wert von PufferFuellgrad.
		*/
		public void setPufferFuellgrad(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
		 _pufferFuellgrad) {
			this._pufferFuellgrad = _pufferFuellgrad;
		}
	
		/**
		Intervalldauer für die Durchsatzmessung.
		<p>
		
		</p>
		
		@return der Wert von PruefIntervall.
		*/
			public 	RelativerZeitstempel
			 getPruefIntervall() {
			return _pruefIntervall;
		}
	
		/**
		Intervalldauer für die Durchsatzmessung.
		<p>
		
		</p>
		
		@param _pruefIntervall der neue Wert von PruefIntervall.
		*/
		public void setPruefIntervall(	RelativerZeitstempel
		 _pruefIntervall) {
			this._pruefIntervall = _pruefIntervall;
		}
	
		/**
		Erforderlicher Mindestdurchsatz für die Durchsatzmessung in jedem Messintervall.
		<p>
		
		</p>
		
		@return der Wert von MindestDurchsatz.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttDurchsatz
			 getMindestDurchsatz() {
			return _mindestDurchsatz;
		}
	
		/**
		Erforderlicher Mindestdurchsatz für die Durchsatzmessung in jedem Messintervall.
		<p>
		
		</p>
		
		@param _mindestDurchsatz der neue Wert von MindestDurchsatz.
		*/
		public void setMindestDurchsatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttDurchsatz
		 _mindestDurchsatz) {
			this._mindestDurchsatz = _mindestDurchsatz;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getPufferFuellgrad() != null) {
	                if (getPufferFuellgrad().isZustand()) {
	                    datum.getUnscaledValue("pufferFüllgrad").setText(getPufferFuellgrad().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("pufferFüllgrad").set(getPufferFuellgrad().getValue());
	                }
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("prüfIntervall").setMillis(getPruefIntervall().getTime());
				// GanzzahlAttributTyp
				if (getMindestDurchsatz() != null) {
	                if (getMindestDurchsatz().isZustand()) {
	                    datum.getUnscaledValue("mindestDurchsatz").setText(getMindestDurchsatz().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("mindestDurchsatz").set(getMindestDurchsatz().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("pufferFüllgrad").isState()) {
							setPufferFuellgrad(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							.getZustand(daten.getScaledValue("pufferFüllgrad").getText()));
						} else {
						setPufferFuellgrad(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
						(daten.
							getUnscaledValue
						("pufferFüllgrad").
								byteValue
						()));
						}
				// ZeitstempelAttributTyp
					setPruefIntervall(new
						RelativerZeitstempel
						(daten.getTimeValue("prüfIntervall").getMillis()));
				// GanzzahlAttributTyp
						setMindestDurchsatz(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttDurchsatz
						(daten.
							getUnscaledValue
						("mindestDurchsatz").
								longValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlDurchsatzPruefungsParameter clone() {
		AtlDurchsatzPruefungsParameter klon = new AtlDurchsatzPruefungsParameter();
		
						klon.setPufferFuellgrad(getPufferFuellgrad());
						klon.setPruefIntervall(getPruefIntervall());
						klon.setMindestDurchsatz(getMindestDurchsatz());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
