/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Diese Attributliste fasst die "eigentlichen" Parameter, wie die gemäß Datenspezifikation zu archivierenden Datensätze zu behandeln
					sind, zusamm.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlEinstellungenArchiv implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "Ja")
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _archivieren
			;
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Archiv
			> _nachfordern = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Archiv
			>(0, true);
			@Defaultwert(wert = "Nein")
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _sichern
			;
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			> _quittieren = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			>(1, true);
			@Defaultwert(wert = "100 Tage")
			private 	RelativerZeitstempel
			 _vorhalten
			;
	
		/**
		Mit diesem Attribut wird angegeben, ob die entsprechenden Daten zu archivieren sind ("Ja" oder "Nein"). Wird an dieser Stelle
								"Nein" angegeben, sind die weiteren Attribute der Attributliste "Einstellungen" obsolet.
		<p>
		
		</p>
		
		@return der Wert von Archivieren.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getArchivieren() {
			return _archivieren;
		}
	
		/**
		Mit diesem Attribut wird angegeben, ob die entsprechenden Daten zu archivieren sind ("Ja" oder "Nein"). Wird an dieser Stelle
								"Nein" angegeben, sind die weiteren Attribute der Attributliste "Einstellungen" obsolet.
		<p>
		
		</p>
		
		@param _archivieren der neue Wert von Archivieren.
		*/
		public void setArchivieren(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _archivieren) {
			this._archivieren = _archivieren;
		}
	
		/**
		Mit diesem Attribut wird angegeben, ob Daten bei potentiell erkannter Datenlücken von anderen Archivsystemen nachgefordert werden
								sollen. Das Attribut stellt ein Array dar, in dem die Archivsysteme aufgeführt sind, bei denen nachgefragt werden soll.
		<p>
		
		</p>
		
		@return der Wert von Nachfordern.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Archiv
			> getNachfordern() {
			return _nachfordern;
		}
	
	
		/**
		Mit diesem Attribut wird angegeben, ob die entsprechenden Daten zu sichern sind ("Ja" oder "Nein").
		<p>
		
		</p>
		
		@return der Wert von Sichern.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getSichern() {
			return _sichern;
		}
	
		/**
		Mit diesem Attribut wird angegeben, ob die entsprechenden Daten zu sichern sind ("Ja" oder "Nein").
		<p>
		
		</p>
		
		@param _sichern der neue Wert von Sichern.
		*/
		public void setSichern(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _sichern) {
			this._sichern = _sichern;
		}
	
		/**
		Mit diesem Attribut wird angegeben, ob die entsprechenden Daten zu quittieren sind. In diesem Fall wird an dieser Stelle der
								Aspekt spezifiziert, unter dem die entsprechenden Attributgruppen nach erfolgreicher Archivierung publiziert werden.
		<p>
		
		</p>
		
		@return der Wert von Quittieren.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			> getQuittieren() {
			return _quittieren;
		}
	
	
		/**
		Mit diesem Attribut wird spezifiziert, wie lange sich die zu archivierenden Datensätze im direkten Zugriff des Archivsystems
								befinden sollen.
		<p>
		
		</p>
		
		@return der Wert von Vorhalten.
		*/
			public 	RelativerZeitstempel
			 getVorhalten() {
			return _vorhalten;
		}
	
		/**
		Mit diesem Attribut wird spezifiziert, wie lange sich die zu archivierenden Datensätze im direkten Zugriff des Archivsystems
								befinden sollen.
		<p>
		
		</p>
		
		@param _vorhalten der neue Wert von Vorhalten.
		*/
		public void setVorhalten(	RelativerZeitstempel
		 _vorhalten) {
			this._vorhalten = _vorhalten;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getArchivieren() != null) {
	                if (getArchivieren().isZustand()) {
	                    datum.getUnscaledValue("Archivieren").setText(getArchivieren().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Archivieren").set(getArchivieren().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayNachfordern = datum.getReferenceArray("Nachfordern");
					arrayNachfordern.setLength(getNachfordern().size());
					for (int i = 0; i < arrayNachfordern.getLength(); ++i) {
						final Object soNachfordern = getNachfordern().get(i);
						final SystemObject tmpNachfordern;
						if (soNachfordern instanceof SystemObject) {
							tmpNachfordern = (SystemObject)soNachfordern;
						} else if(soNachfordern instanceof SystemObjekt){
							tmpNachfordern = ((SystemObjekt)soNachfordern).getSystemObject();
						} else{
							tmpNachfordern = null;
						}
						arrayNachfordern.getReferenceValue(i).setSystemObject(tmpNachfordern);
					}
				// GanzzahlAttributTyp
				if (getSichern() != null) {
	                if (getSichern().isZustand()) {
	                    datum.getUnscaledValue("Sichern").setText(getSichern().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Sichern").set(getSichern().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayQuittieren = datum.getReferenceArray("Quittieren");
					arrayQuittieren.setLength(getQuittieren().size());
					for (int i = 0; i < arrayQuittieren.getLength(); ++i) {
						final Object soQuittieren = getQuittieren().get(i);
						final SystemObject tmpQuittieren;
						if (soQuittieren instanceof SystemObject) {
							tmpQuittieren = (SystemObject)soQuittieren;
						} else if(soQuittieren instanceof SystemObjekt){
							tmpQuittieren = ((SystemObjekt)soQuittieren).getSystemObject();
						} else{
							tmpQuittieren = null;
						}
						arrayQuittieren.getReferenceValue(i).setSystemObject(tmpQuittieren);
					}
				// ZeitstempelAttributTyp
					datum.getTimeValue("Vorhalten").setMillis(getVorhalten().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Archivieren").isState()) {
							setArchivieren(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Archivieren").getText()));
						} else {
						setArchivieren(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Archivieren").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayNachfordern = daten.getReferenceArray("Nachfordern");
					for (int i = 0; i < arrayNachfordern.getLength(); ++i) {
						final long idNachfordern = daten.getReferenceArray("Nachfordern").getReferenceValue(i).getId();
						final SystemObjekt tmpNachfordern;
						if (idNachfordern == 0) {
							tmpNachfordern = null;
						} else {
							final SystemObject soNachfordern = factory.getDav().getDataModel().getObject(idNachfordern);
							if (soNachfordern == null) {
									tmpNachfordern = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.ArchivUngueltig(idNachfordern);
							} else {
								tmpNachfordern = factory.getModellobjekt(soNachfordern);
							}
						}
							getNachfordern().add((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Archiv
							) tmpNachfordern);
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Sichern").isState()) {
							setSichern(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Sichern").getText()));
						} else {
						setSichern(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Sichern").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayQuittieren = daten.getReferenceArray("Quittieren");
					for (int i = 0; i < arrayQuittieren.getLength(); ++i) {
						final long idQuittieren = daten.getReferenceArray("Quittieren").getReferenceValue(i).getId();
						final SystemObjekt tmpQuittieren;
						if (idQuittieren == 0) {
							tmpQuittieren = null;
						} else {
							final SystemObject soQuittieren = factory.getDav().getDataModel().getObject(idQuittieren);
							if (soQuittieren == null) {
									tmpQuittieren = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektUngueltig(idQuittieren);
							} else {
								tmpQuittieren = factory.getModellobjekt(soQuittieren);
							}
						}
							getQuittieren().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
							) tmpQuittieren);
					}
				// ZeitstempelAttributTyp
					setVorhalten(new
						RelativerZeitstempel
						(daten.getTimeValue("Vorhalten").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlEinstellungenArchiv clone() {
		AtlEinstellungenArchiv klon = new AtlEinstellungenArchiv();
		
						klon.setArchivieren(getArchivieren());
					klon._nachfordern = getNachfordern().clone();
						klon.setSichern(getSichern());
					klon._quittieren = getQuittieren().clone();
						klon.setVorhalten(getVorhalten());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
