/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste mit den Informationen und Zuständen einer Hintergrund-Task einer Applikation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 23
 */
public class AtlHintergrundTaskZustand implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _taskName
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskZustand
			 _taskZustand
			;
			private String
			 _taskFortschrittsBeschreibung
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskFortschrittswert
			 _taskFortschritt
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskFortschrittswert
			 _taskFortschrittMaximum
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskFortschrittswert
			 _taskFortschrittErgebnis
			;
	
		/**
		Name der Hintergrund-Task.
		<p>
		
		</p>
		
		@return der Wert von TaskName.
		*/
			public String
			 getTaskName() {
			return _taskName;
		}
	
		/**
		Name der Hintergrund-Task.
		<p>
		
		</p>
		
		@param _taskName der neue Wert von TaskName.
		*/
		public void setTaskName(String
		 _taskName) {
			if (_taskName.length() > 64) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 64 + " Zeichen sein.");
			}
			this._taskName = _taskName;
		}
	
		/**
		Zustand der Hintergrund-Task.
		<p>
		
		</p>
		
		@return der Wert von TaskZustand.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskZustand
			 getTaskZustand() {
			return _taskZustand;
		}
	
		/**
		Zustand der Hintergrund-Task.
		<p>
		
		</p>
		
		@param _taskZustand der neue Wert von TaskZustand.
		*/
		public void setTaskZustand(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskZustand
		 _taskZustand) {
			this._taskZustand = _taskZustand;
		}
	
		/**
		Textuelle Beschreibung der aktuell von der Hintergrund-Task durchgeführten Aktion mit entsprechenden Fortschrittswerten etc.
		<p>
		
		</p>
		
		@return der Wert von TaskFortschrittsBeschreibung.
		*/
			public String
			 getTaskFortschrittsBeschreibung() {
			return _taskFortschrittsBeschreibung;
		}
	
		/**
		Textuelle Beschreibung der aktuell von der Hintergrund-Task durchgeführten Aktion mit entsprechenden Fortschrittswerten etc.
		<p>
		
		</p>
		
		@param _taskFortschrittsBeschreibung der neue Wert von TaskFortschrittsBeschreibung.
		*/
		public void setTaskFortschrittsBeschreibung(String
		 _taskFortschrittsBeschreibung) {
			if (_taskFortschrittsBeschreibung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._taskFortschrittsBeschreibung = _taskFortschrittsBeschreibung;
		}
	
		/**
		Aktueller Fortschrittswert der aktuell von der Hintergrund-Task durchgeführten Aktion.
		<p>
		
		</p>
		
		@return der Wert von TaskFortschritt.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskFortschrittswert
			 getTaskFortschritt() {
			return _taskFortschritt;
		}
	
		/**
		Aktueller Fortschrittswert der aktuell von der Hintergrund-Task durchgeführten Aktion.
		<p>
		
		</p>
		
		@param _taskFortschritt der neue Wert von TaskFortschritt.
		*/
		public void setTaskFortschritt(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskFortschrittswert
		 _taskFortschritt) {
			this._taskFortschritt = _taskFortschritt;
		}
	
		/**
		Maximaler Fortschrittswert der aktuell von der Hintergrund-Task durchgeführten Aktion.
		<p>
		
		</p>
		
		@return der Wert von TaskFortschrittMaximum.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskFortschrittswert
			 getTaskFortschrittMaximum() {
			return _taskFortschrittMaximum;
		}
	
		/**
		Maximaler Fortschrittswert der aktuell von der Hintergrund-Task durchgeführten Aktion.
		<p>
		
		</p>
		
		@param _taskFortschrittMaximum der neue Wert von TaskFortschrittMaximum.
		*/
		public void setTaskFortschrittMaximum(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskFortschrittswert
		 _taskFortschrittMaximum) {
			this._taskFortschrittMaximum = _taskFortschrittMaximum;
		}
	
		/**
		Aktueller Ergebniswert der aktuell von der Hintergrund-Task durchgeführten Aktion.
		<p>
		
		</p>
		
		@return der Wert von TaskFortschrittErgebnis.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskFortschrittswert
			 getTaskFortschrittErgebnis() {
			return _taskFortschrittErgebnis;
		}
	
		/**
		Aktueller Ergebniswert der aktuell von der Hintergrund-Task durchgeführten Aktion.
		<p>
		
		</p>
		
		@param _taskFortschrittErgebnis der neue Wert von TaskFortschrittErgebnis.
		*/
		public void setTaskFortschrittErgebnis(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskFortschrittswert
		 _taskFortschrittErgebnis) {
			this._taskFortschrittErgebnis = _taskFortschrittErgebnis;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getTaskName() != null) {
					datum.getTextValue("TaskName").setText(getTaskName());
				}
				// GanzzahlAttributTyp
				if (getTaskZustand() != null) {
	                if (getTaskZustand().isZustand()) {
	                    datum.getUnscaledValue("TaskZustand").setText(getTaskZustand().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("TaskZustand").set(getTaskZustand().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getTaskFortschrittsBeschreibung() != null) {
					datum.getTextValue("TaskFortschrittsBeschreibung").setText(getTaskFortschrittsBeschreibung());
				}
				// GanzzahlAttributTyp
				if (getTaskFortschritt() != null) {
	                if (getTaskFortschritt().isZustand()) {
	                    datum.getUnscaledValue("TaskFortschritt").setText(getTaskFortschritt().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("TaskFortschritt").set(getTaskFortschritt().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getTaskFortschrittMaximum() != null) {
	                if (getTaskFortschrittMaximum().isZustand()) {
	                    datum.getUnscaledValue("TaskFortschrittMaximum").setText(getTaskFortschrittMaximum().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("TaskFortschrittMaximum").set(getTaskFortschrittMaximum().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getTaskFortschrittErgebnis() != null) {
	                if (getTaskFortschrittErgebnis().isZustand()) {
	                    datum.getUnscaledValue("TaskFortschrittErgebnis").setText(getTaskFortschrittErgebnis().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("TaskFortschrittErgebnis").set(getTaskFortschrittErgebnis().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setTaskName(daten.getTextValue("TaskName").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("TaskZustand").isState()) {
							setTaskZustand(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskZustand
							.getZustand(daten.getScaledValue("TaskZustand").getText()));
						} else {
						setTaskZustand(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskZustand
						(daten.
							getUnscaledValue
						("TaskZustand").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setTaskFortschrittsBeschreibung(daten.getTextValue("TaskFortschrittsBeschreibung").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("TaskFortschritt").isState()) {
							setTaskFortschritt(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskFortschrittswert
							.getZustand(daten.getScaledValue("TaskFortschritt").getText()));
						} else {
						setTaskFortschritt(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskFortschrittswert
						(daten.
							getUnscaledValue
						("TaskFortschritt").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("TaskFortschrittMaximum").isState()) {
							setTaskFortschrittMaximum(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskFortschrittswert
							.getZustand(daten.getScaledValue("TaskFortschrittMaximum").getText()));
						} else {
						setTaskFortschrittMaximum(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskFortschrittswert
						(daten.
							getUnscaledValue
						("TaskFortschrittMaximum").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("TaskFortschrittErgebnis").isState()) {
							setTaskFortschrittErgebnis(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskFortschrittswert
							.getZustand(daten.getScaledValue("TaskFortschrittErgebnis").getText()));
						} else {
						setTaskFortschrittErgebnis(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttTaskFortschrittswert
						(daten.
							getUnscaledValue
						("TaskFortschrittErgebnis").
								longValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlHintergrundTaskZustand clone() {
		AtlHintergrundTaskZustand klon = new AtlHintergrundTaskZustand();
		
						klon.setTaskName(getTaskName());
						klon.setTaskZustand(getTaskZustand());
						klon.setTaskFortschrittsBeschreibung(getTaskFortschrittsBeschreibung());
						klon.setTaskFortschritt(getTaskFortschritt());
						klon.setTaskFortschrittMaximum(getTaskFortschrittMaximum());
						klon.setTaskFortschrittErgebnis(getTaskFortschrittErgebnis());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
