/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Auswahl von Objekten über die Vorgabe von Objekten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 27
 */
public class AtlObjekte implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	Object
			> _objekt = new Feld<	Object
			>(0, true);
			@Defaultwert(wert = "")
			private String
			 _mengenbezeichnung
			= new String
			()
			;
	
		/**
		Referenz auf eine Region.
		<p>
		&lt;absatz&gt;
		                            Über dieses Array können beliebige Konfigurationsobjekte angegeben werden.
		                            Bei einem leeren Array sind alle Konfigurationsobjekte ausgewählt.
		                        &lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von Objekt.
		*/
			public Feld<	Object
			> getObjekt() {
			return _objekt;
		}
	
	
		/**
		Mengenname.
		<p>
		&lt;absatz&gt;
		                            Über die Vorgabe eines Mengennamens können die Objekte ausgewählt werden, die in Mengen dieses Namens
		                            bei den ausgewählten Objekten enthalten sind. Ist hier z.B. als Menge "FahrStreifen" angegeben,
		                            wird für alle bisher ausgewählten Objekte geprüft, ob an dem Konfigurationsobjekt eine Menge
		                            dieses Namens vorhanden ist und für diesen Fall werden die enthaltenen Konfigurationsobjekte betrachtet.
		                            Wenn hier keine Angabe erfolgt, bleibt die Auswahl bestehen.
		                         &lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von Mengenbezeichnung.
		*/
			public String
			 getMengenbezeichnung() {
			return _mengenbezeichnung;
		}
	
		/**
		Mengenname.
		<p>
		&lt;absatz&gt;
		                            Über die Vorgabe eines Mengennamens können die Objekte ausgewählt werden, die in Mengen dieses Namens
		                            bei den ausgewählten Objekten enthalten sind. Ist hier z.B. als Menge "FahrStreifen" angegeben,
		                            wird für alle bisher ausgewählten Objekte geprüft, ob an dem Konfigurationsobjekt eine Menge
		                            dieses Namens vorhanden ist und für diesen Fall werden die enthaltenen Konfigurationsobjekte betrachtet.
		                            Wenn hier keine Angabe erfolgt, bleibt die Auswahl bestehen.
		                         &lt;&#47;absatz&gt;
		</p>
		
		@param _mengenbezeichnung der neue Wert von Mengenbezeichnung.
		*/
		public void setMengenbezeichnung(String
		 _mengenbezeichnung) {
			if (_mengenbezeichnung.length() > 64) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 64 + " Zeichen sein.");
			}
			this._mengenbezeichnung = _mengenbezeichnung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayObjekt = datum.getReferenceArray("Objekt");
					arrayObjekt.setLength(getObjekt().size());
					for (int i = 0; i < arrayObjekt.getLength(); ++i) {
						final Object soObjekt = getObjekt().get(i);
						final SystemObject tmpObjekt;
						if (soObjekt instanceof SystemObject) {
							tmpObjekt = (SystemObject)soObjekt;
						} else if(soObjekt instanceof SystemObjekt){
							tmpObjekt = ((SystemObjekt)soObjekt).getSystemObject();
						} else{
							tmpObjekt = null;
						}
						arrayObjekt.getReferenceValue(i).setSystemObject(tmpObjekt);
					}
				// ZeichenkettenAttributTyp
				if (getMengenbezeichnung() != null) {
					datum.getTextValue("Mengenbezeichnung").setText(getMengenbezeichnung());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayObjekt = daten.getReferenceArray("Objekt");
					for (int i = 0; i < arrayObjekt.getLength(); ++i) {
						final long idObjekt = daten.getReferenceArray("Objekt").getReferenceValue(i).getId();
						final SystemObjekt tmpObjekt;
						if (idObjekt == 0) {
							tmpObjekt = null;
						} else {
							final SystemObject soObjekt = factory.getDav().getDataModel().getObject(idObjekt);
							if (soObjekt == null) {
									tmpObjekt = new BaseUngueltigesSystemObjekt(idObjekt);
							} else {
								tmpObjekt = factory.getModellobjekt(soObjekt);
							}
						}
							getObjekt().add((	Object
							) tmpObjekt);
					}
				// ZeichenkettenAttributTyp
					setMengenbezeichnung(daten.getTextValue("Mengenbezeichnung").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlObjekte clone() {
		AtlObjekte klon = new AtlObjekte();
		
					klon._objekt = getObjekt().clone();
						klon.setMengenbezeichnung(getMengenbezeichnung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
