/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält die Parameter für die Datenspezifikationen (Objekte, ATG, ASP, SimulationsVariante) und Einstellungen, mit der die
					Archivierung parametriert wird.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlParameterSatzArchiv implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			> _bereich = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlDatenSpezifikationArchiv
			> _datenSpezifikation = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlDatenSpezifikationArchiv
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlEinstellungenArchiv
			 _einstellungen
			= new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlEinstellungenArchiv
			()
			;
	
		/**
		Die in der folgenden Attributliste "Datenspezifikation" befindlichen Objekte beziehen sich auf einen in diesem Feld angegebenen
								Konfigurationsbereich (Kein Eintrag: Alle Konfigurationsbereiche).
		<p>
		
		</p>
		
		@return der Wert von Bereich.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			> getBereich() {
			return _bereich;
		}
	
	
		/**
		Mit dieser Attributliste wird spezifiziert, für welche Tupel bestehend aus Konfigurationsobjekt, Attributgruppe und Aspekt die
							folgenden Einstellungen gelten.
		<p>
		
		</p>
		
		@return der Wert von DatenSpezifikation.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlDatenSpezifikationArchiv
			> getDatenSpezifikation() {
			return _datenSpezifikation;
		}
	
	
		/**
		Diese Attributliste fasst die "eigentlichen" Parameter, wie die gemäß Datenspezifikation zu archivierenden Datensätze zu behandeln
							sind, zusamm.
		<p>
		
		</p>
		
		@return der Wert von Einstellungen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlEinstellungenArchiv
			 getEinstellungen() {
			return _einstellungen;
		}
	
		/**
		Diese Attributliste fasst die "eigentlichen" Parameter, wie die gemäß Datenspezifikation zu archivierenden Datensätze zu behandeln
							sind, zusamm.
		<p>
		
		</p>
		
		@param _einstellungen der neue Wert von Einstellungen.
		*/
		public void setEinstellungen(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlEinstellungenArchiv
		 _einstellungen) {
			this._einstellungen = _einstellungen;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayBereich = datum.getReferenceArray("Bereich");
					arrayBereich.setLength(getBereich().size());
					for (int i = 0; i < arrayBereich.getLength(); ++i) {
						final Object soBereich = getBereich().get(i);
						final SystemObject tmpBereich;
						if (soBereich instanceof SystemObject) {
							tmpBereich = (SystemObject)soBereich;
						} else if(soBereich instanceof SystemObjekt){
							tmpBereich = ((SystemObjekt)soBereich).getSystemObject();
						} else{
							tmpBereich = null;
						}
						arrayBereich.getReferenceValue(i).setSystemObject(tmpBereich);
					}
				// AttributListenDefinition
					final Data.Array arrayDatenSpezifikation = datum.getArray("DatenSpezifikation");
					arrayDatenSpezifikation.setLength(getDatenSpezifikation().size());
					for (int i = 0; i < arrayDatenSpezifikation.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlDatenSpezifikationArchiv
						 atl = getDatenSpezifikation().get(i);
						atl.bean2Atl(arrayDatenSpezifikation.getItem(i), factory);
	
					}
				// AttributListenDefinition
					getEinstellungen().bean2Atl(datum.getItem("Einstellungen"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayBereich = daten.getReferenceArray("Bereich");
					for (int i = 0; i < arrayBereich.getLength(); ++i) {
						final long idBereich = daten.getReferenceArray("Bereich").getReferenceValue(i).getId();
						final SystemObjekt tmpBereich;
						if (idBereich == 0) {
							tmpBereich = null;
						} else {
							final SystemObject soBereich = factory.getDav().getDataModel().getObject(idBereich);
							if (soBereich == null) {
									tmpBereich = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.KonfigurationsBereichUngueltig(idBereich);
							} else {
								tmpBereich = factory.getModellobjekt(soBereich);
							}
						}
							getBereich().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
							) tmpBereich);
					}
				// AttributListenDefinition
					final Data.Array arrayDatenSpezifikation = daten.getArray("DatenSpezifikation");
					for (int i = 0; i < arrayDatenSpezifikation.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlDatenSpezifikationArchiv
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlDatenSpezifikationArchiv
						 ();
						atl.atl2Bean(arrayDatenSpezifikation.getItem(i), factory);
						getDatenSpezifikation().add(atl);
					}
				// AttributListenDefinition
					getEinstellungen().atl2Bean(daten.getItem("Einstellungen"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlParameterSatzArchiv clone() {
		AtlParameterSatzArchiv klon = new AtlParameterSatzArchiv();
		
					klon._bereich = getBereich().clone();
					klon._datenSpezifikation = getDatenSpezifikation().clone();
						klon._einstellungen = getEinstellungen().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
