/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält jeweils die Referenz auf eine verbundene Applikation und die auf dieser Verbindung gemessene Telegrammlaufzeit.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTelegrammLaufzeit implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
			 _applikation
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttMilliSekunden
			 _laufzeit
			;
	
		/**
		Referenz auf die
								&lt;verweis pid="typ.applikation" txt="Applikation"&gt;&lt;&#47;verweis&gt;
		
								zu der die Telegrammlaufzeit gemessen wurde.
		<p>
		
		</p>
		
		@return der Wert von Applikation.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
			 getApplikation() {
			return _applikation;
		}
	
		/**
		Referenz auf die
								&lt;verweis pid="typ.applikation" txt="Applikation"&gt;&lt;&#47;verweis&gt;
		
								zu der die Telegrammlaufzeit gemessen wurde.
		<p>
		
		</p>
		
		@param _applikation der neue Wert von Applikation.
		*/
		public void setApplikation(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
		 _applikation) {
			this._applikation = _applikation;
		}
	
		/**
		Gemessene Telegrammlaufzeit.
		<p>
		
		</p>
		
		@return der Wert von Laufzeit.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttMilliSekunden
			 getLaufzeit() {
			return _laufzeit;
		}
	
		/**
		Gemessene Telegrammlaufzeit.
		<p>
		
		</p>
		
		@param _laufzeit der neue Wert von Laufzeit.
		*/
		public void setLaufzeit(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttMilliSekunden
		 _laufzeit) {
			this._laufzeit = _laufzeit;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soApplikation = getApplikation();
					final SystemObject tmpApplikation;
						if (soApplikation instanceof SystemObject) {
							tmpApplikation = (SystemObject)soApplikation;
						} else if(soApplikation instanceof SystemObjekt){
							tmpApplikation = ((SystemObjekt)soApplikation).getSystemObject();
						} else{
							tmpApplikation = null;
						}
					datum.getReferenceValue("applikation").setSystemObject(tmpApplikation);
				// GanzzahlAttributTyp
				if (getLaufzeit() != null) {
	                if (getLaufzeit().isZustand()) {
	                    datum.getUnscaledValue("laufzeit").setText(getLaufzeit().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("laufzeit").set(getLaufzeit().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idApplikation = daten.getReferenceValue("applikation").getId();
					final SystemObjekt tmpApplikation;
					if (idApplikation == 0) {
						tmpApplikation = null;
					} else {
						final SystemObject soApplikation = factory.getDav().getDataModel().getObject(idApplikation);
						if (soApplikation == null) {
								tmpApplikation = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.ApplikationUngueltig(idApplikation);
						} else {
							tmpApplikation = factory.getModellobjekt(soApplikation);
						}
					}
					setApplikation((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
					) tmpApplikation);
				// GanzzahlAttributTyp
						setLaufzeit(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttMilliSekunden
						(daten.
							getUnscaledValue
						("laufzeit").
								intValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTelegrammLaufzeit clone() {
		AtlTelegrammLaufzeit klon = new AtlTelegrammLaufzeit();
		
						klon.setApplikation(getApplikation());
						klon.setLaufzeit(getLaufzeit());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
