/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste zur Zuordnung von dynamischen Objekttypen zu Konfigurationsbereichen zur Verwaltung dynamischer Objekte.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 22
 */
public class AtlZuordnungDynamischerObjektTypZuKB implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.DynamischerTyp
			 _dynamischerTypReferenz
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			 _konfigurationsBereichReferenz
			;
	
		/**
		Referenz auf einen Dynamischen Objekttyp.
		<p>
		
		</p>
		
		@return der Wert von DynamischerTypReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.DynamischerTyp
			 getDynamischerTypReferenz() {
			return _dynamischerTypReferenz;
		}
	
		/**
		Referenz auf einen Dynamischen Objekttyp.
		<p>
		
		</p>
		
		@param _dynamischerTypReferenz der neue Wert von DynamischerTypReferenz.
		*/
		public void setDynamischerTypReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.DynamischerTyp
		 _dynamischerTypReferenz) {
			this._dynamischerTypReferenz = _dynamischerTypReferenz;
		}
	
		/**
		Referenz auf einen KonfigurationsBereich.
		<p>
		
		</p>
		
		@return der Wert von KonfigurationsBereichReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			 getKonfigurationsBereichReferenz() {
			return _konfigurationsBereichReferenz;
		}
	
		/**
		Referenz auf einen KonfigurationsBereich.
		<p>
		
		</p>
		
		@param _konfigurationsBereichReferenz der neue Wert von KonfigurationsBereichReferenz.
		*/
		public void setKonfigurationsBereichReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
		 _konfigurationsBereichReferenz) {
			this._konfigurationsBereichReferenz = _konfigurationsBereichReferenz;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soDynamischerTypReferenz = getDynamischerTypReferenz();
					final SystemObject tmpDynamischerTypReferenz;
						if (soDynamischerTypReferenz instanceof SystemObject) {
							tmpDynamischerTypReferenz = (SystemObject)soDynamischerTypReferenz;
						} else if(soDynamischerTypReferenz instanceof SystemObjekt){
							tmpDynamischerTypReferenz = ((SystemObjekt)soDynamischerTypReferenz).getSystemObject();
						} else{
							tmpDynamischerTypReferenz = null;
						}
					datum.getReferenceValue("DynamischerTypReferenz").setSystemObject(tmpDynamischerTypReferenz);
				// ObjektReferenzAttributTyp
					final Object soKonfigurationsBereichReferenz = getKonfigurationsBereichReferenz();
					final SystemObject tmpKonfigurationsBereichReferenz;
						if (soKonfigurationsBereichReferenz instanceof SystemObject) {
							tmpKonfigurationsBereichReferenz = (SystemObject)soKonfigurationsBereichReferenz;
						} else if(soKonfigurationsBereichReferenz instanceof SystemObjekt){
							tmpKonfigurationsBereichReferenz = ((SystemObjekt)soKonfigurationsBereichReferenz).getSystemObject();
						} else{
							tmpKonfigurationsBereichReferenz = null;
						}
					datum.getReferenceValue("KonfigurationsBereichReferenz").setSystemObject(tmpKonfigurationsBereichReferenz);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idDynamischerTypReferenz = daten.getReferenceValue("DynamischerTypReferenz").getId();
					final SystemObjekt tmpDynamischerTypReferenz;
					if (idDynamischerTypReferenz == 0) {
						tmpDynamischerTypReferenz = null;
					} else {
						final SystemObject soDynamischerTypReferenz = factory.getDav().getDataModel().getObject(idDynamischerTypReferenz);
						if (soDynamischerTypReferenz == null) {
								tmpDynamischerTypReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.DynamischerTypUngueltig(idDynamischerTypReferenz);
						} else {
							tmpDynamischerTypReferenz = factory.getModellobjekt(soDynamischerTypReferenz);
						}
					}
					setDynamischerTypReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.DynamischerTyp
					) tmpDynamischerTypReferenz);
				// ObjektReferenzAttributTyp
					final long idKonfigurationsBereichReferenz = daten.getReferenceValue("KonfigurationsBereichReferenz").getId();
					final SystemObjekt tmpKonfigurationsBereichReferenz;
					if (idKonfigurationsBereichReferenz == 0) {
						tmpKonfigurationsBereichReferenz = null;
					} else {
						final SystemObject soKonfigurationsBereichReferenz = factory.getDav().getDataModel().getObject(idKonfigurationsBereichReferenz);
						if (soKonfigurationsBereichReferenz == null) {
								tmpKonfigurationsBereichReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.KonfigurationsBereichUngueltig(idKonfigurationsBereichReferenz);
						} else {
							tmpKonfigurationsBereichReferenz = factory.getModellobjekt(soKonfigurationsBereichReferenz);
						}
					}
					setKonfigurationsBereichReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
					) tmpKonfigurationsBereichReferenz);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlZuordnungDynamischerObjektTypZuKB clone() {
		AtlZuordnungDynamischerObjektTypZuKB klon = new AtlZuordnungDynamischerObjektTypZuKB();
		
						klon.setDynamischerTypReferenz(getDynamischerTypReferenz());
						klon.setKonfigurationsBereichReferenz(getKonfigurationsBereichReferenz());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
