/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributtyp, der zur Unterscheidung der verschiedenen Nachrichten bei der Abwicklung von Archivanfragen dient.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 32
 */
public class AttArchivNachrichtenTyp extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Kennzeichnet Anfragen an das Archivsystem.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_1_ANFRAGE = new AttArchivNachrichtenTyp("Anfrage", 		Byte
	.valueOf("1"));

	/**
	Kennzeichnet die initiale Ergebnismeldung des Archivsystems zu einer Archivanfrage.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_2_ANFRAGEERGEBNIS = new AttArchivNachrichtenTyp("AnfrageErgebnis", 		Byte
	.valueOf("2"));

	/**
	Kennzeichnet die einem Stream zugeordneten Ergebnisdatenpakete des Archivsystems.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_3_STREAMDATEN = new AttArchivNachrichtenTyp("StreamDaten", 		Byte
	.valueOf("3"));

	/**
	Kennzeichnet Steuerungspakete, die zwecks Flußkontrolle an dass Archivsystem gesendet werden.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_4_STREAMSTEUERUNG = new AttArchivNachrichtenTyp("StreamSteuerung", 		Byte
	.valueOf("4"));

	/**
	Kennzeichnet Informationsanfragen an das Archivsystem.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_5_INFORMATIONSANFRAGE = new AttArchivNachrichtenTyp("Informationsanfrage", 		Byte
	.valueOf("5"));

	/**
	Kennzeichnet die Antwort auf eine Informationsanfragen, die an das Archivsystem gestellt wurde.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_6_INFORMATIONSANFRAGEERGEBNIS = new AttArchivNachrichtenTyp("InformationsanfrageErgebnis", 		Byte
	.valueOf("6"));

	/**
	Kennzeichnet einen Auftrag, der Archivdaten löscht.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_7_LOESCHAUFTRAG = new AttArchivNachrichtenTyp("Löschauftrag", 		Byte
	.valueOf("7"));

	/**
	Kennzeichnet das Ergebnis eines Auftrags, der Archivdaten löschen sollte.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_8_LOESCHAUFTRAGERGEBNIS = new AttArchivNachrichtenTyp("LöschauftragErgebnis", 		Byte
	.valueOf("8"));

	/**
	Kennzeichnet einen Auftrag, der Archivdaten speichert.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_9_SPEICHERAUFTRAG = new AttArchivNachrichtenTyp("SpeicherAuftrag", 		Byte
	.valueOf("9"));

	/**
	Kennzeichnet das Ergebnis eines Auftrags, der Archivdaten speichern sollte.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_10_SPEICHERAUFTRAGERGEBNIS = new AttArchivNachrichtenTyp("SpeicherAuftragErgebnis", 		Byte
	.valueOf("10"));

	/**
	Kennzeichnet einen Auftrag, der Archivdaten wiederherstellt.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_11_WIEDERHERSTELLENAUFTRAG = new AttArchivNachrichtenTyp("WiederherstellenAuftrag", 		Byte
	.valueOf("11"));

	/**
	Kennzeichnet das Ergebnis eines Auftrags, der Archivdaten wiederherstellen sollte.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_12_WIEDERHERSTELLENAUFTRAGERGEBNIS = new AttArchivNachrichtenTyp("WiederherstellenAuftragErgebnis", 		Byte
	.valueOf("12"));

	/**
	Auftrag zur Änderung des Löschzeitpunkts.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_13_LOESCHZEITPUNKTAENDERUNG = new AttArchivNachrichtenTyp("LöschzeitpunktÄnderung", 		Byte
	.valueOf("13"));

	/**
	Ergebnis eines Auftrags zur Änderung des Löschzeitpunkts.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_14_LOESCHZEITPUNKTAENDERUNGERGEBNIS = new AttArchivNachrichtenTyp("LöschzeitpunktÄnderungErgebnis", 		Byte
	.valueOf("14"));

	/**
	Auftrag zum Abgleich der Verwaltungsinformationen mit einem Medium von Typ "B".
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_15_VERWALTUNGSINFORMATIONSABGLEICH = new AttArchivNachrichtenTyp("VerwaltungsinformationsAbgleich", 		Byte
	.valueOf("15"));

	/**
	Ergebnis der Verwaltungsinformationsabgleichs.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_16_VERWALTUNGSINFORMATIONSABGLEICHERGEBNIS = new AttArchivNachrichtenTyp("VerwaltungsinformationsAbgleichErgebnis", 		Byte
	.valueOf("16"));

	/**
	Nachforderungsauftrag unter Angabe der Datenidentifikationen und der Archivsysteme.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_17_NACHFORDERUNGMITARCHIVSYSTEMEN = new AttArchivNachrichtenTyp("NachforderungMitArchivsystemen", 		Byte
	.valueOf("17"));

	/**
	Ergebnis des Nachforderungsauftrag s mit Angabe der Datenidentifikationen und der Archivsysteme.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_18_NACHFORDERUNGMITARCHIVSYSTEMENERGEBNIS = new AttArchivNachrichtenTyp("NachforderungMitArchivsystemenErgebnis", 		Byte
	.valueOf("18"));

	/**
	Nachforderungsauftrag unter Angabe der Archivsysteme.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_19_NACHFORDERUNGOHNEDI = new AttArchivNachrichtenTyp("NachforderungOhneDI", 		Byte
	.valueOf("19"));

	/**
	Ergebnis des Nachforderungsauftrag mit Angabe der Archivsysteme.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_20_NACHFORDERUNGOHNEDIERGEBNIS = new AttArchivNachrichtenTyp("NachforderungOhneDIErgebnis", 		Byte
	.valueOf("20"));

	/**
	Anfrage (maximale) Anzahl Archivanfragen pro Applikation.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_21_ARCHIVANFRAGENPROAPPLIKATION = new AttArchivNachrichtenTyp("ArchivanfragenProApplikation", 		Byte
	.valueOf("21"));

	/**
	Ergebnis (maximale) Anzahl Archivanfragen pro Applikation.
	<p>
	
	</p>
	*/
	public static final AttArchivNachrichtenTyp ZUSTAND_22_ARCHIVANFRAGENPROAPPLIKATIONERGEBNIS = new AttArchivNachrichtenTyp("ArchivanfragenProApplikationErgebnis", 		Byte
	.valueOf("22"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttArchivNachrichtenTyp getZustand(final 		Byte
	 value) {
		for (AttArchivNachrichtenTyp e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttArchivNachrichtenTyp getZustand(final String value) {
		for (AttArchivNachrichtenTyp e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttArchivNachrichtenTyp> getZustaende() {
		List<AttArchivNachrichtenTyp> list = new ArrayList<AttArchivNachrichtenTyp>();
		list.add(ZUSTAND_1_ANFRAGE);
		list.add(ZUSTAND_2_ANFRAGEERGEBNIS);
		list.add(ZUSTAND_3_STREAMDATEN);
		list.add(ZUSTAND_4_STREAMSTEUERUNG);
		list.add(ZUSTAND_5_INFORMATIONSANFRAGE);
		list.add(ZUSTAND_6_INFORMATIONSANFRAGEERGEBNIS);
		list.add(ZUSTAND_7_LOESCHAUFTRAG);
		list.add(ZUSTAND_8_LOESCHAUFTRAGERGEBNIS);
		list.add(ZUSTAND_9_SPEICHERAUFTRAG);
		list.add(ZUSTAND_10_SPEICHERAUFTRAGERGEBNIS);
		list.add(ZUSTAND_11_WIEDERHERSTELLENAUFTRAG);
		list.add(ZUSTAND_12_WIEDERHERSTELLENAUFTRAGERGEBNIS);
		list.add(ZUSTAND_13_LOESCHZEITPUNKTAENDERUNG);
		list.add(ZUSTAND_14_LOESCHZEITPUNKTAENDERUNGERGEBNIS);
		list.add(ZUSTAND_15_VERWALTUNGSINFORMATIONSABGLEICH);
		list.add(ZUSTAND_16_VERWALTUNGSINFORMATIONSABGLEICHERGEBNIS);
		list.add(ZUSTAND_17_NACHFORDERUNGMITARCHIVSYSTEMEN);
		list.add(ZUSTAND_18_NACHFORDERUNGMITARCHIVSYSTEMENERGEBNIS);
		list.add(ZUSTAND_19_NACHFORDERUNGOHNEDI);
		list.add(ZUSTAND_20_NACHFORDERUNGOHNEDIERGEBNIS);
		list.add(ZUSTAND_21_ARCHIVANFRAGENPROAPPLIKATION);
		list.add(ZUSTAND_22_ARCHIVANFRAGENPROAPPLIKATIONERGEBNIS);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut ArchivNachrichtenTyp.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttArchivNachrichtenTyp(final 		Byte
	 value) {
		super(value);
	}
	
	private AttArchivNachrichtenTyp(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
