/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributtyp, der zur Unterscheidung der verschiedenen Nachrichten bei der Abwicklung von Konfigurationsanfragen(Benutzerverwaltung)
					dient.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttKonfigurationsBenutzerverwaltungsNachrichtenTyp extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Kennzeichnet einen Auftrag an die Benutzerverwaltung.
	<p>
	Ein verschlüsselter Auftrag, der an die Benutzerverwaltung(Konfiguration) geschickt wird. Es können folgende Aktionen angestoßen
								werden: Passwort ändern, Rechte eines Benutzers ändern, Einmal-Passwörter erzeugen, neue Benutzer anlegen
	</p>
	*/
	public static final AttKonfigurationsBenutzerverwaltungsNachrichtenTyp ZUSTAND_1_AUFTRAGBENUTZERVERWALTUNG = new AttKonfigurationsBenutzerverwaltungsNachrichtenTyp("AuftragBenutzerverwaltung", 		Byte
	.valueOf("1"));

	/**
	Kennzeichnet eine positive Antwort auf einen Auftrag, der an die Benutzerverwaltung verschickt wurde.
	<p>
	Positive Antwort auf einen Auftrag, der mit "AuftragBenutzerverwaltung" verschickt wurde. Konnte der Auftrag nicht ausgeführt werden
								(keine Rechte des Benutzers den Auftrag anzustoßen, usw.), wird ein Telegramm mit dem Typ "FehlerAntwort" verschickt.
	</p>
	*/
	public static final AttKonfigurationsBenutzerverwaltungsNachrichtenTyp ZUSTAND_2_AUFTRAGBENUTZERVERWALTUNGANTWORT = new AttKonfigurationsBenutzerverwaltungsNachrichtenTyp("AuftragBenutzerverwaltungAntwort", 		Byte
	.valueOf("2"));

	/**
	Kennzeichnet einen Auftrag einen Zufallstext durch die Benutzerverwaltung zu erzeugen.
	<p>
	Beauftragt die Benutzerverwaltung(Konfiguration) einen Zufallstext zu erzeugen und diesen mit einem Telegramm vom Typ
								"AuftragZufallstextAntwort" zu verschicken.
	</p>
	*/
	public static final AttKonfigurationsBenutzerverwaltungsNachrichtenTyp ZUSTAND_3_AUFTRAGZUFALLSTEXT = new AttKonfigurationsBenutzerverwaltungsNachrichtenTyp("AuftragZufallstext", 		Byte
	.valueOf("3"));

	/**
	Kennzeichnet eine positive Antwort auf einen Auftrag einen Zufallstext durch die Benutzerverwaltung zu erzeugen.
	<p>
	Antwort, die einen Zufallstext enthält, die durch die Benutzerverwaltung (Konfiguration) erzeugt wurde. Konnte der Zufallstext nicht
								erzeugt werden, wird ein Telegramm vom Typ "FehlerAntwort" verschickt.
	</p>
	*/
	public static final AttKonfigurationsBenutzerverwaltungsNachrichtenTyp ZUSTAND_4_AUFTRAGZUFALLSTEXTANTWORT = new AttKonfigurationsBenutzerverwaltungsNachrichtenTyp("AuftragZufallstextAntwort", 		Byte
	.valueOf("4"));

	/**
	Kennzeichnet Antworten mit einem Fehlertext bei fehlgeschlagenen Anfragen.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsBenutzerverwaltungsNachrichtenTyp ZUSTAND_5_FEHLERANTWORT = new AttKonfigurationsBenutzerverwaltungsNachrichtenTyp("FehlerAntwort", 		Byte
	.valueOf("5"));

	/**
	Negative Antwort auf einen Auftrag, der der Konfiguration erteilt wurde.
	<p>
	Diese Nachricht wird verschickt, wenn die Konfiguration einen Auftrag nicht ausführt, weil gewisse Randbediengungen nicht erfüllt
								sind. So kann der Auftraggeber nicht die nötigen Rechte besitzen einen Auftrag zu erteilen oder das übergebene Passwort ist falsch,
								usw..
	</p>
	*/
	public static final AttKonfigurationsBenutzerverwaltungsNachrichtenTyp ZUSTAND_6_KONFIGURATIONSAUFTRAGVERWEIGERT = new AttKonfigurationsBenutzerverwaltungsNachrichtenTyp("KonfigurationsauftragVerweigert", 		Byte
	.valueOf("6"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttKonfigurationsBenutzerverwaltungsNachrichtenTyp getZustand(final 		Byte
	 value) {
		for (AttKonfigurationsBenutzerverwaltungsNachrichtenTyp e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttKonfigurationsBenutzerverwaltungsNachrichtenTyp getZustand(final String value) {
		for (AttKonfigurationsBenutzerverwaltungsNachrichtenTyp e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttKonfigurationsBenutzerverwaltungsNachrichtenTyp> getZustaende() {
		List<AttKonfigurationsBenutzerverwaltungsNachrichtenTyp> list = new ArrayList<AttKonfigurationsBenutzerverwaltungsNachrichtenTyp>();
		list.add(ZUSTAND_1_AUFTRAGBENUTZERVERWALTUNG);
		list.add(ZUSTAND_2_AUFTRAGBENUTZERVERWALTUNGANTWORT);
		list.add(ZUSTAND_3_AUFTRAGZUFALLSTEXT);
		list.add(ZUSTAND_4_AUFTRAGZUFALLSTEXTANTWORT);
		list.add(ZUSTAND_5_FEHLERANTWORT);
		list.add(ZUSTAND_6_KONFIGURATIONSAUFTRAGVERWEIGERT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut KonfigurationsBenutzerverwaltungsNachrichtenTyp.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttKonfigurationsBenutzerverwaltungsNachrichtenTyp(final 		Byte
	 value) {
		super(value);
	}
	
	private AttKonfigurationsBenutzerverwaltungsNachrichtenTyp(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
