/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributtyp, der zur Unterscheidung der verschiedenen Nachrichten bei der Abwicklung von Konfigurationsanfragen dient.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttKonfigurationsNachrichtenTyp extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Kennzeichnet Anfragen nach grundlegenden Objektinformationen zu den angegebenen Objekt-Ids.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsNachrichtenTyp ZUSTAND_1_OBJEKTANFRAGEMITID = new AttKonfigurationsNachrichtenTyp("ObjektAnfrageMitId", 		Byte
	.valueOf("1"));

	/**
	Kennzeichnet Anfragen nach grundlegenden Objektinformationen zu den angegebenen Objekt-Pids.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsNachrichtenTyp ZUSTAND_2_OBJEKTANFRAGEMITPID = new AttKonfigurationsNachrichtenTyp("ObjektAnfrageMitPid", 		Byte
	.valueOf("2"));

	/**
	Kennzeichnet Antworten mit grundlegenden Objektinformationen zu angefragten Objekten.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsNachrichtenTyp ZUSTAND_3_OBJEKTANTWORT = new AttKonfigurationsNachrichtenTyp("ObjektAntwort", 		Byte
	.valueOf("3"));

	/**
	Kennzeichnet Antworten mit einem Fehlertext bei fehlgeschlagen Anfragen.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsNachrichtenTyp ZUSTAND_4_FEHLERANTWORT = new AttKonfigurationsNachrichtenTyp("FehlerAntwort", 		Byte
	.valueOf("4"));

	/**
	Kennzeichnet Anfragen nach allen Elementen einer Dynamischen Menge.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsNachrichtenTyp ZUSTAND_5_DYNAMISCHEMENGEALLEELEMENTEANFRAGE = new AttKonfigurationsNachrichtenTyp("DynamischeMengeAlleElementeAnfrage", 		Byte
	.valueOf("5"));

	/**
	Kennzeichnet Antworten mit allen Elementen einer Dynamischen Menge.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsNachrichtenTyp ZUSTAND_6_DYNAMISCHEMENGEALLEELEMENTEANTWORT = new AttKonfigurationsNachrichtenTyp("DynamischeMengeAlleElementeAntwort", 		Byte
	.valueOf("6"));

	/**
	Kennzeichnet Änderungen einer Dynamischen Menge.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsNachrichtenTyp ZUSTAND_7_DYNAMISCHEMENGEELEMENTEAENDERN = new AttKonfigurationsNachrichtenTyp("DynamischeMengeElementeÄndern", 		Byte
	.valueOf("7"));

	/**
	Kennzeichnet Antworten zu Änderungen einer Dynamischen Menge.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsNachrichtenTyp ZUSTAND_8_DYNAMISCHEMENGEELEMENTEANTWORT = new AttKonfigurationsNachrichtenTyp("DynamischeMengeElementeAntwort", 		Byte
	.valueOf("8"));

	/**
	Kennzeichnet das Anmelden eines Beobachters an einer Dynamischen Menge.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsNachrichtenTyp ZUSTAND_9_DYNAMISCHEMENGEBEOBACHTERANMELDEN = new AttKonfigurationsNachrichtenTyp("DynamischeMengeBeobachterAnmelden", 		Byte
	.valueOf("9"));

	/**
	Kennzeichnet das Abmelden eines Beobachters von einer Dynamischen Menge.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsNachrichtenTyp ZUSTAND_10_DYNAMISCHEMENGEBEOBACHTERABMELDEN = new AttKonfigurationsNachrichtenTyp("DynamischeMengeBeobachterAbmelden", 		Byte
	.valueOf("10"));

	/**
	Kennzeichnet das Aktualisieren von Dynamischen Mengen.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsNachrichtenTyp ZUSTAND_11_DYNAMISCHEMENGEAKTUALISIERUNG = new AttKonfigurationsNachrichtenTyp("DynamischeMengeAktualisierung", 		Byte
	.valueOf("11"));

	/**
	Kennzeichnet Anfragen nach konfigurierenden Datensätzen.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsNachrichtenTyp ZUSTAND_12_DATENSATZANFRAGE = new AttKonfigurationsNachrichtenTyp("DatensatzAnfrage", 		Byte
	.valueOf("12"));

	/**
	Kennzeichnet eine Antwort mit einem konfigurierenden Datensatz.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsNachrichtenTyp ZUSTAND_13_DATENSATZANTWORT = new AttKonfigurationsNachrichtenTyp("DatensatzAntwort", 		Byte
	.valueOf("13"));

	/**
	Kennzeichnet einen Auftrag an die Benutzerverwaltung.
	<p>
	Ein verschlüsselter Auftrag, der an die Benutzerverwaltung(Konfiguration) geschickt wird. Es können folgende Aktionen angestoßen
								werden: Passwort ändern, Rechte eines Benutzers ändern, Einmal-Passwörter erzeugen, neue Benutzer anlegen
	</p>
	*/
	public static final AttKonfigurationsNachrichtenTyp ZUSTAND_14_AUFTRAGBENUTZERVERWALTUNG = new AttKonfigurationsNachrichtenTyp("AuftragBenutzerverwaltung", 		Byte
	.valueOf("14"));

	/**
	Kennzeichnet eine positive Antwort auf einen Auftrag, der an die Benutzerverwaltung verschickt wurde.
	<p>
	Positive Antwort auf einen Auftrag, der mit "AuftragBenutzerverwaltung" verschickt wurde. Konnte der Auftrag nicht ausgeführt werden
								(keine Rechte des Benutzers den Auftrag anzustoßen, usw.), wird ein Telegramm mit dem Typ "FehlerAntwort" verschickt.
	</p>
	*/
	public static final AttKonfigurationsNachrichtenTyp ZUSTAND_15_AUFTRAGBENUTZERVERWALTUNGANTWORT = new AttKonfigurationsNachrichtenTyp("AuftragBenutzerverwaltungAntwort", 		Byte
	.valueOf("15"));

	/**
	Kennzeichnet einen Auftrag einen Zufallstext durch die Benutzerverwaltung zu erzeugen.
	<p>
	Beauftragt die Benutzerverwaltung(Konfiguration) einen Zufallstext zu erzeugen und diesen mit einem Telegramm vom Typ
								"AuftragZufallstextAntwort" zu verschicken.
	</p>
	*/
	public static final AttKonfigurationsNachrichtenTyp ZUSTAND_16_AUFTRAGZUFALLSTEXT = new AttKonfigurationsNachrichtenTyp("AuftragZufallstext", 		Byte
	.valueOf("16"));

	/**
	Kennzeichnet eine positive Antwort auf einen Auftrag einen Zufallstext durch die Benutzerverwaltung zu erzeugen.
	<p>
	Antwort, die einen Zufallstext enthält, die durch die Benutzerverwaltung (Konfiguration) erzeugt wurde. Konnte der Zufallstext nicht
								erzeugt werden, wird ein Telegramm vom Typ "FehlerAntwort" verschickt.
	</p>
	*/
	public static final AttKonfigurationsNachrichtenTyp ZUSTAND_17_AUFTRAGZUFALLSTEXTANTWORT = new AttKonfigurationsNachrichtenTyp("AuftragZufallstextAntwort", 		Byte
	.valueOf("17"));

	/**
	Kennzeichnet Änderungen einer konfigurierende Menge.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsNachrichtenTyp ZUSTAND_18_KONFIGURIERENDEMENGEELEMENTEAENDERN = new AttKonfigurationsNachrichtenTyp("KonfigurierendeMengeElementeÄndern", 		Byte
	.valueOf("18"));

	/**
	Kennzeichnet Antworten zu Änderungen einer konfigurierende Menge.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsNachrichtenTyp ZUSTAND_19_KONFIGURIERENDEMENGEELEMENTEANTWORT = new AttKonfigurationsNachrichtenTyp("KonfigurierendeMengeElementeAntwort", 		Byte
	.valueOf("19"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttKonfigurationsNachrichtenTyp getZustand(final 		Byte
	 value) {
		for (AttKonfigurationsNachrichtenTyp e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttKonfigurationsNachrichtenTyp getZustand(final String value) {
		for (AttKonfigurationsNachrichtenTyp e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttKonfigurationsNachrichtenTyp> getZustaende() {
		List<AttKonfigurationsNachrichtenTyp> list = new ArrayList<AttKonfigurationsNachrichtenTyp>();
		list.add(ZUSTAND_1_OBJEKTANFRAGEMITID);
		list.add(ZUSTAND_2_OBJEKTANFRAGEMITPID);
		list.add(ZUSTAND_3_OBJEKTANTWORT);
		list.add(ZUSTAND_4_FEHLERANTWORT);
		list.add(ZUSTAND_5_DYNAMISCHEMENGEALLEELEMENTEANFRAGE);
		list.add(ZUSTAND_6_DYNAMISCHEMENGEALLEELEMENTEANTWORT);
		list.add(ZUSTAND_7_DYNAMISCHEMENGEELEMENTEAENDERN);
		list.add(ZUSTAND_8_DYNAMISCHEMENGEELEMENTEANTWORT);
		list.add(ZUSTAND_9_DYNAMISCHEMENGEBEOBACHTERANMELDEN);
		list.add(ZUSTAND_10_DYNAMISCHEMENGEBEOBACHTERABMELDEN);
		list.add(ZUSTAND_11_DYNAMISCHEMENGEAKTUALISIERUNG);
		list.add(ZUSTAND_12_DATENSATZANFRAGE);
		list.add(ZUSTAND_13_DATENSATZANTWORT);
		list.add(ZUSTAND_14_AUFTRAGBENUTZERVERWALTUNG);
		list.add(ZUSTAND_15_AUFTRAGBENUTZERVERWALTUNGANTWORT);
		list.add(ZUSTAND_16_AUFTRAGZUFALLSTEXT);
		list.add(ZUSTAND_17_AUFTRAGZUFALLSTEXTANTWORT);
		list.add(ZUSTAND_18_KONFIGURIERENDEMENGEELEMENTEAENDERN);
		list.add(ZUSTAND_19_KONFIGURIERENDEMENGEELEMENTEANTWORT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut KonfigurationsNachrichtenTyp.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttKonfigurationsNachrichtenTyp(final 		Byte
	 value) {
		super(value);
	}
	
	private AttKonfigurationsNachrichtenTyp(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
