/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zur Übermittlung von Archiv-Anfragen an die Datenhaltung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdArchivAnfrage extends AbstractOnlineDatensatz<OdArchivAnfrage.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Anfrage,
				};
			}
	
			/**
			 * Wird zur Anfrage von Informationen benutzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Anfrage = new Aspekte("Anfrage", "asp.anfrage");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
				 _absenderId
				;
				private String
				 _absenderZeichen
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				 _anfrageTyp
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> _anfrage = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				>(0, true);
		
			/**
			Objekt-ID der anfragenden Applikation.
			<p>
			Die Antworten der Datenhaltung werden mit dieser Objekt-ID über den Datenverteiler versendet.
			</p>
			
			@return der Wert von AbsenderId.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
				 getAbsenderId() {
				return _absenderId;
			}
		
			/**
			Objekt-ID der anfragenden Applikation.
			<p>
			Die Antworten der Datenhaltung werden mit dieser Objekt-ID über den Datenverteiler versendet.
			</p>
			
			@param _absenderId der neue Wert von AbsenderId.
			*/
			public void setAbsenderId(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
			 _absenderId) {
				this._absenderId = _absenderId;
			}
		
			/**
			Kennzeichnung, die von der anfragenden Applikation beliebig vergeben wird.
			<p>
			Der angegebene Wert wird von der Datenhaltung in die Antwort zu dieser Anfrage kopiert. Die Bedeutung des Attributs wird von
									der anfragenden Applikation beliebig festgelegt und kann zum Beispiel dazu benutzt werden, um eine empfangene Antwort der ursprünglichen
									Anfrage zuzuordnen.
			</p>
			
			@return der Wert von AbsenderZeichen.
			*/
				public String
				 getAbsenderZeichen() {
				return _absenderZeichen;
			}
		
			/**
			Kennzeichnung, die von der anfragenden Applikation beliebig vergeben wird.
			<p>
			Der angegebene Wert wird von der Datenhaltung in die Antwort zu dieser Anfrage kopiert. Die Bedeutung des Attributs wird von
									der anfragenden Applikation beliebig festgelegt und kann zum Beispiel dazu benutzt werden, um eine empfangene Antwort der ursprünglichen
									Anfrage zuzuordnen.
			</p>
			
			@param _absenderZeichen der neue Wert von AbsenderZeichen.
			*/
			public void setAbsenderZeichen(String
			 _absenderZeichen) {
				if (_absenderZeichen.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._absenderZeichen = _absenderZeichen;
			}
		
			/**
			Typ der Archivanfrage.
			<p>
			
			</p>
			
			@return der Wert von AnfrageTyp.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				 getAnfrageTyp() {
				return _anfrageTyp;
			}
		
			/**
			Typ der Archivanfrage.
			<p>
			
			</p>
			
			@param _anfrageTyp der neue Wert von AnfrageTyp.
			*/
			public void setAnfrageTyp(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
			 _anfrageTyp) {
				this._anfrageTyp = _anfrageTyp;
			}
		
			/**
			Daten der Archivanfrage.
			<p>
			
			</p>
			
			@return der Wert von Anfrage.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> getAnfrage() {
				return _anfrage;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soAbsenderId = getAbsenderId();
						final SystemObject tmpAbsenderId;
							if (soAbsenderId instanceof SystemObject) {
								tmpAbsenderId = (SystemObject)soAbsenderId;
							} else if(soAbsenderId instanceof SystemObjekt){
								tmpAbsenderId = ((SystemObjekt)soAbsenderId).getSystemObject();
							} else{
								tmpAbsenderId = null;
							}
						datum.getReferenceValue("absenderId").setSystemObject(tmpAbsenderId);
					// ZeichenkettenAttributTyp
					if (getAbsenderZeichen() != null) {
						datum.getTextValue("absenderZeichen").setText(getAbsenderZeichen());
					}
					// GanzzahlAttributTyp
					if (getAnfrageTyp() != null) {
		                if (getAnfrageTyp().isZustand()) {
		                    datum.getUnscaledValue("anfrageTyp").setText(getAnfrageTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("anfrageTyp").set(getAnfrageTyp().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnfrage() != null) {
						final Data.NumberArray arrayAnfrage = datum.
							getUnscaledArray
							("anfrage");
						arrayAnfrage.setLength(getAnfrage().size());
						for (int i = 0; i < arrayAnfrage.getLength(); ++i) {
							arrayAnfrage.getValue(i).set(getAnfrage().get(i).getValue());
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idAbsenderId = daten.getReferenceValue("absenderId").getId();
						final SystemObjekt tmpAbsenderId;
						if (idAbsenderId == 0) {
							tmpAbsenderId = null;
						} else {
							final SystemObject soAbsenderId = factory.getDav().getDataModel().getObject(idAbsenderId);
							if (soAbsenderId == null) {
									tmpAbsenderId = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.ApplikationUngueltig(idAbsenderId);
							} else {
								tmpAbsenderId = factory.getModellobjekt(soAbsenderId);
							}
						}
						setAbsenderId((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
						) tmpAbsenderId);
					// ZeichenkettenAttributTyp
						setAbsenderZeichen(daten.getTextValue("absenderZeichen").getText());
					// GanzzahlAttributTyp
							setAnfrageTyp(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
							(daten.
								getUnscaledValue
							("anfrageTyp").
									byteValue
							()));
					// GanzzahlAttributTyp
						final Data.NumberArray arrayAnfrage = daten.
							getUnscaledArray
						("anfrage");
		
						for (int i = 0; i < arrayAnfrage.getLength(); ++i) {
		                    getAnfrage().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
		                    (arrayAnfrage.
		                    		byteValue
		                    (i)));
		                }
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAbsenderId(getAbsenderId());
							klon.setAbsenderZeichen(getAbsenderZeichen());
							klon.setAnfrageTyp(getAnfrageTyp());
						klon._anfrage = getAnfrage().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.archivAnfrage";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdArchivAnfrage(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
