/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Informationen über ein Distributionspaket.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 21
 */
public class OdDistributionspaketReleaseInfo extends AbstractOnlineDatensatz<OdDistributionspaketReleaseInfo.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Standard,
				};
			}
	
			/**
			 * Standardaspekt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Standard = new Aspekte("Standard", "asp.standard");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _name
				= new String
				()
				;
				private String
				 _release
				= new String
				()
				;
				private String
				 _version
				= new String
				()
				;
				private String
				 _stand
				= new String
				()
				;
				private String
				 _lizenz
				= new String
				()
				;
				private String
				 _abhaengigkeiten
				= new String
				()
				;
				private String
				 _quellcodeAbhaengigkeiten
				= new String
				()
				;
				private String
				 _bibliothekAbhaengigkeiten
				= new String
				()
				;
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Name.
			*/
				public String
				 getName() {
				return _name;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _name der neue Wert von Name.
			*/
			public void setName(String
			 _name) {
				if (_name.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._name = _name;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Release.
			*/
				public String
				 getRelease() {
				return _release;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _release der neue Wert von Release.
			*/
			public void setRelease(String
			 _release) {
				if (_release.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._release = _release;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Version.
			*/
				public String
				 getVersion() {
				return _version;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _version der neue Wert von Version.
			*/
			public void setVersion(String
			 _version) {
				if (_version.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._version = _version;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Stand.
			*/
				public String
				 getStand() {
				return _stand;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _stand der neue Wert von Stand.
			*/
			public void setStand(String
			 _stand) {
				if (_stand.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._stand = _stand;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Lizenz.
			*/
				public String
				 getLizenz() {
				return _lizenz;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _lizenz der neue Wert von Lizenz.
			*/
			public void setLizenz(String
			 _lizenz) {
				if (_lizenz.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._lizenz = _lizenz;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Abhaengigkeiten.
			*/
				public String
				 getAbhaengigkeiten() {
				return _abhaengigkeiten;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _abhaengigkeiten der neue Wert von Abhaengigkeiten.
			*/
			public void setAbhaengigkeiten(String
			 _abhaengigkeiten) {
				if (_abhaengigkeiten.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._abhaengigkeiten = _abhaengigkeiten;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von QuellcodeAbhaengigkeiten.
			*/
				public String
				 getQuellcodeAbhaengigkeiten() {
				return _quellcodeAbhaengigkeiten;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _quellcodeAbhaengigkeiten der neue Wert von QuellcodeAbhaengigkeiten.
			*/
			public void setQuellcodeAbhaengigkeiten(String
			 _quellcodeAbhaengigkeiten) {
				if (_quellcodeAbhaengigkeiten.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._quellcodeAbhaengigkeiten = _quellcodeAbhaengigkeiten;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von BibliothekAbhaengigkeiten.
			*/
				public String
				 getBibliothekAbhaengigkeiten() {
				return _bibliothekAbhaengigkeiten;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _bibliothekAbhaengigkeiten der neue Wert von BibliothekAbhaengigkeiten.
			*/
			public void setBibliothekAbhaengigkeiten(String
			 _bibliothekAbhaengigkeiten) {
				if (_bibliothekAbhaengigkeiten.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bibliothekAbhaengigkeiten = _bibliothekAbhaengigkeiten;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getName() != null) {
						datum.getTextValue("Name").setText(getName());
					}
					// ZeichenkettenAttributTyp
					if (getRelease() != null) {
						datum.getTextValue("Release").setText(getRelease());
					}
					// ZeichenkettenAttributTyp
					if (getVersion() != null) {
						datum.getTextValue("Version").setText(getVersion());
					}
					// ZeichenkettenAttributTyp
					if (getStand() != null) {
						datum.getTextValue("Stand").setText(getStand());
					}
					// ZeichenkettenAttributTyp
					if (getLizenz() != null) {
						datum.getTextValue("Lizenz").setText(getLizenz());
					}
					// ZeichenkettenAttributTyp
					if (getAbhaengigkeiten() != null) {
						datum.getTextValue("Abhängigkeiten").setText(getAbhaengigkeiten());
					}
					// ZeichenkettenAttributTyp
					if (getQuellcodeAbhaengigkeiten() != null) {
						datum.getTextValue("QuellcodeAbhängigkeiten").setText(getQuellcodeAbhaengigkeiten());
					}
					// ZeichenkettenAttributTyp
					if (getBibliothekAbhaengigkeiten() != null) {
						datum.getTextValue("BibliothekAbhängigkeiten").setText(getBibliothekAbhaengigkeiten());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setName(daten.getTextValue("Name").getText());
					// ZeichenkettenAttributTyp
						setRelease(daten.getTextValue("Release").getText());
					// ZeichenkettenAttributTyp
						setVersion(daten.getTextValue("Version").getText());
					// ZeichenkettenAttributTyp
						setStand(daten.getTextValue("Stand").getText());
					// ZeichenkettenAttributTyp
						setLizenz(daten.getTextValue("Lizenz").getText());
					// ZeichenkettenAttributTyp
						setAbhaengigkeiten(daten.getTextValue("Abhängigkeiten").getText());
					// ZeichenkettenAttributTyp
						setQuellcodeAbhaengigkeiten(daten.getTextValue("QuellcodeAbhängigkeiten").getText());
					// ZeichenkettenAttributTyp
						setBibliothekAbhaengigkeiten(daten.getTextValue("BibliothekAbhängigkeiten").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setName(getName());
							klon.setRelease(getRelease());
							klon.setVersion(getVersion());
							klon.setStand(getStand());
							klon.setLizenz(getLizenz());
							klon.setAbhaengigkeiten(getAbhaengigkeiten());
							klon.setQuellcodeAbhaengigkeiten(getQuellcodeAbhaengigkeiten());
							klon.setBibliothekAbhaengigkeiten(getBibliothekAbhaengigkeiten());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.distributionspaketReleaseInfo";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdDistributionspaketReleaseInfo(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
