/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Schnittstelle für Anfragen und Antworten an die Parametrierung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 9
 */
public class OdParametrierungSchnittstelle extends AbstractOnlineDatensatz<OdParametrierungSchnittstelle.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Anfrage,
					Aspekte.Antwort,
				};
			}
	
			/**
			 * Wird zur Anfrage von Informationen benutzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Anfrage = new Aspekte("Anfrage", "asp.anfrage");
			
			/**
			 * Wird zur Beantwortung von Anfragen benutzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Antwort = new Aspekte("Antwort", "asp.antwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	Object
				 _absender
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnfrageIndex
				 _anfrageIndex
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttParametrierungsAnfrageTyp
				 _anfrageTyp
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> _daten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				>(0, true);
		
			/**
			Attribut zur Referenzierung von beliebigen Objekten.
			<p>
			
			</p>
			
			@return der Wert von Absender.
			*/
				public 	Object
				 getAbsender() {
				return _absender;
			}
		
			/**
			Attribut zur Referenzierung von beliebigen Objekten.
			<p>
			
			</p>
			
			@param _absender der neue Wert von Absender.
			*/
			public void setAbsender(	Object
			 _absender) {
				this._absender = _absender;
			}
		
			/**
			Index einer Anfrage.
			<p>
			
			</p>
			
			@return der Wert von AnfrageIndex.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnfrageIndex
				 getAnfrageIndex() {
				return _anfrageIndex;
			}
		
			/**
			Index einer Anfrage.
			<p>
			
			</p>
			
			@param _anfrageIndex der neue Wert von AnfrageIndex.
			*/
			public void setAnfrageIndex(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnfrageIndex
			 _anfrageIndex) {
				this._anfrageIndex = _anfrageIndex;
			}
		
			/**
			Typ der Anfrage an die Paramterierung.
			<p>
			
			</p>
			
			@return der Wert von AnfrageTyp.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttParametrierungsAnfrageTyp
				 getAnfrageTyp() {
				return _anfrageTyp;
			}
		
			/**
			Typ der Anfrage an die Paramterierung.
			<p>
			
			</p>
			
			@param _anfrageTyp der neue Wert von AnfrageTyp.
			*/
			public void setAnfrageTyp(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttParametrierungsAnfrageTyp
			 _anfrageTyp) {
				this._anfrageTyp = _anfrageTyp;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -128 bis 127.
			<p>
			
			</p>
			
			@return der Wert von Daten.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> getDaten() {
				return _daten;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soAbsender = getAbsender();
						final SystemObject tmpAbsender;
							if (soAbsender instanceof SystemObject) {
								tmpAbsender = (SystemObject)soAbsender;
							} else if(soAbsender instanceof SystemObjekt){
								tmpAbsender = ((SystemObjekt)soAbsender).getSystemObject();
							} else{
								tmpAbsender = null;
							}
						datum.getReferenceValue("Absender").setSystemObject(tmpAbsender);
					// GanzzahlAttributTyp
					if (getAnfrageIndex() != null) {
		                if (getAnfrageIndex().isZustand()) {
		                    datum.getUnscaledValue("AnfrageIndex").setText(getAnfrageIndex().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnfrageIndex").set(getAnfrageIndex().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnfrageTyp() != null) {
		                if (getAnfrageTyp().isZustand()) {
		                    datum.getUnscaledValue("AnfrageTyp").setText(getAnfrageTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnfrageTyp").set(getAnfrageTyp().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDaten() != null) {
						final Data.NumberArray arrayDaten = datum.
							getUnscaledArray
							("Daten");
						arrayDaten.setLength(getDaten().size());
						for (int i = 0; i < arrayDaten.getLength(); ++i) {
							arrayDaten.getValue(i).set(getDaten().get(i).getValue());
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idAbsender = daten.getReferenceValue("Absender").getId();
						final SystemObjekt tmpAbsender;
						if (idAbsender == 0) {
							tmpAbsender = null;
						} else {
							final SystemObject soAbsender = factory.getDav().getDataModel().getObject(idAbsender);
							if (soAbsender == null) {
									tmpAbsender = new BaseUngueltigesSystemObjekt(idAbsender);
							} else {
								tmpAbsender = factory.getModellobjekt(soAbsender);
							}
						}
						setAbsender((	Object
						) tmpAbsender);
					// GanzzahlAttributTyp
							setAnfrageIndex(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnfrageIndex
							(daten.
								getUnscaledValue
							("AnfrageIndex").
									intValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AnfrageTyp").isState()) {
								setAnfrageTyp(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttParametrierungsAnfrageTyp
								.getZustand(daten.getScaledValue("AnfrageTyp").getText()));
							} else {
							setAnfrageTyp(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttParametrierungsAnfrageTyp
							(daten.
								getUnscaledValue
							("AnfrageTyp").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
						final Data.NumberArray arrayDaten = daten.
							getUnscaledArray
						("Daten");
		
						for (int i = 0; i < arrayDaten.getLength(); ++i) {
		                    getDaten().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
		                    (arrayDaten.
		                    		byteValue
		                    (i)));
		                }
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAbsender(getAbsender());
							klon.setAnfrageIndex(getAnfrageIndex());
							klon.setAnfrageTyp(getAnfrageTyp());
						klon._daten = getDaten().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.parametrierungSchnittstelle";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdParametrierungSchnittstelle(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
