/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe zur Beschreibung von Aktivitäten.
<p>
&lt;absatz&gt;Über diesen Parameter wird spezifziert, welche Aktivitäten Benutzer dieser Rolle ausführen dürfen.&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;
							&lt;absatz&gt;
								Über die Attributliste AktivitätDaten  wird spezifziert, wie die Zugriffrechte beim Datenaustausch
								für die entsprechende Rolle gesetzt sind.
								Es können verschiedenen Aktivitäten definiert und der Rolle zugeordnet werden.
							&lt;&#47;absatz&gt;
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							&lt;absatz&gt;Über die Attributliste AktivitätObjekte wird spezifziert, welche Objekte neu angelegt, geändert oder gelöscht werden dürfen.&lt;&#47;absatz&gt;
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							&lt;absatz&gt;Über die Attributliste AktivitätMengen wird spezifziert, welche Menge geändert werden dürfen.&lt;&#47;absatz&gt;
						&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 35
 */
public class PdRollenAktivitaet extends AbstractParameterDatensatz<PdRollenAktivitaet.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetDaten
				> _aktivitaetDaten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetDaten
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetObjekteNeu
				> _aktivitaetObjekte = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetObjekteNeu
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetMengen
				> _aktivitaetMengen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetMengen
				>(0, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRolleNeu
				> _rolle = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRolleNeu
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Attributliste zur Beschreibung einer Aktivität.
			<p>
			
			</p>
			
			@return der Wert von AktivitaetDaten.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetDaten
				> getAktivitaetDaten() {
				return _aktivitaetDaten;
			}
		
		
			/**
			Attributliste zur Beschreibung, welche Objekte neu angelegt, geändert oder gelöscht werden dürfen.
			<p>
			
			</p>
			
			@return der Wert von AktivitaetObjekte.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetObjekteNeu
				> getAktivitaetObjekte() {
				return _aktivitaetObjekte;
			}
		
		
			/**
			Attributliste zur Beschreibung, welche Mengen geändert werden dürfen.
			<p>
			
			</p>
			
			@return der Wert von AktivitaetMengen.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetMengen
				> getAktivitaetMengen() {
				return _aktivitaetMengen;
			}
		
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.zugriffsRolleNeu.
			<p>
			
			</p>
			
			@return der Wert von Rolle.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRolleNeu
				> getRolle() {
				return _rolle;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// AttributListenDefinition
						final Data.Array arrayAktivitaetDaten = datum.getArray("AktivitätDaten");
						arrayAktivitaetDaten.setLength(getAktivitaetDaten().size());
						for (int i = 0; i < arrayAktivitaetDaten.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetDaten
							 atl = getAktivitaetDaten().get(i);
							atl.bean2Atl(arrayAktivitaetDaten.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayAktivitaetObjekte = datum.getArray("AktivitätObjekte");
						arrayAktivitaetObjekte.setLength(getAktivitaetObjekte().size());
						for (int i = 0; i < arrayAktivitaetObjekte.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetObjekteNeu
							 atl = getAktivitaetObjekte().get(i);
							atl.bean2Atl(arrayAktivitaetObjekte.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayAktivitaetMengen = datum.getArray("AktivitätMengen");
						arrayAktivitaetMengen.setLength(getAktivitaetMengen().size());
						for (int i = 0; i < arrayAktivitaetMengen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetMengen
							 atl = getAktivitaetMengen().get(i);
							atl.bean2Atl(arrayAktivitaetMengen.getItem(i), factory);
		
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayRolle = datum.getReferenceArray("Rolle");
						arrayRolle.setLength(getRolle().size());
						for (int i = 0; i < arrayRolle.getLength(); ++i) {
							final Object soRolle = getRolle().get(i);
							final SystemObject tmpRolle;
							if (soRolle instanceof SystemObject) {
								tmpRolle = (SystemObject)soRolle;
							} else if(soRolle instanceof SystemObjekt){
								tmpRolle = ((SystemObjekt)soRolle).getSystemObject();
							} else{
								tmpRolle = null;
							}
							arrayRolle.getReferenceValue(i).setSystemObject(tmpRolle);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// AttributListenDefinition
						final Data.Array arrayAktivitaetDaten = daten.getArray("AktivitätDaten");
						for (int i = 0; i < arrayAktivitaetDaten.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetDaten
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetDaten
							 ();
							atl.atl2Bean(arrayAktivitaetDaten.getItem(i), factory);
							getAktivitaetDaten().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayAktivitaetObjekte = daten.getArray("AktivitätObjekte");
						for (int i = 0; i < arrayAktivitaetObjekte.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetObjekteNeu
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetObjekteNeu
							 ();
							atl.atl2Bean(arrayAktivitaetObjekte.getItem(i), factory);
							getAktivitaetObjekte().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayAktivitaetMengen = daten.getArray("AktivitätMengen");
						for (int i = 0; i < arrayAktivitaetMengen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetMengen
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAktivitaetMengen
							 ();
							atl.atl2Bean(arrayAktivitaetMengen.getItem(i), factory);
							getAktivitaetMengen().add(atl);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayRolle = daten.getReferenceArray("Rolle");
						for (int i = 0; i < arrayRolle.getLength(); ++i) {
							final long idRolle = daten.getReferenceArray("Rolle").getReferenceValue(i).getId();
							final SystemObjekt tmpRolle;
							if (idRolle == 0) {
								tmpRolle = null;
							} else {
								final SystemObject soRolle = factory.getDav().getDataModel().getObject(idRolle);
								if (soRolle == null) {
										tmpRolle = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.ZugriffsRolleNeuUngueltig(idRolle);
								} else {
									tmpRolle = factory.getModellobjekt(soRolle);
								}
							}
								getRolle().add((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRolleNeu
								) tmpRolle);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
						klon._aktivitaetDaten = getAktivitaetDaten().clone();
						klon._aktivitaetObjekte = getAktivitaetObjekte().clone();
						klon._aktivitaetMengen = getAktivitaetMengen().clone();
						klon._rolle = getRolle().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.rollenAktivität";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdRollenAktivitaet(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
