/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition zum Austausch von dynamischen Objekten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlAustauschDynamischeObjekteRemoteNachLokal implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlBereichTypenRemote
			> _bereich = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlBereichTypenRemote
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlRegionTypenRemote
			> _region = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlRegionTypenRemote
			>(0, true);
	
		/**
		Auswahl von Objekten über Bereiche.
		<p>
		
		</p>
		
		@return der Wert von Bereich.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlBereichTypenRemote
			> getBereich() {
			return _bereich;
		}
	
	
		/**
		Auswahl von Objekten über Regionen.
		<p>
		
		</p>
		
		@return der Wert von Region.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlRegionTypenRemote
			> getRegion() {
			return _region;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayBereich = datum.getArray("Bereich");
					arrayBereich.setLength(getBereich().size());
					for (int i = 0; i < arrayBereich.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlBereichTypenRemote
						 atl = getBereich().get(i);
						atl.bean2Atl(arrayBereich.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayRegion = datum.getArray("Region");
					arrayRegion.setLength(getRegion().size());
					for (int i = 0; i < arrayRegion.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlRegionTypenRemote
						 atl = getRegion().get(i);
						atl.bean2Atl(arrayRegion.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayBereich = daten.getArray("Bereich");
					for (int i = 0; i < arrayBereich.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlBereichTypenRemote
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlBereichTypenRemote
						 ();
						atl.atl2Bean(arrayBereich.getItem(i), factory);
						getBereich().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayRegion = daten.getArray("Region");
					for (int i = 0; i < arrayRegion.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlRegionTypenRemote
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlRegionTypenRemote
						 ();
						atl.atl2Bean(arrayRegion.getItem(i), factory);
						getRegion().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAustauschDynamischeObjekteRemoteNachLokal clone() {
		AtlAustauschDynamischeObjekteRemoteNachLokal klon = new AtlAustauschDynamischeObjekteRemoteNachLokal();
		
					klon._bereich = getBereich().clone();
					klon._region = getRegion().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
