/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Liste zur Beschreibung der enthaltenen Objekte einer Region.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlAustauschParameterdaten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlBereiche
			> _bereich = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlBereiche
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlRegionen
			> _region = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlRegionen
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlObjekte
			> _objekte = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlObjekte
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlDatenidentifikationenAustauschParameterdaten
			> _parameterdaten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlDatenidentifikationenAustauschParameterdaten
			>(0, true);
	
		/**
		Auswahl von Objekten über Bereiche.
		<p>
		
		</p>
		
		@return der Wert von Bereich.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlBereiche
			> getBereich() {
			return _bereich;
		}
	
	
		/**
		Auswahl von Objekten über Regionen.
		<p>
		
		</p>
		
		@return der Wert von Region.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlRegionen
			> getRegion() {
			return _region;
		}
	
	
		/**
		Auswahl von Objekten über Objekte.
		<p>
		
		</p>
		
		@return der Wert von Objekte.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlObjekte
			> getObjekte() {
			return _objekte;
		}
	
	
		/**
		Auswahl der ausgetauschten Daten.
		<p>
		
		</p>
		
		@return der Wert von Parameterdaten.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlDatenidentifikationenAustauschParameterdaten
			> getParameterdaten() {
			return _parameterdaten;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayBereich = datum.getArray("Bereich");
					arrayBereich.setLength(getBereich().size());
					for (int i = 0; i < arrayBereich.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlBereiche
						 atl = getBereich().get(i);
						atl.bean2Atl(arrayBereich.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayRegion = datum.getArray("Region");
					arrayRegion.setLength(getRegion().size());
					for (int i = 0; i < arrayRegion.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlRegionen
						 atl = getRegion().get(i);
						atl.bean2Atl(arrayRegion.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayObjekte = datum.getArray("Objekte");
					arrayObjekte.setLength(getObjekte().size());
					for (int i = 0; i < arrayObjekte.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlObjekte
						 atl = getObjekte().get(i);
						atl.bean2Atl(arrayObjekte.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayParameterdaten = datum.getArray("Parameterdaten");
					arrayParameterdaten.setLength(getParameterdaten().size());
					for (int i = 0; i < arrayParameterdaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlDatenidentifikationenAustauschParameterdaten
						 atl = getParameterdaten().get(i);
						atl.bean2Atl(arrayParameterdaten.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayBereich = daten.getArray("Bereich");
					for (int i = 0; i < arrayBereich.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlBereiche
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlBereiche
						 ();
						atl.atl2Bean(arrayBereich.getItem(i), factory);
						getBereich().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayRegion = daten.getArray("Region");
					for (int i = 0; i < arrayRegion.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlRegionen
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlRegionen
						 ();
						atl.atl2Bean(arrayRegion.getItem(i), factory);
						getRegion().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayObjekte = daten.getArray("Objekte");
					for (int i = 0; i < arrayObjekte.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlObjekte
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlObjekte
						 ();
						atl.atl2Bean(arrayObjekte.getItem(i), factory);
						getObjekte().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayParameterdaten = daten.getArray("Parameterdaten");
					for (int i = 0; i < arrayParameterdaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlDatenidentifikationenAustauschParameterdaten
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlDatenidentifikationenAustauschParameterdaten
						 ();
						atl.atl2Bean(arrayParameterdaten.getItem(i), factory);
						getParameterdaten().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAustauschParameterdaten clone() {
		AtlAustauschParameterdaten klon = new AtlAustauschParameterdaten();
		
					klon._bereich = getBereich().clone();
					klon._region = getRegion().clone();
					klon._objekte = getObjekte().clone();
					klon._parameterdaten = getParameterdaten().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
