/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition zum Austausch von Parameterdaten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlDatenidentifikationenAustauschParameterdaten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlParameterdatenAtgs
			> _attributgruppen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlParameterdatenAtgs
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
			 _simLokal
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
			 _simRemote
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _delta
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttParameterdatenStrategie
			 _strategie
			;
	
		/**
		Liste mit zu übertragenden Attributgruppen.
		<p>
		
		</p>
		
		@return der Wert von Attributgruppen.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlParameterdatenAtgs
			> getAttributgruppen() {
			return _attributgruppen;
		}
	
	
		/**
		Simulatiosnvariante im Lokal-System.
		<p>
		
		</p>
		
		@return der Wert von SimLokal.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
			 getSimLokal() {
			return _simLokal;
		}
	
		/**
		Simulatiosnvariante im Lokal-System.
		<p>
		
		</p>
		
		@param _simLokal der neue Wert von SimLokal.
		*/
		public void setSimLokal(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
		 _simLokal) {
			this._simLokal = _simLokal;
		}
	
		/**
		Simulationsvariante im Remote-System.
		<p>
		
		</p>
		
		@return der Wert von SimRemote.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
			 getSimRemote() {
			return _simRemote;
		}
	
		/**
		Simulationsvariante im Remote-System.
		<p>
		
		</p>
		
		@param _simRemote der neue Wert von SimRemote.
		*/
		public void setSimRemote(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
		 _simRemote) {
			this._simRemote = _simRemote;
		}
	
		/**
		Legt fest, ob nur geänderte Daten übertragen werden sollen. Wird bei beidseitigem Parameteraustausch immer als "Ja" angenommen.
		<p>
		
		</p>
		
		@return der Wert von Delta.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getDelta() {
			return _delta;
		}
	
		/**
		Legt fest, ob nur geänderte Daten übertragen werden sollen. Wird bei beidseitigem Parameteraustausch immer als "Ja" angenommen.
		<p>
		
		</p>
		
		@param _delta der neue Wert von Delta.
		*/
		public void setDelta(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _delta) {
			this._delta = _delta;
		}
	
		/**
		Richtung und Art des Austausches der Parameter.
		<p>
		
		</p>
		
		@return der Wert von Strategie.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttParameterdatenStrategie
			 getStrategie() {
			return _strategie;
		}
	
		/**
		Richtung und Art des Austausches der Parameter.
		<p>
		
		</p>
		
		@param _strategie der neue Wert von Strategie.
		*/
		public void setStrategie(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttParameterdatenStrategie
		 _strategie) {
			this._strategie = _strategie;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayAttributgruppen = datum.getArray("Attributgruppen");
					arrayAttributgruppen.setLength(getAttributgruppen().size());
					for (int i = 0; i < arrayAttributgruppen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlParameterdatenAtgs
						 atl = getAttributgruppen().get(i);
						atl.bean2Atl(arrayAttributgruppen.getItem(i), factory);
	
					}
				// GanzzahlAttributTyp
				if (getSimLokal() != null) {
	                if (getSimLokal().isZustand()) {
	                    datum.getUnscaledValue("SimLokal").setText(getSimLokal().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SimLokal").set(getSimLokal().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getSimRemote() != null) {
	                if (getSimRemote().isZustand()) {
	                    datum.getUnscaledValue("SimRemote").setText(getSimRemote().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SimRemote").set(getSimRemote().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getDelta() != null) {
	                if (getDelta().isZustand()) {
	                    datum.getUnscaledValue("Delta").setText(getDelta().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Delta").set(getDelta().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getStrategie() != null) {
	                if (getStrategie().isZustand()) {
	                    datum.getUnscaledValue("Strategie").setText(getStrategie().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Strategie").set(getStrategie().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayAttributgruppen = daten.getArray("Attributgruppen");
					for (int i = 0; i < arrayAttributgruppen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlParameterdatenAtgs
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlParameterdatenAtgs
						 ();
						atl.atl2Bean(arrayAttributgruppen.getItem(i), factory);
						getAttributgruppen().add(atl);
					}
				// GanzzahlAttributTyp
						setSimLokal(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
						(daten.
							getUnscaledValue
						("SimLokal").
								shortValue
						()));
				// GanzzahlAttributTyp
						setSimRemote(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
						(daten.
							getUnscaledValue
						("SimRemote").
								shortValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Delta").isState()) {
							setDelta(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Delta").getText()));
						} else {
						setDelta(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Delta").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Strategie").isState()) {
							setStrategie(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttParameterdatenStrategie
							.getZustand(daten.getScaledValue("Strategie").getText()));
						} else {
						setStrategie(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttParameterdatenStrategie
						(daten.
							getUnscaledValue
						("Strategie").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlDatenidentifikationenAustauschParameterdaten clone() {
		AtlDatenidentifikationenAustauschParameterdaten klon = new AtlDatenidentifikationenAustauschParameterdaten();
		
					klon._attributgruppen = getAttributgruppen().clone();
						klon.setSimLokal(getSimLokal());
						klon.setSimRemote(getSimRemote());
						klon.setDelta(getDelta());
						klon.setStrategie(getStrategie());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
