/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Referenz auf eine Menge.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlMengenReferenzLokal implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
			 _objekt
			;
			private String
			 _menge
			= new String
			()
			;
	
		/**
		Objekt, von dem die Menge bestimmt werden soll.
		<p>
		
		</p>
		
		@return der Wert von Objekt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
			 getObjekt() {
			return _objekt;
		}
	
		/**
		Objekt, von dem die Menge bestimmt werden soll.
		<p>
		
		</p>
		
		@param _objekt der neue Wert von Objekt.
		*/
		public void setObjekt(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
		 _objekt) {
			this._objekt = _objekt;
		}
	
		/**
		Name der Menge vom Objekt.
		<p>
		
		</p>
		
		@return der Wert von Menge.
		*/
			public String
			 getMenge() {
			return _menge;
		}
	
		/**
		Name der Menge vom Objekt.
		<p>
		
		</p>
		
		@param _menge der neue Wert von Menge.
		*/
		public void setMenge(String
		 _menge) {
			if (_menge.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._menge = _menge;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soObjekt = getObjekt();
					final SystemObject tmpObjekt;
						if (soObjekt instanceof SystemObject) {
							tmpObjekt = (SystemObject)soObjekt;
						} else if(soObjekt instanceof SystemObjekt){
							tmpObjekt = ((SystemObjekt)soObjekt).getSystemObject();
						} else{
							tmpObjekt = null;
						}
					datum.getReferenceValue("Objekt").setSystemObject(tmpObjekt);
				// ZeichenkettenAttributTyp
				if (getMenge() != null) {
					datum.getTextValue("Menge").setText(getMenge());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idObjekt = daten.getReferenceValue("Objekt").getId();
					final SystemObjekt tmpObjekt;
					if (idObjekt == 0) {
						tmpObjekt = null;
					} else {
						final SystemObject soObjekt = factory.getDav().getDataModel().getObject(idObjekt);
						if (soObjekt == null) {
								tmpObjekt = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.KonfigurationsObjektUngueltig(idObjekt);
						} else {
							tmpObjekt = factory.getModellobjekt(soObjekt);
						}
					}
					setObjekt((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
					) tmpObjekt);
				// ZeichenkettenAttributTyp
					setMenge(daten.getTextValue("Menge").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlMengenReferenzLokal clone() {
		AtlMengenReferenzLokal klon = new AtlMengenReferenzLokal();
		
						klon.setObjekt(getObjekt());
						klon.setMenge(getMenge());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
