/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition der Attributgruppen beim Austausch von Parameterdaten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlParameterdatenAtgs implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			 _atgLokal
			;
			@Defaultwert(wert = "")
			private String
			 _atgRemote
			= new String
			()
			;
	
		/**
		Attributgruppe im Lokalsystem.
		<p>
		
		</p>
		
		@return der Wert von AtgLokal.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			 getAtgLokal() {
			return _atgLokal;
		}
	
		/**
		Attributgruppe im Lokalsystem.
		<p>
		
		</p>
		
		@param _atgLokal der neue Wert von AtgLokal.
		*/
		public void setAtgLokal(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
		 _atgLokal) {
			this._atgLokal = _atgLokal;
		}
	
		/**
		Attributgruppe im Remote-System (falls leer wird die korrespondierende Attributgruppe zu AtgLokal benutzt).
		<p>
		
		</p>
		
		@return der Wert von AtgRemote.
		*/
			public String
			 getAtgRemote() {
			return _atgRemote;
		}
	
		/**
		Attributgruppe im Remote-System (falls leer wird die korrespondierende Attributgruppe zu AtgLokal benutzt).
		<p>
		
		</p>
		
		@param _atgRemote der neue Wert von AtgRemote.
		*/
		public void setAtgRemote(String
		 _atgRemote) {
			if (_atgRemote.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._atgRemote = _atgRemote;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soAtgLokal = getAtgLokal();
					final SystemObject tmpAtgLokal;
						if (soAtgLokal instanceof SystemObject) {
							tmpAtgLokal = (SystemObject)soAtgLokal;
						} else if(soAtgLokal instanceof SystemObjekt){
							tmpAtgLokal = ((SystemObjekt)soAtgLokal).getSystemObject();
						} else{
							tmpAtgLokal = null;
						}
					datum.getReferenceValue("AtgLokal").setSystemObject(tmpAtgLokal);
				// ZeichenkettenAttributTyp
				if (getAtgRemote() != null) {
					datum.getTextValue("AtgRemote").setText(getAtgRemote());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idAtgLokal = daten.getReferenceValue("AtgLokal").getId();
					final SystemObjekt tmpAtgLokal;
					if (idAtgLokal == 0) {
						tmpAtgLokal = null;
					} else {
						final SystemObject soAtgLokal = factory.getDav().getDataModel().getObject(idAtgLokal);
						if (soAtgLokal == null) {
								tmpAtgLokal = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AttributgruppeUngueltig(idAtgLokal);
						} else {
							tmpAtgLokal = factory.getModellobjekt(soAtgLokal);
						}
					}
					setAtgLokal((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
					) tmpAtgLokal);
				// ZeichenkettenAttributTyp
					setAtgRemote(daten.getTextValue("AtgRemote").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlParameterdatenAtgs clone() {
		AtlParameterdatenAtgs klon = new AtlParameterdatenAtgs();
		
						klon.setAtgLokal(getAtgLokal());
						klon.setAtgRemote(getAtgRemote());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
