/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Auswahl von Objekten über die Vorgabe von Regionen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlRegionTypenLokal implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRegion
			> _region = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRegion
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			> _typ = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			>(0, true);
	
		/**
		Referenz auf eine Region.
		<p>
		&lt;absatz&gt;
									Über dieses Array können bereits definierte Regionen angegeben werden. Die Auswahl einer
									Region bedeutet, dass alle Konfigurationsobjekte dieser Region betrachtet werden.
									Wenn das Array Region leer ist, sind alle Konfigurationsobjekte ausgewählt.
								&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von Region.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRegion
			> getRegion() {
			return _region;
		}
	
	
		/**
		Referenz auf Typobjekte.
		<p>
		&lt;absatz&gt;
									Über dieses Array werden die bisher ausgewählten Objekte auf die angegebenen Typobjekte
									beschränkt. D.h., wenn hier z.B. als Typ MessQuerschnitt angegeben wird, werden nur noch
									Konfigurationsobjekte betrachtet, die von diesem Typ stammen.
									Wenn hier keine Angabe erfolgt, bleibt die Auswahl bestehen.
								&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von Typ.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			> getTyp() {
			return _typ;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayRegion = datum.getReferenceArray("Region");
					arrayRegion.setLength(getRegion().size());
					for (int i = 0; i < arrayRegion.getLength(); ++i) {
						final Object soRegion = getRegion().get(i);
						final SystemObject tmpRegion;
						if (soRegion instanceof SystemObject) {
							tmpRegion = (SystemObject)soRegion;
						} else if(soRegion instanceof SystemObjekt){
							tmpRegion = ((SystemObjekt)soRegion).getSystemObject();
						} else{
							tmpRegion = null;
						}
						arrayRegion.getReferenceValue(i).setSystemObject(tmpRegion);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayTyp = datum.getReferenceArray("Typ");
					arrayTyp.setLength(getTyp().size());
					for (int i = 0; i < arrayTyp.getLength(); ++i) {
						final Object soTyp = getTyp().get(i);
						final SystemObject tmpTyp;
						if (soTyp instanceof SystemObject) {
							tmpTyp = (SystemObject)soTyp;
						} else if(soTyp instanceof SystemObjekt){
							tmpTyp = ((SystemObjekt)soTyp).getSystemObject();
						} else{
							tmpTyp = null;
						}
						arrayTyp.getReferenceValue(i).setSystemObject(tmpTyp);
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayRegion = daten.getReferenceArray("Region");
					for (int i = 0; i < arrayRegion.getLength(); ++i) {
						final long idRegion = daten.getReferenceArray("Region").getReferenceValue(i).getId();
						final SystemObjekt tmpRegion;
						if (idRegion == 0) {
							tmpRegion = null;
						} else {
							final SystemObject soRegion = factory.getDav().getDataModel().getObject(idRegion);
							if (soRegion == null) {
									tmpRegion = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.ZugriffsRegionUngueltig(idRegion);
							} else {
								tmpRegion = factory.getModellobjekt(soRegion);
							}
						}
							getRegion().add((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRegion
							) tmpRegion);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayTyp = daten.getReferenceArray("Typ");
					for (int i = 0; i < arrayTyp.getLength(); ++i) {
						final long idTyp = daten.getReferenceArray("Typ").getReferenceValue(i).getId();
						final SystemObjekt tmpTyp;
						if (idTyp == 0) {
							tmpTyp = null;
						} else {
							final SystemObject soTyp = factory.getDav().getDataModel().getObject(idTyp);
							if (soTyp == null) {
									tmpTyp = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.TypUngueltig(idTyp);
							} else {
								tmpTyp = factory.getModellobjekt(soTyp);
							}
						}
							getTyp().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
							) tmpTyp);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRegionTypenLokal clone() {
		AtlRegionTypenLokal klon = new AtlRegionTypenLokal();
		
					klon._region = getRegion().clone();
					klon._typ = getTyp().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
