/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Informationen für zusätzliche Konfigurationsbereiche.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlRemoteAustauschBereich implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _konfigurationsbereich
			= new String
			()
			;
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			> _typ = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			>(0, true);
	
		/**
		Referenz auf einen Konfigurationsbereich zur Speicherung eines dynamischen Objektes.
		<p>
		
		</p>
		
		@return der Wert von Konfigurationsbereich.
		*/
			public String
			 getKonfigurationsbereich() {
			return _konfigurationsbereich;
		}
	
		/**
		Referenz auf einen Konfigurationsbereich zur Speicherung eines dynamischen Objektes.
		<p>
		
		</p>
		
		@param _konfigurationsbereich der neue Wert von Konfigurationsbereich.
		*/
		public void setKonfigurationsbereich(String
		 _konfigurationsbereich) {
			if (_konfigurationsbereich.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._konfigurationsbereich = _konfigurationsbereich;
		}
	
		/**
		Verweis auf die zugeordneten Typen.
		<p>
		
		</p>
		
		@return der Wert von Typ.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			> getTyp() {
			return _typ;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getKonfigurationsbereich() != null) {
					datum.getTextValue("Konfigurationsbereich").setText(getKonfigurationsbereich());
				}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayTyp = datum.getReferenceArray("Typ");
					arrayTyp.setLength(getTyp().size());
					for (int i = 0; i < arrayTyp.getLength(); ++i) {
						final Object soTyp = getTyp().get(i);
						final SystemObject tmpTyp;
						if (soTyp instanceof SystemObject) {
							tmpTyp = (SystemObject)soTyp;
						} else if(soTyp instanceof SystemObjekt){
							tmpTyp = ((SystemObjekt)soTyp).getSystemObject();
						} else{
							tmpTyp = null;
						}
						arrayTyp.getReferenceValue(i).setSystemObject(tmpTyp);
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setKonfigurationsbereich(daten.getTextValue("Konfigurationsbereich").getText());
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayTyp = daten.getReferenceArray("Typ");
					for (int i = 0; i < arrayTyp.getLength(); ++i) {
						final long idTyp = daten.getReferenceArray("Typ").getReferenceValue(i).getId();
						final SystemObjekt tmpTyp;
						if (idTyp == 0) {
							tmpTyp = null;
						} else {
							final SystemObject soTyp = factory.getDav().getDataModel().getObject(idTyp);
							if (soTyp == null) {
									tmpTyp = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.TypUngueltig(idTyp);
							} else {
								tmpTyp = factory.getModellobjekt(soTyp);
							}
						}
							getTyp().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
							) tmpTyp);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRemoteAustauschBereich clone() {
		AtlRemoteAustauschBereich klon = new AtlRemoteAustauschBereich();
		
						klon.setKonfigurationsbereich(getKonfigurationsbereich());
					klon._typ = getTyp().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
