/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste für die Parametrierung einer KExDaV-Verbindung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlRemoteDaV implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _iPAdresse
			= new String
			()
			;
			@Defaultwert(wert = "8083")
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _portnummer
			;
			private String
			 _benutzer
			= new String
			()
			;
			private String
			 _daVPid
			= new String
			()
			;
			@Defaultwert(wert = "1 Minute")
			private 	RelativerZeitstempel
			 _wartezeit
			;
			@Defaultwert(wert = "Ja")
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _aktiv
			;
			@Defaultwert(wert = "")
			private String
			 _remoteAustauschDefault
			= new String
			()
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			 _lokalAustauschDefault
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlRemoteAustauschBereich
			> _remoteAustauschBereiche = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlRemoteAustauschBereich
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlLokalAustauschBereich
			> _lokalAustauschBereiche = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlLokalAustauschBereich
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschOnlinedaten
			> _austauschOnlinedaten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschOnlinedaten
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschParameterdaten
			> _austauschParameterdaten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschParameterdaten
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschDynamischeObjekteLokalNachRemote
			> _austauschDynamischeObjekteLokalNachRemote = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschDynamischeObjekteLokalNachRemote
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschDynamischeObjekteRemoteNachLokal
			> _austauschDynamischeObjekteRemoteNachLokal = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschDynamischeObjekteRemoteNachLokal
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschDynamischeMengen
			> _austauschDynamischeMengen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschDynamischeMengen
			>(0, true);
	
		/**
		IP-Adresse oder Hostname für den Verbindungsaufbau zum Remote-Datenverteiler.
		<p>
		
		</p>
		
		@return der Wert von IPAdresse.
		*/
			public String
			 getIPAdresse() {
			return _iPAdresse;
		}
	
		/**
		IP-Adresse oder Hostname für den Verbindungsaufbau zum Remote-Datenverteiler.
		<p>
		
		</p>
		
		@param _iPAdresse der neue Wert von IPAdresse.
		*/
		public void setIPAdresse(String
		 _iPAdresse) {
			if (_iPAdresse.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._iPAdresse = _iPAdresse;
		}
	
		/**
		Portnummer für den Verbindungsaufbau zum Remote-Datenverteiler.
		<p>
		
		</p>
		
		@return der Wert von Portnummer.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getPortnummer() {
			return _portnummer;
		}
	
		/**
		Portnummer für den Verbindungsaufbau zum Remote-Datenverteiler.
		<p>
		
		</p>
		
		@param _portnummer der neue Wert von Portnummer.
		*/
		public void setPortnummer(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _portnummer) {
			this._portnummer = _portnummer;
		}
	
		/**
		Benutzername für die Anmeldung beim Remote-Datenverteiler.
		<p>
		
		</p>
		
		@return der Wert von Benutzer.
		*/
			public String
			 getBenutzer() {
			return _benutzer;
		}
	
		/**
		Benutzername für die Anmeldung beim Remote-Datenverteiler.
		<p>
		
		</p>
		
		@param _benutzer der neue Wert von Benutzer.
		*/
		public void setBenutzer(String
		 _benutzer) {
			if (_benutzer.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._benutzer = _benutzer;
		}
	
		/**
		Pid des Remote-Datenverteilers.
		<p>
		
		</p>
		
		@return der Wert von DaVPid.
		*/
			public String
			 getDaVPid() {
			return _daVPid;
		}
	
		/**
		Pid des Remote-Datenverteilers.
		<p>
		
		</p>
		
		@param _daVPid der neue Wert von DaVPid.
		*/
		public void setDaVPid(String
		 _daVPid) {
			if (_daVPid.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._daVPid = _daVPid;
		}
	
		/**
		Legt fest, wie lange nach einem fehlgeschlagenem Verbindungsversuch gewartet werden soll, bis dieser erneut durchgeführt wird.
		<p>
		
		</p>
		
		@return der Wert von Wartezeit.
		*/
			public 	RelativerZeitstempel
			 getWartezeit() {
			return _wartezeit;
		}
	
		/**
		Legt fest, wie lange nach einem fehlgeschlagenem Verbindungsversuch gewartet werden soll, bis dieser erneut durchgeführt wird.
		<p>
		
		</p>
		
		@param _wartezeit der neue Wert von Wartezeit.
		*/
		public void setWartezeit(	RelativerZeitstempel
		 _wartezeit) {
			this._wartezeit = _wartezeit;
		}
	
		/**
		Legt fest, ob diese Verbindung aktiv sein soll.
		<p>
		
		</p>
		
		@return der Wert von Aktiv.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getAktiv() {
			return _aktiv;
		}
	
		/**
		Legt fest, ob diese Verbindung aktiv sein soll.
		<p>
		
		</p>
		
		@param _aktiv der neue Wert von Aktiv.
		*/
		public void setAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _aktiv) {
			this._aktiv = _aktiv;
		}
	
		/**
		Standardaustauschbereich für dynamische Objekte auf dem Remote-System.
		<p>
		
		</p>
		
		@return der Wert von RemoteAustauschDefault.
		*/
			public String
			 getRemoteAustauschDefault() {
			return _remoteAustauschDefault;
		}
	
		/**
		Standardaustauschbereich für dynamische Objekte auf dem Remote-System.
		<p>
		
		</p>
		
		@param _remoteAustauschDefault der neue Wert von RemoteAustauschDefault.
		*/
		public void setRemoteAustauschDefault(String
		 _remoteAustauschDefault) {
			if (_remoteAustauschDefault.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._remoteAustauschDefault = _remoteAustauschDefault;
		}
	
		/**
		Standardaustauschbereich für dynamische Objekte auf dem Lokal-System.
		<p>
		
		</p>
		
		@return der Wert von LokalAustauschDefault.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			 getLokalAustauschDefault() {
			return _lokalAustauschDefault;
		}
	
		/**
		Standardaustauschbereich für dynamische Objekte auf dem Lokal-System.
		<p>
		
		</p>
		
		@param _lokalAustauschDefault der neue Wert von LokalAustauschDefault.
		*/
		public void setLokalAustauschDefault(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
		 _lokalAustauschDefault) {
			this._lokalAustauschDefault = _lokalAustauschDefault;
		}
	
		/**
		Liste mit zusätzlichen Austauschbereichen für das Remote-System.
		<p>
		
		</p>
		
		@return der Wert von RemoteAustauschBereiche.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlRemoteAustauschBereich
			> getRemoteAustauschBereiche() {
			return _remoteAustauschBereiche;
		}
	
	
		/**
		Liste mit zusätzlichen Austauschbereichen für das Lokal-System.
		<p>
		
		</p>
		
		@return der Wert von LokalAustauschBereiche.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlLokalAustauschBereich
			> getLokalAustauschBereiche() {
			return _lokalAustauschBereiche;
		}
	
	
		/**
		Attributliste zur Definition der auszutauschenden Onlinedaten.
		<p>
		
		</p>
		
		@return der Wert von AustauschOnlinedaten.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschOnlinedaten
			> getAustauschOnlinedaten() {
			return _austauschOnlinedaten;
		}
	
	
		/**
		Attributliste zur Definition der auszutauschenden Parameterdaten.
		<p>
		
		</p>
		
		@return der Wert von AustauschParameterdaten.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschParameterdaten
			> getAustauschParameterdaten() {
			return _austauschParameterdaten;
		}
	
	
		/**
		Attributliste zur Definition der vom Lokal-System zum Remotesystem auszutauschenden dynamischen Objekte.
		<p>
		
		</p>
		
		@return der Wert von AustauschDynamischeObjekteLokalNachRemote.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschDynamischeObjekteLokalNachRemote
			> getAustauschDynamischeObjekteLokalNachRemote() {
			return _austauschDynamischeObjekteLokalNachRemote;
		}
	
	
		/**
		Attributliste zur Definition der vom Remotesystem zum Lokal-System auszutauschenden dynamischen Objekte.
		<p>
		
		</p>
		
		@return der Wert von AustauschDynamischeObjekteRemoteNachLokal.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschDynamischeObjekteRemoteNachLokal
			> getAustauschDynamischeObjekteRemoteNachLokal() {
			return _austauschDynamischeObjekteRemoteNachLokal;
		}
	
	
		/**
		Attributliste zur Definition der auszutauschenden Mengen.
		<p>
		
		</p>
		
		@return der Wert von AustauschDynamischeMengen.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschDynamischeMengen
			> getAustauschDynamischeMengen() {
			return _austauschDynamischeMengen;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getIPAdresse() != null) {
					datum.getTextValue("IP-Adresse").setText(getIPAdresse());
				}
				// GanzzahlAttributTyp
				if (getPortnummer() != null) {
	                if (getPortnummer().isZustand()) {
	                    datum.getUnscaledValue("Portnummer").setText(getPortnummer().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Portnummer").set(getPortnummer().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getBenutzer() != null) {
					datum.getTextValue("Benutzer").setText(getBenutzer());
				}
				// ZeichenkettenAttributTyp
				if (getDaVPid() != null) {
					datum.getTextValue("DaV-Pid").setText(getDaVPid());
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("Wartezeit").setMillis(getWartezeit().getTime());
				// GanzzahlAttributTyp
				if (getAktiv() != null) {
	                if (getAktiv().isZustand()) {
	                    datum.getUnscaledValue("Aktiv").setText(getAktiv().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Aktiv").set(getAktiv().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getRemoteAustauschDefault() != null) {
					datum.getTextValue("RemoteAustauschDefault").setText(getRemoteAustauschDefault());
				}
				// ObjektReferenzAttributTyp
					final Object soLokalAustauschDefault = getLokalAustauschDefault();
					final SystemObject tmpLokalAustauschDefault;
						if (soLokalAustauschDefault instanceof SystemObject) {
							tmpLokalAustauschDefault = (SystemObject)soLokalAustauschDefault;
						} else if(soLokalAustauschDefault instanceof SystemObjekt){
							tmpLokalAustauschDefault = ((SystemObjekt)soLokalAustauschDefault).getSystemObject();
						} else{
							tmpLokalAustauschDefault = null;
						}
					datum.getReferenceValue("LokalAustauschDefault").setSystemObject(tmpLokalAustauschDefault);
				// AttributListenDefinition
					final Data.Array arrayRemoteAustauschBereiche = datum.getArray("RemoteAustauschBereiche");
					arrayRemoteAustauschBereiche.setLength(getRemoteAustauschBereiche().size());
					for (int i = 0; i < arrayRemoteAustauschBereiche.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlRemoteAustauschBereich
						 atl = getRemoteAustauschBereiche().get(i);
						atl.bean2Atl(arrayRemoteAustauschBereiche.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayLokalAustauschBereiche = datum.getArray("LokalAustauschBereiche");
					arrayLokalAustauschBereiche.setLength(getLokalAustauschBereiche().size());
					for (int i = 0; i < arrayLokalAustauschBereiche.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlLokalAustauschBereich
						 atl = getLokalAustauschBereiche().get(i);
						atl.bean2Atl(arrayLokalAustauschBereiche.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayAustauschOnlinedaten = datum.getArray("AustauschOnlinedaten");
					arrayAustauschOnlinedaten.setLength(getAustauschOnlinedaten().size());
					for (int i = 0; i < arrayAustauschOnlinedaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschOnlinedaten
						 atl = getAustauschOnlinedaten().get(i);
						atl.bean2Atl(arrayAustauschOnlinedaten.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayAustauschParameterdaten = datum.getArray("AustauschParameterdaten");
					arrayAustauschParameterdaten.setLength(getAustauschParameterdaten().size());
					for (int i = 0; i < arrayAustauschParameterdaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschParameterdaten
						 atl = getAustauschParameterdaten().get(i);
						atl.bean2Atl(arrayAustauschParameterdaten.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayAustauschDynamischeObjekteLokalNachRemote = datum.getArray("AustauschDynamischeObjekteLokalNachRemote");
					arrayAustauschDynamischeObjekteLokalNachRemote.setLength(getAustauschDynamischeObjekteLokalNachRemote().size());
					for (int i = 0; i < arrayAustauschDynamischeObjekteLokalNachRemote.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschDynamischeObjekteLokalNachRemote
						 atl = getAustauschDynamischeObjekteLokalNachRemote().get(i);
						atl.bean2Atl(arrayAustauschDynamischeObjekteLokalNachRemote.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayAustauschDynamischeObjekteRemoteNachLokal = datum.getArray("AustauschDynamischeObjekteRemoteNachLokal");
					arrayAustauschDynamischeObjekteRemoteNachLokal.setLength(getAustauschDynamischeObjekteRemoteNachLokal().size());
					for (int i = 0; i < arrayAustauschDynamischeObjekteRemoteNachLokal.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschDynamischeObjekteRemoteNachLokal
						 atl = getAustauschDynamischeObjekteRemoteNachLokal().get(i);
						atl.bean2Atl(arrayAustauschDynamischeObjekteRemoteNachLokal.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayAustauschDynamischeMengen = datum.getArray("AustauschDynamischeMengen");
					arrayAustauschDynamischeMengen.setLength(getAustauschDynamischeMengen().size());
					for (int i = 0; i < arrayAustauschDynamischeMengen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschDynamischeMengen
						 atl = getAustauschDynamischeMengen().get(i);
						atl.bean2Atl(arrayAustauschDynamischeMengen.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setIPAdresse(daten.getTextValue("IP-Adresse").getText());
				// GanzzahlAttributTyp
						setPortnummer(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Portnummer").
								longValue
						()));
				// ZeichenkettenAttributTyp
					setBenutzer(daten.getTextValue("Benutzer").getText());
				// ZeichenkettenAttributTyp
					setDaVPid(daten.getTextValue("DaV-Pid").getText());
				// ZeitstempelAttributTyp
					setWartezeit(new
						RelativerZeitstempel
						(daten.getTimeValue("Wartezeit").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Aktiv").isState()) {
							setAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Aktiv").getText()));
						} else {
						setAktiv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Aktiv").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setRemoteAustauschDefault(daten.getTextValue("RemoteAustauschDefault").getText());
				// ObjektReferenzAttributTyp
					final long idLokalAustauschDefault = daten.getReferenceValue("LokalAustauschDefault").getId();
					final SystemObjekt tmpLokalAustauschDefault;
					if (idLokalAustauschDefault == 0) {
						tmpLokalAustauschDefault = null;
					} else {
						final SystemObject soLokalAustauschDefault = factory.getDav().getDataModel().getObject(idLokalAustauschDefault);
						if (soLokalAustauschDefault == null) {
								tmpLokalAustauschDefault = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.KonfigurationsBereichUngueltig(idLokalAustauschDefault);
						} else {
							tmpLokalAustauschDefault = factory.getModellobjekt(soLokalAustauschDefault);
						}
					}
					setLokalAustauschDefault((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
					) tmpLokalAustauschDefault);
				// AttributListenDefinition
					final Data.Array arrayRemoteAustauschBereiche = daten.getArray("RemoteAustauschBereiche");
					for (int i = 0; i < arrayRemoteAustauschBereiche.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlRemoteAustauschBereich
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlRemoteAustauschBereich
						 ();
						atl.atl2Bean(arrayRemoteAustauschBereiche.getItem(i), factory);
						getRemoteAustauschBereiche().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayLokalAustauschBereiche = daten.getArray("LokalAustauschBereiche");
					for (int i = 0; i < arrayLokalAustauschBereiche.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlLokalAustauschBereich
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlLokalAustauschBereich
						 ();
						atl.atl2Bean(arrayLokalAustauschBereiche.getItem(i), factory);
						getLokalAustauschBereiche().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayAustauschOnlinedaten = daten.getArray("AustauschOnlinedaten");
					for (int i = 0; i < arrayAustauschOnlinedaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschOnlinedaten
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschOnlinedaten
						 ();
						atl.atl2Bean(arrayAustauschOnlinedaten.getItem(i), factory);
						getAustauschOnlinedaten().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayAustauschParameterdaten = daten.getArray("AustauschParameterdaten");
					for (int i = 0; i < arrayAustauschParameterdaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschParameterdaten
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschParameterdaten
						 ();
						atl.atl2Bean(arrayAustauschParameterdaten.getItem(i), factory);
						getAustauschParameterdaten().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayAustauschDynamischeObjekteLokalNachRemote = daten.getArray("AustauschDynamischeObjekteLokalNachRemote");
					for (int i = 0; i < arrayAustauschDynamischeObjekteLokalNachRemote.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschDynamischeObjekteLokalNachRemote
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschDynamischeObjekteLokalNachRemote
						 ();
						atl.atl2Bean(arrayAustauschDynamischeObjekteLokalNachRemote.getItem(i), factory);
						getAustauschDynamischeObjekteLokalNachRemote().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayAustauschDynamischeObjekteRemoteNachLokal = daten.getArray("AustauschDynamischeObjekteRemoteNachLokal");
					for (int i = 0; i < arrayAustauschDynamischeObjekteRemoteNachLokal.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschDynamischeObjekteRemoteNachLokal
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschDynamischeObjekteRemoteNachLokal
						 ();
						atl.atl2Bean(arrayAustauschDynamischeObjekteRemoteNachLokal.getItem(i), factory);
						getAustauschDynamischeObjekteRemoteNachLokal().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayAustauschDynamischeMengen = daten.getArray("AustauschDynamischeMengen");
					for (int i = 0; i < arrayAustauschDynamischeMengen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschDynamischeMengen
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlAustauschDynamischeMengen
						 ();
						atl.atl2Bean(arrayAustauschDynamischeMengen.getItem(i), factory);
						getAustauschDynamischeMengen().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRemoteDaV clone() {
		AtlRemoteDaV klon = new AtlRemoteDaV();
		
						klon.setIPAdresse(getIPAdresse());
						klon.setPortnummer(getPortnummer());
						klon.setBenutzer(getBenutzer());
						klon.setDaVPid(getDaVPid());
						klon.setWartezeit(getWartezeit());
						klon.setAktiv(getAktiv());
						klon.setRemoteAustauschDefault(getRemoteAustauschDefault());
						klon.setLokalAustauschDefault(getLokalAustauschDefault());
					klon._remoteAustauschBereiche = getRemoteAustauschBereiche().clone();
					klon._lokalAustauschBereiche = getLokalAustauschBereiche().clone();
					klon._austauschOnlinedaten = getAustauschOnlinedaten().clone();
					klon._austauschParameterdaten = getAustauschParameterdaten().clone();
					klon._austauschDynamischeObjekteLokalNachRemote = getAustauschDynamischeObjekteLokalNachRemote().clone();
					klon._austauschDynamischeObjekteRemoteNachLokal = getAustauschDynamischeObjekteRemoteNachLokal().clone();
					klon._austauschDynamischeMengen = getAustauschDynamischeMengen().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
