/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe zum Auslösen von einmaligen Parameteraustauschen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTriggerKExDaV extends AbstractOnlineDatensatz<OdTriggerKExDaV.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Anfrage,
				};
			}
	
			/**
			 * Wird zur Anfrage von Informationen benutzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Anfrage = new Aspekte("Anfrage", "asp.anfrage");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<String
				> _datenverteilerPid = new Feld<String
				>(1, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlDatenverteilerIP
				> _datenverteilerIP = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlDatenverteilerIP
				>(1, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttAustauschRichtung
				 _austauschRichtung
				;
		
			/**
			Wählt die zu triggernden Datenverteiler-Verbindungen anhand ihrer Pid aus.
			<p>
			
			</p>
			
			@return der Wert von DatenverteilerPid.
			*/
				public Feld<String
				> getDatenverteilerPid() {
				return _datenverteilerPid;
			}
		
		
			/**
			Wählt die zu triggernden Datenverteiler-Verbindungen anhand ihrer IP aus.
			<p>
			
			</p>
			
			@return der Wert von DatenverteilerIP.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlDatenverteilerIP
				> getDatenverteilerIP() {
				return _datenverteilerIP;
			}
		
		
			/**
			Bestimmt die Richtung des Datenaustausches.
			<p>
			
			</p>
			
			@return der Wert von AustauschRichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttAustauschRichtung
				 getAustauschRichtung() {
				return _austauschRichtung;
			}
		
			/**
			Bestimmt die Richtung des Datenaustausches.
			<p>
			
			</p>
			
			@param _austauschRichtung der neue Wert von AustauschRichtung.
			*/
			public void setAustauschRichtung(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttAustauschRichtung
			 _austauschRichtung) {
				this._austauschRichtung = _austauschRichtung;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getDatenverteilerPid() != null) {
						final Data.TextArray arrayDatenverteilerPid = datum.getTextArray("Datenverteiler-Pid");
						arrayDatenverteilerPid.setLength(getDatenverteilerPid().size());
						for (int i = 0; i < arrayDatenverteilerPid.getLength(); ++i) {
							arrayDatenverteilerPid.getTextValue(i).setText(getDatenverteilerPid().get(i));
						}
					}
					// AttributListenDefinition
						final Data.Array arrayDatenverteilerIP = datum.getArray("Datenverteiler-IP");
						arrayDatenverteilerIP.setLength(getDatenverteilerIP().size());
						for (int i = 0; i < arrayDatenverteilerIP.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlDatenverteilerIP
							 atl = getDatenverteilerIP().get(i);
							atl.bean2Atl(arrayDatenverteilerIP.getItem(i), factory);
		
						}
					// GanzzahlAttributTyp
					if (getAustauschRichtung() != null) {
		                if (getAustauschRichtung().isZustand()) {
		                    datum.getUnscaledValue("AustauschRichtung").setText(getAustauschRichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AustauschRichtung").set(getAustauschRichtung().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayDatenverteilerPid = daten.getTextArray("Datenverteiler-Pid");
						for (int i = 0; i < arrayDatenverteilerPid.getLength(); ++i) {
							getDatenverteilerPid().add(arrayDatenverteilerPid.getText(i));
						}
					// AttributListenDefinition
						final Data.Array arrayDatenverteilerIP = daten.getArray("Datenverteiler-IP");
						for (int i = 0; i < arrayDatenverteilerIP.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlDatenverteilerIP
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlDatenverteilerIP
							 ();
							atl.atl2Bean(arrayDatenverteilerIP.getItem(i), factory);
							getDatenverteilerIP().add(atl);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AustauschRichtung").isState()) {
								setAustauschRichtung(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttAustauschRichtung
								.getZustand(daten.getScaledValue("AustauschRichtung").getText()));
							} else {
							setAustauschRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttAustauschRichtung
							(daten.
								getUnscaledValue
							("AustauschRichtung").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._datenverteilerPid = getDatenverteilerPid().clone();
						klon._datenverteilerIP = getDatenverteilerIP().clone();
							klon.setAustauschRichtung(getAustauschRichtung());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.triggerKExDaV";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTriggerKExDaV(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
