/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attribut für mögliche Fehlerzustände einer einzelnen Anzeigeeinheit.
<p>
&lt;absatz&gt;Semantisch von Steueralgorithmen und Benutzeroberflächen auswertbarer Fehlerzustand des einzelnen WZG (der einzelnen Anzeige).
						Weitere Zustände sind im Rahmen der Fortschreibung des Datenmodells zu ergänzen. Für lokal notwendige Erweiterungen sollten abgeleitete Variablen verwendet werden.
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;Dieser Status beinhaltet nicht die speziell beschriebenen und für die Algorithmik mit besonderen Bedeutungen behafteten Teilstörungen wie nicht darstellbare Zeichen
						oder nicht darstellbare Textpositionen, diese werden summarisch in "teilstörung" erfasst.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttAnzeigeFehlerZustand extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttAnzeigeFehlerZustand ZUSTAND_1N_UNDEFINIERT = new AttAnzeigeFehlerZustand("Undefiniert", 		Byte
	.valueOf("-1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAnzeigeFehlerZustand ZUSTAND_0_OK = new AttAnzeigeFehlerZustand("OK", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAnzeigeFehlerZustand ZUSTAND_1_GESTOERT = new AttAnzeigeFehlerZustand("Gestört", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAnzeigeFehlerZustand ZUSTAND_2_TEILSTOERUNG = new AttAnzeigeFehlerZustand("Teilstörung", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAnzeigeFehlerZustand ZUSTAND_3_STROMAUSFALL = new AttAnzeigeFehlerZustand("Stromausfall", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAnzeigeFehlerZustand ZUSTAND_4_KOMMUNIKATIONSAUSFALL = new AttAnzeigeFehlerZustand("Kommunikationsausfall", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAnzeigeFehlerZustand ZUSTAND_5_TUERKONTAKT = new AttAnzeigeFehlerZustand("Türkontakt", 		Byte
	.valueOf("5"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttAnzeigeFehlerZustand getZustand(final 		Byte
	 value) {
		for (AttAnzeigeFehlerZustand e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttAnzeigeFehlerZustand getZustand(final String value) {
		for (AttAnzeigeFehlerZustand e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttAnzeigeFehlerZustand> getZustaende() {
		List<AttAnzeigeFehlerZustand> list = new ArrayList<AttAnzeigeFehlerZustand>();
		list.add(ZUSTAND_1N_UNDEFINIERT);
		list.add(ZUSTAND_0_OK);
		list.add(ZUSTAND_1_GESTOERT);
		list.add(ZUSTAND_2_TEILSTOERUNG);
		list.add(ZUSTAND_3_STROMAUSFALL);
		list.add(ZUSTAND_4_KOMMUNIKATIONSAUSFALL);
		list.add(ZUSTAND_5_TUERKONTAKT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut AnzeigeFehlerZustand.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttAnzeigeFehlerZustand(final 		Byte
	 value) {
		super(value);
	}
	
	private AttAnzeigeFehlerZustand(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
