/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributtyp zur Definition von Zeichenbreiten und Zeichenabständen relativ zur Zeichenhöhe.
<p>
&lt;absatz&gt;Der Wert "1" bedeutet, dass der Abstand bzw. die Zeichenbreite so groß
						ist wie die gesamte Höhe des Fonts in seiner aktuellen Darstellung.
						D.h. vom Anfang der Oberlänge bis zum Ende der Unterlänge (?).
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;Negative Werte bei Abständen treten insbesondere bei Ligaturen auf.&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = -2147483640L,
	maximum = 2147483640L,
	skalierung = 1.0E-5,
	einheit = ""
)
public class AttZeichenAbstandBreite extends Zahl<		Double
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Double
	 MIN_VALUE =
					Double
			.valueOf("-2147483640") * 		Double
			.valueOf("1.0E-5");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Double
	 MAX_VALUE =
					Double
			.valueOf("2147483640") * 		Double
			.valueOf("1.0E-5");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttZeichenAbstandBreite ZUSTAND_2147483641_UNDEFINIERT = new AttZeichenAbstandBreite("Undefiniert", 		Double
	.valueOf("2147483641"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttZeichenAbstandBreite getZustand(final 		Double
	 value) {
		for (AttZeichenAbstandBreite e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttZeichenAbstandBreite getZustand(final String value) {
		for (AttZeichenAbstandBreite e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttZeichenAbstandBreite> getZustaende() {
		List<AttZeichenAbstandBreite> list = new ArrayList<AttZeichenAbstandBreite>();
		list.add(ZUSTAND_2147483641_UNDEFINIERT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut ZeichenAbstandBreite.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttZeichenAbstandBreite(final 		Double
	 value) {
		super(value);
	}
	
	private AttZeichenAbstandBreite(final String zustand, final 		Double
	 value) {
		super(zustand, value);
	}
	
}
