/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdAnzeigeTyp extends AbstractKonfigurationsDatensatz<KdAnzeigeTyp.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _kannFreieGrafik
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
				 _aufloesungX
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
				 _aufloesungY
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttFarbdarstellung
				 _farbdarstellung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _kannFreiText
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
				 _timeoutSchaltBildWechsel
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Font
				> _font = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Font
				>(0, true);
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von KannFreieGrafik.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getKannFreieGrafik() {
				return _kannFreieGrafik;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _kannFreieGrafik der neue Wert von KannFreieGrafik.
			*/
			public void setKannFreieGrafik(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _kannFreieGrafik) {
				this._kannFreieGrafik = _kannFreieGrafik;
			}
		
			/**
			Auflösung X-Richtung in Pixel.
			<p>
			
			</p>
			
			@return der Wert von AufloesungX.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
				 getAufloesungX() {
				return _aufloesungX;
			}
		
			/**
			Auflösung X-Richtung in Pixel.
			<p>
			
			</p>
			
			@param _aufloesungX der neue Wert von AufloesungX.
			*/
			public void setAufloesungX(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
			 _aufloesungX) {
				this._aufloesungX = _aufloesungX;
			}
		
			/**
			Auflösung Y-Richtung in Pixel.
			<p>
			
			</p>
			
			@return der Wert von AufloesungY.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
				 getAufloesungY() {
				return _aufloesungY;
			}
		
			/**
			Auflösung Y-Richtung in Pixel.
			<p>
			
			</p>
			
			@param _aufloesungY der neue Wert von AufloesungY.
			*/
			public void setAufloesungY(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
			 _aufloesungY) {
				this._aufloesungY = _aufloesungY;
			}
		
			/**
			Farbdarstellung 0 = sw, 1 = grau (256), 2 = farbe (256), 3 = farbe (16 Bit), 4 = farbe (24 Bit).
			<p>
			
			</p>
			
			@return der Wert von Farbdarstellung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttFarbdarstellung
				 getFarbdarstellung() {
				return _farbdarstellung;
			}
		
			/**
			Farbdarstellung 0 = sw, 1 = grau (256), 2 = farbe (256), 3 = farbe (16 Bit), 4 = farbe (24 Bit).
			<p>
			
			</p>
			
			@param _farbdarstellung der neue Wert von Farbdarstellung.
			*/
			public void setFarbdarstellung(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttFarbdarstellung
			 _farbdarstellung) {
				this._farbdarstellung = _farbdarstellung;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von KannFreiText.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getKannFreiText() {
				return _kannFreiText;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _kannFreiText der neue Wert von KannFreiText.
			*/
			public void setKannFreiText(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _kannFreiText) {
				this._kannFreiText = _kannFreiText;
			}
		
			/**
			Zeit in Sekunden, nach der normalerweise die Schaltrückmeldung vorliegen sollte.
			<p>
			
			</p>
			
			@return der Wert von TimeoutSchaltBildWechsel.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
				 getTimeoutSchaltBildWechsel() {
				return _timeoutSchaltBildWechsel;
			}
		
			/**
			Zeit in Sekunden, nach der normalerweise die Schaltrückmeldung vorliegen sollte.
			<p>
			
			</p>
			
			@param _timeoutSchaltBildWechsel der neue Wert von TimeoutSchaltBildWechsel.
			*/
			public void setTimeoutSchaltBildWechsel(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
			 _timeoutSchaltBildWechsel) {
				this._timeoutSchaltBildWechsel = _timeoutSchaltBildWechsel;
			}
		
			/**
			Vorhandene Fonts.
			<p>
			
			</p>
			
			@return der Wert von Font.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Font
				> getFont() {
				return _font;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getKannFreieGrafik() != null) {
		                if (getKannFreieGrafik().isZustand()) {
		                    datum.getUnscaledValue("KannFreieGrafik").setText(getKannFreieGrafik().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KannFreieGrafik").set(getKannFreieGrafik().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAufloesungX() != null) {
		                if (getAufloesungX().isZustand()) {
		                    datum.getUnscaledValue("AuflösungX").setText(getAufloesungX().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AuflösungX").set(getAufloesungX().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAufloesungY() != null) {
		                if (getAufloesungY().isZustand()) {
		                    datum.getUnscaledValue("AuflösungY").setText(getAufloesungY().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AuflösungY").set(getAufloesungY().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFarbdarstellung() != null) {
		                if (getFarbdarstellung().isZustand()) {
		                    datum.getUnscaledValue("Farbdarstellung").setText(getFarbdarstellung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Farbdarstellung").set(getFarbdarstellung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKannFreiText() != null) {
		                if (getKannFreiText().isZustand()) {
		                    datum.getUnscaledValue("KannFreiText").setText(getKannFreiText().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KannFreiText").set(getKannFreiText().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getTimeoutSchaltBildWechsel() != null) {
		                if (getTimeoutSchaltBildWechsel().isZustand()) {
		                    datum.getUnscaledValue("TimeoutSchaltBildWechsel").setText(getTimeoutSchaltBildWechsel().toString());
		                } else {
							datum.
							getScaledValue
		                	("TimeoutSchaltBildWechsel").set(getTimeoutSchaltBildWechsel().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayFont = datum.getReferenceArray("Font");
						arrayFont.setLength(getFont().size());
						for (int i = 0; i < arrayFont.getLength(); ++i) {
							final Object soFont = getFont().get(i);
							final SystemObject tmpFont;
							if (soFont instanceof SystemObject) {
								tmpFont = (SystemObject)soFont;
							} else if(soFont instanceof SystemObjekt){
								tmpFont = ((SystemObjekt)soFont).getSystemObject();
							} else{
								tmpFont = null;
							}
							arrayFont.getReferenceValue(i).setSystemObject(tmpFont);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("KannFreieGrafik").isState()) {
								setKannFreieGrafik(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("KannFreieGrafik").getText()));
							} else {
							setKannFreieGrafik(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("KannFreieGrafik").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setAufloesungX(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
							(daten.
								getUnscaledValue
							("AuflösungX").
									intValue
							()));
					// GanzzahlAttributTyp
							setAufloesungY(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
							(daten.
								getUnscaledValue
							("AuflösungY").
									intValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Farbdarstellung").isState()) {
								setFarbdarstellung(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttFarbdarstellung
								.getZustand(daten.getScaledValue("Farbdarstellung").getText()));
							} else {
							setFarbdarstellung(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttFarbdarstellung
							(daten.
								getUnscaledValue
							("Farbdarstellung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("KannFreiText").isState()) {
								setKannFreiText(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("KannFreiText").getText()));
							} else {
							setKannFreiText(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("KannFreiText").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("TimeoutSchaltBildWechsel").isState()) {
								setTimeoutSchaltBildWechsel(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
								.getZustand(daten.getScaledValue("TimeoutSchaltBildWechsel").getText()));
							} else {
							setTimeoutSchaltBildWechsel(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
							(daten.
								getScaledValue
							("TimeoutSchaltBildWechsel").
								doubleValue
							()));
							}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayFont = daten.getReferenceArray("Font");
						for (int i = 0; i < arrayFont.getLength(); ++i) {
							final long idFont = daten.getReferenceArray("Font").getReferenceValue(i).getId();
							final SystemObjekt tmpFont;
							if (idFont == 0) {
								tmpFont = null;
							} else {
								final SystemObject soFont = factory.getDav().getDataModel().getObject(idFont);
								if (soFont == null) {
										tmpFont = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.FontUngueltig(idFont);
								} else {
									tmpFont = factory.getModellobjekt(soFont);
								}
							}
								getFont().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Font
								) tmpFont);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setKannFreieGrafik(getKannFreieGrafik());
							klon.setAufloesungX(getAufloesungX());
							klon.setAufloesungY(getAufloesungY());
							klon.setFarbdarstellung(getFarbdarstellung());
							klon.setKannFreiText(getKannFreiText());
							klon.setTimeoutSchaltBildWechsel(getTimeoutSchaltBildWechsel());
						klon._font = getFont().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.anzeigeTyp";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdAnzeigeTyp(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
