/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 9
 */
public class KdLigaturen extends AbstractKonfigurationsDatensatz<KdLigaturen.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttZeichenAbstandBreite
				> _zeichenabstand = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttZeichenAbstandBreite
				>(1, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Zeichen
				> _zeichen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Zeichen
				>(2, true);
		
			/**
			Zeichenabstand zwischen den Zeichen in Anteilen der Schrifthöhe.
			<p>
			Die erste Variable gibt den Abstand zwischen Zeichen 1 und 2, die zweite Variable den Abstand zwischen Zeichen 2 und 3 etc. an. Der Abstand in einer Ligatur ist definitionsgemäss in der Regel negativ.
			</p>
			
			@return der Wert von Zeichenabstand.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttZeichenAbstandBreite
				> getZeichenabstand() {
				return _zeichenabstand;
			}
		
		
			/**
			Geordnete Liste mit den Referenzen auf die in der Ligatur enthaltenen Zeichen.
			<p>
			
			</p>
			
			@return der Wert von Zeichen.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Zeichen
				> getZeichen() {
				return _zeichen;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getZeichenabstand() != null) {
						final Data.NumberArray arrayZeichenabstand = datum.
							getScaledArray
							("Zeichenabstand");
						arrayZeichenabstand.setLength(getZeichenabstand().size());
						for (int i = 0; i < arrayZeichenabstand.getLength(); ++i) {
							arrayZeichenabstand.getValue(i).set(getZeichenabstand().get(i).getValue());
						}
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayZeichen = datum.getReferenceArray("Zeichen");
						arrayZeichen.setLength(getZeichen().size());
						for (int i = 0; i < arrayZeichen.getLength(); ++i) {
							final Object soZeichen = getZeichen().get(i);
							final SystemObject tmpZeichen;
							if (soZeichen instanceof SystemObject) {
								tmpZeichen = (SystemObject)soZeichen;
							} else if(soZeichen instanceof SystemObjekt){
								tmpZeichen = ((SystemObjekt)soZeichen).getSystemObject();
							} else{
								tmpZeichen = null;
							}
							arrayZeichen.getReferenceValue(i).setSystemObject(tmpZeichen);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
						final Data.NumberArray arrayZeichenabstand = daten.
							getScaledArray
						("Zeichenabstand");
		
						for (int i = 0; i < arrayZeichenabstand.getLength(); ++i) {
		                    if (arrayZeichenabstand.getValue(i).isState()) {
		                        getZeichenabstand().add(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttZeichenAbstandBreite
		                        .getZustand(arrayZeichenabstand.getValue(i).getState().getName()));
		                    } else {
		                    getZeichenabstand().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttZeichenAbstandBreite
		                    (arrayZeichenabstand.
		                    	doubleValue
		                    (i)));
		                    }
		                }
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayZeichen = daten.getReferenceArray("Zeichen");
						for (int i = 0; i < arrayZeichen.getLength(); ++i) {
							final long idZeichen = daten.getReferenceArray("Zeichen").getReferenceValue(i).getId();
							final SystemObjekt tmpZeichen;
							if (idZeichen == 0) {
								tmpZeichen = null;
							} else {
								final SystemObject soZeichen = factory.getDav().getDataModel().getObject(idZeichen);
								if (soZeichen == null) {
										tmpZeichen = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.ZeichenUngueltig(idZeichen);
								} else {
									tmpZeichen = factory.getModellobjekt(soZeichen);
								}
							}
								getZeichen().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Zeichen
								) tmpZeichen);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._zeichenabstand = getZeichenabstand().clone();
						klon._zeichen = getZeichen().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ligaturen";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdLigaturen(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
