/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class KdWvzInhalt extends AbstractKonfigurationsDatensatz<KdWvzInhalt.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _bildinhalt
				= new String
				()
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Wechseltext
				 _wechseltext
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _istGrafik
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WzgInhaltGrafik
				> _grafikDarstellungen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WzgInhaltGrafik
				>(0, true);
		
			/**
			BildInhalt des Wvz.
			<p>
			&lt;absatz&gt;
										Der Bildinhalt legt den semantischen Inhalt dieses WVZ-Inhalts durch einen String fest.
										Da der String immer Eindeutig sein sollte, damit das jeweilge Steuermodell damit umgehen kann
										sollte er mit dem für die Zeichendefinition Verantwwortlichen (konfigurationsverantwortlicher oder vergleichbar) beginnen,
										und die jeweilige Einzelbedeutung mit einem "." abgetrennt werden. ,
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										Sofern ein Zeichen mit gleicher semantischer Bedeutung z.B. in seiner grafischen Darstellung
										für unterschiedliche Anzeigetypen unterschiedlich modelliert werden muss - z.B. unterschieddliche Grafiken,
										oder unterschiedliche Wechseltexte für schmale und breite Wechseltextzeichen
										(nicht aber wegen unterschiedlicher Umsetzung in Steuerprotokole, diese kann immer AQ-spezifisch modelliert werden) -
										so erhalten zwei Datensätze wvzInhalt die gleiche Bildbeschreibung, und können so von Steueralgorithmus
										gleichbedeutend verwendet werden.
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von Bildinhalt.
			*/
				public String
				 getBildinhalt() {
				return _bildinhalt;
			}
		
			/**
			BildInhalt des Wvz.
			<p>
			&lt;absatz&gt;
										Der Bildinhalt legt den semantischen Inhalt dieses WVZ-Inhalts durch einen String fest.
										Da der String immer Eindeutig sein sollte, damit das jeweilge Steuermodell damit umgehen kann
										sollte er mit dem für die Zeichendefinition Verantwwortlichen (konfigurationsverantwortlicher oder vergleichbar) beginnen,
										und die jeweilige Einzelbedeutung mit einem "." abgetrennt werden. ,
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										Sofern ein Zeichen mit gleicher semantischer Bedeutung z.B. in seiner grafischen Darstellung
										für unterschiedliche Anzeigetypen unterschiedlich modelliert werden muss - z.B. unterschieddliche Grafiken,
										oder unterschiedliche Wechseltexte für schmale und breite Wechseltextzeichen
										(nicht aber wegen unterschiedlicher Umsetzung in Steuerprotokole, diese kann immer AQ-spezifisch modelliert werden) -
										so erhalten zwei Datensätze wvzInhalt die gleiche Bildbeschreibung, und können so von Steueralgorithmus
										gleichbedeutend verwendet werden.
									&lt;&#47;absatz&gt;
			</p>
			
			@param _bildinhalt der neue Wert von Bildinhalt.
			*/
			public void setBildinhalt(String
			 _bildinhalt) {
				if (_bildinhalt.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bildinhalt = _bildinhalt;
			}
		
			/**
			Benutzter Wechseltext.
			<p>
			
			</p>
			
			@return der Wert von Wechseltext.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Wechseltext
				 getWechseltext() {
				return _wechseltext;
			}
		
			/**
			Benutzter Wechseltext.
			<p>
			
			</p>
			
			@param _wechseltext der neue Wert von Wechseltext.
			*/
			public void setWechseltext(	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Wechseltext
			 _wechseltext) {
				this._wechseltext = _wechseltext;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von IstGrafik.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getIstGrafik() {
				return _istGrafik;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _istGrafik der neue Wert von IstGrafik.
			*/
			public void setIstGrafik(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _istGrafik) {
				this._istGrafik = _istGrafik;
			}
		
			/**
			Grafiken für die Darstellung der Grafik.
			<p>
			
			</p>
			
			@return der Wert von GrafikDarstellungen.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WzgInhaltGrafik
				> getGrafikDarstellungen() {
				return _grafikDarstellungen;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getBildinhalt() != null) {
						datum.getTextValue("Bildinhalt").setText(getBildinhalt());
					}
					// ObjektReferenzAttributTyp
						final Object soWechseltext = getWechseltext();
						final SystemObject tmpWechseltext;
							if (soWechseltext instanceof SystemObject) {
								tmpWechseltext = (SystemObject)soWechseltext;
							} else if(soWechseltext instanceof SystemObjekt){
								tmpWechseltext = ((SystemObjekt)soWechseltext).getSystemObject();
							} else{
								tmpWechseltext = null;
							}
						datum.getReferenceValue("Wechseltext").setSystemObject(tmpWechseltext);
					// GanzzahlAttributTyp
					if (getIstGrafik() != null) {
		                if (getIstGrafik().isZustand()) {
		                    datum.getUnscaledValue("IstGrafik").setText(getIstGrafik().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("IstGrafik").set(getIstGrafik().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayGrafikDarstellungen = datum.getReferenceArray("GrafikDarstellungen");
						arrayGrafikDarstellungen.setLength(getGrafikDarstellungen().size());
						for (int i = 0; i < arrayGrafikDarstellungen.getLength(); ++i) {
							final Object soGrafikDarstellungen = getGrafikDarstellungen().get(i);
							final SystemObject tmpGrafikDarstellungen;
							if (soGrafikDarstellungen instanceof SystemObject) {
								tmpGrafikDarstellungen = (SystemObject)soGrafikDarstellungen;
							} else if(soGrafikDarstellungen instanceof SystemObjekt){
								tmpGrafikDarstellungen = ((SystemObjekt)soGrafikDarstellungen).getSystemObject();
							} else{
								tmpGrafikDarstellungen = null;
							}
							arrayGrafikDarstellungen.getReferenceValue(i).setSystemObject(tmpGrafikDarstellungen);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setBildinhalt(daten.getTextValue("Bildinhalt").getText());
					// ObjektReferenzAttributTyp
						final long idWechseltext = daten.getReferenceValue("Wechseltext").getId();
						final SystemObjekt tmpWechseltext;
						if (idWechseltext == 0) {
							tmpWechseltext = null;
						} else {
							final SystemObject soWechseltext = factory.getDav().getDataModel().getObject(idWechseltext);
							if (soWechseltext == null) {
									tmpWechseltext = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.WechseltextUngueltig(idWechseltext);
							} else {
								tmpWechseltext = factory.getModellobjekt(soWechseltext);
							}
						}
						setWechseltext((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Wechseltext
						) tmpWechseltext);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("IstGrafik").isState()) {
								setIstGrafik(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("IstGrafik").getText()));
							} else {
							setIstGrafik(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("IstGrafik").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayGrafikDarstellungen = daten.getReferenceArray("GrafikDarstellungen");
						for (int i = 0; i < arrayGrafikDarstellungen.getLength(); ++i) {
							final long idGrafikDarstellungen = daten.getReferenceArray("GrafikDarstellungen").getReferenceValue(i).getId();
							final SystemObjekt tmpGrafikDarstellungen;
							if (idGrafikDarstellungen == 0) {
								tmpGrafikDarstellungen = null;
							} else {
								final SystemObject soGrafikDarstellungen = factory.getDav().getDataModel().getObject(idGrafikDarstellungen);
								if (soGrafikDarstellungen == null) {
										tmpGrafikDarstellungen = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.WzgInhaltGrafikUngueltig(idGrafikDarstellungen);
								} else {
									tmpGrafikDarstellungen = factory.getModellobjekt(soGrafikDarstellungen);
								}
							}
								getGrafikDarstellungen().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WzgInhaltGrafik
								) tmpGrafikDarstellungen);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setBildinhalt(getBildinhalt());
							klon.setWechseltext(getWechseltext());
							klon.setIstGrafik(getIstGrafik());
						klon._grafikDarstellungen = getGrafikDarstellungen().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.wvzInhalt";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdWvzInhalt(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
