/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Anzeige.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface Anzeige extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.anzeige"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
/**
Menge der Fahrstreifen, die einen Messquerschnitt bilden.
<p>

</p>

@return die Menge FahrStreifen oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FahrStreifen> getFahrStreifen();


	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Rückmeldungsseitiger Autark Anzeige-Inhalt einer Anzeige.
	<p>
	
	</p>
	@return der Datensatz AnzeigeAutarkIst.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdAnzeigeAutarkIst getOdAnzeigeAutarkIst();
	
	/**
	Befehlsseitiger Autark Anzeige-Inhalt einer Anzeige.
	<p>
	
	</p>
	@return der Datensatz AnzeigeAutarkSoll.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdAnzeigeAutarkSoll getOdAnzeigeAutarkSoll();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Ist Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz AnzeigeEigenschaftIst.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdAnzeigeEigenschaftIst getOdAnzeigeEigenschaftIst();
	
	/**
	Soll Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz AnzeigeEigenschaftSoll.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdAnzeigeEigenschaftSoll getOdAnzeigeEigenschaftSoll();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Bedeutung der Anzeige für Copy und Paste.
	<p>
	Die angegebene Bezeichnung wird für die Copy-Paste-Funktionalität verwendet.
						  D. h. bei Copy wird der Inhalt der Anzeige unter der BedeutungCopyPaste zwischengespeichert,
	            beim Paste werden die zwischengespeicherten Inhalte über die BedeutungCopyPaste den Anzeigen, die die gespeicherten Inhalte erhalten sollen, zugeordnet.
	            Durch sinnvolle Versorgung kann damit eine sinnvolle Zuordnung der verkehrlichen Bedeutungen erfolgen.
	</p>
	@return der Datensatz AnzeigeBedeutungCopyPaste.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten.KdAnzeigeBedeutungCopyPaste getKdAnzeigeBedeutungCopyPaste();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz Anzeige.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten.KdAnzeige getKdAnzeige();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
