/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Anzeigequerschnitt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface AnzeigeQuerschnitt extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt,de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt,de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktXY
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.anzeigeQuerschnitt"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
/**
Menge der Anzeigen, die einen Anzeigequerschnitt bilden.
<p>

</p>

@return die Menge Anzeigen oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige> getAnzeigen();


	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Soll Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz AnzeigeQuerschnittEigenschaftSoll.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdAnzeigeQuerschnittEigenschaftSoll getOdAnzeigeQuerschnittEigenschaftSoll();
	
	/**
	Ist Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz AnzeigeQuerschnittEigenschaftIst.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdAnzeigeQuerschnittEigenschaftIst getOdAnzeigeQuerschnittEigenschaftIst();
	
	/**
	Erweiterte konfigurierende Eigenschaften der Objekte des Typs für die NBA.
	<p>
	
	</p>
	@return der Datensatz AnzeigeQuerschnittNba.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten.KdAnzeigeQuerschnittNba getKdAnzeigeQuerschnittNba();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Rückmeldungsseitiger Autark Anzeige-Inhalt eines AnzeigeQuerschnitt oder Dirigenten.
	<p>
	
	</p>
	@return der Datensatz NichtAnzeigeAutarkIst.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdNichtAnzeigeAutarkIst getOdNichtAnzeigeAutarkIst();
	
	/**
	Quellen VLT für Interimslösung.
	<p>
	Für die Bestimmung von Stromausfall und Türkontakt werden die DE's benötigt,
	            die die entsprechenden Daten liefern.
						  In dieser AttributGruppe können dafür jeweils die DE'n, die AttributGruppe, Aspekt, das Attribut und
						  der Attribut-Wert für den entsprechenden Zustand konfiguriert werden.
	</p>
	@return der Datensatz AnzeigeQuerschnittQuellenVlt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten.KdAnzeigeQuerschnittQuellenVlt getKdAnzeigeQuerschnittQuellenVlt();
	
	/**
	Information über die Schaltbarkeit des AnzeigeQuerschnitt durch die NBA.
	<p>
	
	</p>
	@return der Datensatz AnzeigeQuerschnittSchaltbarkeitNba.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdAnzeigeQuerschnittSchaltbarkeitNba getOdAnzeigeQuerschnittSchaltbarkeitNba();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Referenz auf ein Linienobjekt mit Offsetangabe vom Begin der Linie. Darüber läßt sich dessen Koordinate ermitteln. Liegen mehrer Objekte auf einem Linienobjekt, läßt sich über die Offsets die Topologie ermitteln.
	<p>
	
	</p>
	@return der Datensatz PunktLiegtAufLinienObjekt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt getKdPunktLiegtAufLinienObjekt();
	
	/**
	Befehlsseitiger Autark Anzeige-Inhalt eines AnzeigeQuerschnitt oder Dirigenten.
	<p>
	
	</p>
	@return der Datensatz NichtAnzeigeAutarkSoll.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdNichtAnzeigeAutarkSoll getOdNichtAnzeigeAutarkSoll();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz AnzeigeQuerschnitt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten.KdAnzeigeQuerschnitt getKdAnzeigeQuerschnitt();
	
	/**
	Koordinaten eines Punktes in Grad entsprechend WGS84.
	<p>
	
	</p>
	@return der Datensatz PunktKoordinaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
