/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ist Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 9
 */
public class OdAnzeigeEigenschaftIst extends AbstractOnlineDatensatz<OdAnzeigeEigenschaftIst.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.AqZustand,
				};
			}
	
			/**
			 * Zustand durch Rückmeldung von Extern.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AqZustand = new Aspekte("AQZustand", "asp.aqZustand");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlAnzeigeEigenschaft
				 _eigenschaft
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlAnzeigeEigenschaft
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttAnzeigeFehlerZustand
				 _status
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WvzInhalt
				> _gestoerteInhalte = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WvzInhalt
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTextPosition
				> _gestoerteTextpositionen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTextPosition
				>(0, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
				> _aktFehlerMeldungen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
				>(0, true);
		
			/**
			Gemeinsame Eigenschaften für Soll und Ist.
			<p>
			
			</p>
			
			@return der Wert von Eigenschaft.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlAnzeigeEigenschaft
				 getEigenschaft() {
				return _eigenschaft;
			}
		
			/**
			Gemeinsame Eigenschaften für Soll und Ist.
			<p>
			
			</p>
			
			@param _eigenschaft der neue Wert von Eigenschaft.
			*/
			public void setEigenschaft(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlAnzeigeEigenschaft
			 _eigenschaft) {
				this._eigenschaft = _eigenschaft;
			}
		
			/**
			Aktueller Status der Anzeige. OK, gestört, teilgestört, usw..
			<p>
			
			</p>
			
			@return der Wert von Status.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttAnzeigeFehlerZustand
				 getStatus() {
				return _status;
			}
		
			/**
			Aktueller Status der Anzeige. OK, gestört, teilgestört, usw..
			<p>
			
			</p>
			
			@param _status der neue Wert von Status.
			*/
			public void setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttAnzeigeFehlerZustand
			 _status) {
				this._status = _status;
			}
		
			/**
			Liste mit Referenzen auf gestörte WvzInhalte.
			<p>
			
			</p>
			
			@return der Wert von GestoerteInhalte.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WvzInhalt
				> getGestoerteInhalte() {
				return _gestoerteInhalte;
			}
		
		
			/**
			Aktueller Status der Anzeige. OK, gestört, teilgestört, usw..
			<p>
			
			</p>
			
			@return der Wert von GestoerteTextpositionen.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTextPosition
				> getGestoerteTextpositionen() {
				return _gestoerteTextpositionen;
			}
		
		
			/**
			Referenz auf beliebige Objekte vom Typ Fehlermeldung.
			<p>
			
			</p>
			
			@return der Wert von AktFehlerMeldungen.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
				> getAktFehlerMeldungen() {
				return _aktFehlerMeldungen;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getEigenschaft().bean2Atl(datum.getItem("Eigenschaft"), factory);
					// GanzzahlAttributTyp
					if (getStatus() != null) {
		                if (getStatus().isZustand()) {
		                    datum.getUnscaledValue("Status").setText(getStatus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Status").set(getStatus().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayGestoerteInhalte = datum.getReferenceArray("GestörteInhalte");
						arrayGestoerteInhalte.setLength(getGestoerteInhalte().size());
						for (int i = 0; i < arrayGestoerteInhalte.getLength(); ++i) {
							final Object soGestoerteInhalte = getGestoerteInhalte().get(i);
							final SystemObject tmpGestoerteInhalte;
							if (soGestoerteInhalte instanceof SystemObject) {
								tmpGestoerteInhalte = (SystemObject)soGestoerteInhalte;
							} else if(soGestoerteInhalte instanceof SystemObjekt){
								tmpGestoerteInhalte = ((SystemObjekt)soGestoerteInhalte).getSystemObject();
							} else{
								tmpGestoerteInhalte = null;
							}
							arrayGestoerteInhalte.getReferenceValue(i).setSystemObject(tmpGestoerteInhalte);
						}
					// GanzzahlAttributTyp
					if (getGestoerteTextpositionen() != null) {
						final Data.NumberArray arrayGestoerteTextpositionen = datum.
							getUnscaledArray
							("GestörteTextpositionen");
						arrayGestoerteTextpositionen.setLength(getGestoerteTextpositionen().size());
						for (int i = 0; i < arrayGestoerteTextpositionen.getLength(); ++i) {
							arrayGestoerteTextpositionen.getValue(i).set(getGestoerteTextpositionen().get(i).getValue());
						}
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAktFehlerMeldungen = datum.getReferenceArray("AktFehlerMeldungen");
						arrayAktFehlerMeldungen.setLength(getAktFehlerMeldungen().size());
						for (int i = 0; i < arrayAktFehlerMeldungen.getLength(); ++i) {
							final Object soAktFehlerMeldungen = getAktFehlerMeldungen().get(i);
							final SystemObject tmpAktFehlerMeldungen;
							if (soAktFehlerMeldungen instanceof SystemObject) {
								tmpAktFehlerMeldungen = (SystemObject)soAktFehlerMeldungen;
							} else if(soAktFehlerMeldungen instanceof SystemObjekt){
								tmpAktFehlerMeldungen = ((SystemObjekt)soAktFehlerMeldungen).getSystemObject();
							} else{
								tmpAktFehlerMeldungen = null;
							}
							arrayAktFehlerMeldungen.getReferenceValue(i).setSystemObject(tmpAktFehlerMeldungen);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getEigenschaft().atl2Bean(daten.getItem("Eigenschaft"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Status").isState()) {
								setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttAnzeigeFehlerZustand
								.getZustand(daten.getScaledValue("Status").getText()));
							} else {
							setStatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttAnzeigeFehlerZustand
							(daten.
								getUnscaledValue
							("Status").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayGestoerteInhalte = daten.getReferenceArray("GestörteInhalte");
						for (int i = 0; i < arrayGestoerteInhalte.getLength(); ++i) {
							final long idGestoerteInhalte = daten.getReferenceArray("GestörteInhalte").getReferenceValue(i).getId();
							final SystemObjekt tmpGestoerteInhalte;
							if (idGestoerteInhalte == 0) {
								tmpGestoerteInhalte = null;
							} else {
								final SystemObject soGestoerteInhalte = factory.getDav().getDataModel().getObject(idGestoerteInhalte);
								if (soGestoerteInhalte == null) {
										tmpGestoerteInhalte = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.WvzInhaltUngueltig(idGestoerteInhalte);
								} else {
									tmpGestoerteInhalte = factory.getModellobjekt(soGestoerteInhalte);
								}
							}
								getGestoerteInhalte().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WvzInhalt
								) tmpGestoerteInhalte);
						}
					// GanzzahlAttributTyp
						final Data.NumberArray arrayGestoerteTextpositionen = daten.
							getUnscaledArray
						("GestörteTextpositionen");
		
						for (int i = 0; i < arrayGestoerteTextpositionen.getLength(); ++i) {
		                    getGestoerteTextpositionen().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTextPosition
		                    (arrayGestoerteTextpositionen.
		                    		intValue
		                    (i)));
		                }
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAktFehlerMeldungen = daten.getReferenceArray("AktFehlerMeldungen");
						for (int i = 0; i < arrayAktFehlerMeldungen.getLength(); ++i) {
							final long idAktFehlerMeldungen = daten.getReferenceArray("AktFehlerMeldungen").getReferenceValue(i).getId();
							final SystemObjekt tmpAktFehlerMeldungen;
							if (idAktFehlerMeldungen == 0) {
								tmpAktFehlerMeldungen = null;
							} else {
								final SystemObject soAktFehlerMeldungen = factory.getDav().getDataModel().getObject(idAktFehlerMeldungen);
								if (soAktFehlerMeldungen == null) {
										tmpAktFehlerMeldungen = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.KonfigurationsObjektUngueltig(idAktFehlerMeldungen);
								} else {
									tmpAktFehlerMeldungen = factory.getModellobjekt(soAktFehlerMeldungen);
								}
							}
								getAktFehlerMeldungen().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
								) tmpAktFehlerMeldungen);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._eigenschaft = getEigenschaft().clone();
							klon.setStatus(getStatus());
						klon._gestoerteInhalte = getGestoerteInhalte().clone();
						klon._gestoerteTextpositionen = getGestoerteTextpositionen().clone();
						klon._aktFehlerMeldungen = getAktFehlerMeldungen().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.anzeigeEigenschaftIst";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdAnzeigeEigenschaftIst(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
