/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Soll Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public class OdDirigentEigenschaftSoll extends AbstractOnlineDatensatz<OdDirigentEigenschaftSoll.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.AqVorgabe,
				};
			}
	
			/**
			 * Vorgabe durch Steuerung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AqVorgabe = new Aspekte("AQVorgabe", "asp.aqVorgabe");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlDirigentEigenschaft
				 _eigenschaft
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlDirigentEigenschaft
				()
				;
				private 	Zeitstempel
				 _sollZeitpunkt
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
				> _anzeigeQuerschnitte = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
				>(0, true);
		
			/**
			Gemeinsame Eigenschaften für Soll und Ist.
			<p>
			
			</p>
			
			@return der Wert von Eigenschaft.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlDirigentEigenschaft
				 getEigenschaft() {
				return _eigenschaft;
			}
		
			/**
			Gemeinsame Eigenschaften für Soll und Ist.
			<p>
			
			</p>
			
			@param _eigenschaft der neue Wert von Eigenschaft.
			*/
			public void setEigenschaft(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlDirigentEigenschaft
			 _eigenschaft) {
				this._eigenschaft = _eigenschaft;
			}
		
			/**
			Absoluter Zeitpunkt an dem der Dirigent geschaltet werden soll.
			<p>
			
			</p>
			
			@return der Wert von SollZeitpunkt.
			*/
				public 	Zeitstempel
				 getSollZeitpunkt() {
				return _sollZeitpunkt;
			}
		
			/**
			Absoluter Zeitpunkt an dem der Dirigent geschaltet werden soll.
			<p>
			
			</p>
			
			@param _sollZeitpunkt der neue Wert von SollZeitpunkt.
			*/
			public void setSollZeitpunkt(	Zeitstempel
			 _sollZeitpunkt) {
				this._sollZeitpunkt = _sollZeitpunkt;
			}
		
			/**
			AnzeigeQuerschnitte, die innerhalb des Dirigenten beeinflußt werden sollen.
			<p>
			
			</p>
			
			@return der Wert von AnzeigeQuerschnitte.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
				> getAnzeigeQuerschnitte() {
				return _anzeigeQuerschnitte;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getEigenschaft().bean2Atl(datum.getItem("Eigenschaft"), factory);
					// ZeitstempelAttributTyp
						datum.getTimeValue("SollZeitpunkt").setMillis(getSollZeitpunkt().getTime());
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAnzeigeQuerschnitte = datum.getReferenceArray("AnzeigeQuerschnitte");
						arrayAnzeigeQuerschnitte.setLength(getAnzeigeQuerschnitte().size());
						for (int i = 0; i < arrayAnzeigeQuerschnitte.getLength(); ++i) {
							final Object soAnzeigeQuerschnitte = getAnzeigeQuerschnitte().get(i);
							final SystemObject tmpAnzeigeQuerschnitte;
							if (soAnzeigeQuerschnitte instanceof SystemObject) {
								tmpAnzeigeQuerschnitte = (SystemObject)soAnzeigeQuerschnitte;
							} else if(soAnzeigeQuerschnitte instanceof SystemObjekt){
								tmpAnzeigeQuerschnitte = ((SystemObjekt)soAnzeigeQuerschnitte).getSystemObject();
							} else{
								tmpAnzeigeQuerschnitte = null;
							}
							arrayAnzeigeQuerschnitte.getReferenceValue(i).setSystemObject(tmpAnzeigeQuerschnitte);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getEigenschaft().atl2Bean(daten.getItem("Eigenschaft"), factory);
					// ZeitstempelAttributTyp
						setSollZeitpunkt(new
							Zeitstempel
							(daten.getTimeValue("SollZeitpunkt").getMillis()));
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAnzeigeQuerschnitte = daten.getReferenceArray("AnzeigeQuerschnitte");
						for (int i = 0; i < arrayAnzeigeQuerschnitte.getLength(); ++i) {
							final long idAnzeigeQuerschnitte = daten.getReferenceArray("AnzeigeQuerschnitte").getReferenceValue(i).getId();
							final SystemObjekt tmpAnzeigeQuerschnitte;
							if (idAnzeigeQuerschnitte == 0) {
								tmpAnzeigeQuerschnitte = null;
							} else {
								final SystemObject soAnzeigeQuerschnitte = factory.getDav().getDataModel().getObject(idAnzeigeQuerschnitte);
								if (soAnzeigeQuerschnitte == null) {
										tmpAnzeigeQuerschnitte = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeQuerschnittUngueltig(idAnzeigeQuerschnitte);
								} else {
									tmpAnzeigeQuerschnitte = factory.getModellobjekt(soAnzeigeQuerschnitte);
								}
							}
								getAnzeigeQuerschnitte().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
								) tmpAnzeigeQuerschnitte);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._eigenschaft = getEigenschaft().clone();
							klon.setSollZeitpunkt(getSollZeitpunkt());
						klon._anzeigeQuerschnitte = getAnzeigeQuerschnitte().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.dirigentEigenschaftSoll";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdDirigentEigenschaftSoll(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
