/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdAnzeigeAktor extends AbstractKonfigurationsDatensatz<KdAnzeigeAktor.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
				 _anzeigeReferenz
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.AnzeigeTypUmsetzung
				 _anzeigeTypUmsetzungReferenz
				;
		
			/**
			Referenz auf ein Objekt vom Typ Anzeige zur Umsetzung der Befehle und Rückmeldungen zu und von der externen Kommunikation.
			<p>
			
			</p>
			
			@return der Wert von AnzeigeReferenz.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
				 getAnzeigeReferenz() {
				return _anzeigeReferenz;
			}
		
			/**
			Referenz auf ein Objekt vom Typ Anzeige zur Umsetzung der Befehle und Rückmeldungen zu und von der externen Kommunikation.
			<p>
			
			</p>
			
			@param _anzeigeReferenz der neue Wert von AnzeigeReferenz.
			*/
			public void setAnzeigeReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
			 _anzeigeReferenz) {
				this._anzeigeReferenz = _anzeigeReferenz;
			}
		
			/**
			Referenz auf ein Objekt vom Typ AnzeigeTypUmsetzung zur Umsetzung der Befehle und Rückmeldungen zu und von der externen Kommunikation.
			<p>
			
			</p>
			
			@return der Wert von AnzeigeTypUmsetzungReferenz.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.AnzeigeTypUmsetzung
				 getAnzeigeTypUmsetzungReferenz() {
				return _anzeigeTypUmsetzungReferenz;
			}
		
			/**
			Referenz auf ein Objekt vom Typ AnzeigeTypUmsetzung zur Umsetzung der Befehle und Rückmeldungen zu und von der externen Kommunikation.
			<p>
			
			</p>
			
			@param _anzeigeTypUmsetzungReferenz der neue Wert von AnzeigeTypUmsetzungReferenz.
			*/
			public void setAnzeigeTypUmsetzungReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.AnzeigeTypUmsetzung
			 _anzeigeTypUmsetzungReferenz) {
				this._anzeigeTypUmsetzungReferenz = _anzeigeTypUmsetzungReferenz;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soAnzeigeReferenz = getAnzeigeReferenz();
						final SystemObject tmpAnzeigeReferenz;
							if (soAnzeigeReferenz instanceof SystemObject) {
								tmpAnzeigeReferenz = (SystemObject)soAnzeigeReferenz;
							} else if(soAnzeigeReferenz instanceof SystemObjekt){
								tmpAnzeigeReferenz = ((SystemObjekt)soAnzeigeReferenz).getSystemObject();
							} else{
								tmpAnzeigeReferenz = null;
							}
						datum.getReferenceValue("AnzeigeReferenz").setSystemObject(tmpAnzeigeReferenz);
					// ObjektReferenzAttributTyp
						final Object soAnzeigeTypUmsetzungReferenz = getAnzeigeTypUmsetzungReferenz();
						final SystemObject tmpAnzeigeTypUmsetzungReferenz;
							if (soAnzeigeTypUmsetzungReferenz instanceof SystemObject) {
								tmpAnzeigeTypUmsetzungReferenz = (SystemObject)soAnzeigeTypUmsetzungReferenz;
							} else if(soAnzeigeTypUmsetzungReferenz instanceof SystemObjekt){
								tmpAnzeigeTypUmsetzungReferenz = ((SystemObjekt)soAnzeigeTypUmsetzungReferenz).getSystemObject();
							} else{
								tmpAnzeigeTypUmsetzungReferenz = null;
							}
						datum.getReferenceValue("AnzeigeTypUmsetzungReferenz").setSystemObject(tmpAnzeigeTypUmsetzungReferenz);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idAnzeigeReferenz = daten.getReferenceValue("AnzeigeReferenz").getId();
						final SystemObjekt tmpAnzeigeReferenz;
						if (idAnzeigeReferenz == 0) {
							tmpAnzeigeReferenz = null;
						} else {
							final SystemObject soAnzeigeReferenz = factory.getDav().getDataModel().getObject(idAnzeigeReferenz);
							if (soAnzeigeReferenz == null) {
									tmpAnzeigeReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeUngueltig(idAnzeigeReferenz);
							} else {
								tmpAnzeigeReferenz = factory.getModellobjekt(soAnzeigeReferenz);
							}
						}
						setAnzeigeReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
						) tmpAnzeigeReferenz);
					// ObjektReferenzAttributTyp
						final long idAnzeigeTypUmsetzungReferenz = daten.getReferenceValue("AnzeigeTypUmsetzungReferenz").getId();
						final SystemObjekt tmpAnzeigeTypUmsetzungReferenz;
						if (idAnzeigeTypUmsetzungReferenz == 0) {
							tmpAnzeigeTypUmsetzungReferenz = null;
						} else {
							final SystemObject soAnzeigeTypUmsetzungReferenz = factory.getDav().getDataModel().getObject(idAnzeigeTypUmsetzungReferenz);
							if (soAnzeigeTypUmsetzungReferenz == null) {
									tmpAnzeigeTypUmsetzungReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.impl.AnzeigeTypUmsetzungUngueltig(idAnzeigeTypUmsetzungReferenz);
							} else {
								tmpAnzeigeTypUmsetzungReferenz = factory.getModellobjekt(soAnzeigeTypUmsetzungReferenz);
							}
						}
						setAnzeigeTypUmsetzungReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.AnzeigeTypUmsetzung
						) tmpAnzeigeTypUmsetzungReferenz);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAnzeigeReferenz(getAnzeigeReferenz());
							klon.setAnzeigeTypUmsetzungReferenz(getAnzeigeTypUmsetzungReferenz());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.anzeigeAktor";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdAnzeigeAktor(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
