/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Plausibilitätsinformationen einer Anzeige (1 bis n DEs).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class AtlAnzeigeAktorTlsWvzStellZustand implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.DeWzg
			 _deWzgReferenz
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCode
			 _code
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _codePlausibel
			;
	
		/**
		Referenz auf die DE der Anzeige.
		<p>
		
		</p>
		
		@return der Wert von DeWzgReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.DeWzg
			 getDeWzgReferenz() {
			return _deWzgReferenz;
		}
	
		/**
		Referenz auf die DE der Anzeige.
		<p>
		
		</p>
		
		@param _deWzgReferenz der neue Wert von DeWzgReferenz.
		*/
		public void setDeWzgReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.DeWzg
		 _deWzgReferenz) {
			this._deWzgReferenz = _deWzgReferenz;
		}
	
		/**
		Code der von der DE als Ist-Zustand empfangen wurde.
		<p>
		
		</p>
		
		@return der Wert von Code.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCode
			 getCode() {
			return _code;
		}
	
		/**
		Code der von der DE als Ist-Zustand empfangen wurde.
		<p>
		
		</p>
		
		@param _code der neue Wert von Code.
		*/
		public void setCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCode
		 _code) {
			this._code = _code;
		}
	
		/**
		Zeigt an, ob der empfangene Code versorgt und somit plausibel ist.
		<p>
		
		</p>
		
		@return der Wert von CodePlausibel.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getCodePlausibel() {
			return _codePlausibel;
		}
	
		/**
		Zeigt an, ob der empfangene Code versorgt und somit plausibel ist.
		<p>
		
		</p>
		
		@param _codePlausibel der neue Wert von CodePlausibel.
		*/
		public void setCodePlausibel(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _codePlausibel) {
			this._codePlausibel = _codePlausibel;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soDeWzgReferenz = getDeWzgReferenz();
					final SystemObject tmpDeWzgReferenz;
						if (soDeWzgReferenz instanceof SystemObject) {
							tmpDeWzgReferenz = (SystemObject)soDeWzgReferenz;
						} else if(soDeWzgReferenz instanceof SystemObjekt){
							tmpDeWzgReferenz = ((SystemObjekt)soDeWzgReferenz).getSystemObject();
						} else{
							tmpDeWzgReferenz = null;
						}
					datum.getReferenceValue("DeWzgReferenz").setSystemObject(tmpDeWzgReferenz);
				// GanzzahlAttributTyp
				if (getCode() != null) {
	                if (getCode().isZustand()) {
	                    datum.getUnscaledValue("Code").setText(getCode().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Code").set(getCode().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getCodePlausibel() != null) {
	                if (getCodePlausibel().isZustand()) {
	                    datum.getUnscaledValue("CodePlausibel").setText(getCodePlausibel().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("CodePlausibel").set(getCodePlausibel().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idDeWzgReferenz = daten.getReferenceValue("DeWzgReferenz").getId();
					final SystemObjekt tmpDeWzgReferenz;
					if (idDeWzgReferenz == 0) {
						tmpDeWzgReferenz = null;
					} else {
						final SystemObject soDeWzgReferenz = factory.getDav().getDataModel().getObject(idDeWzgReferenz);
						if (soDeWzgReferenz == null) {
								tmpDeWzgReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.impl.DeWzgUngueltig(idDeWzgReferenz);
						} else {
							tmpDeWzgReferenz = factory.getModellobjekt(soDeWzgReferenz);
						}
					}
					setDeWzgReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.DeWzg
					) tmpDeWzgReferenz);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Code").isState()) {
							setCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCode
							.getZustand(daten.getScaledValue("Code").getText()));
						} else {
						setCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCode
						(daten.
							getUnscaledValue
						("Code").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("CodePlausibel").isState()) {
							setCodePlausibel(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("CodePlausibel").getText()));
						} else {
						setCodePlausibel(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("CodePlausibel").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAnzeigeAktorTlsWvzStellZustand clone() {
		AtlAnzeigeAktorTlsWvzStellZustand klon = new AtlAnzeigeAktorTlsWvzStellZustand();
		
						klon.setDeWzgReferenz(getDeWzgReferenz());
						klon.setCode(getCode());
						klon.setCodePlausibel(getCodePlausibel());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
