/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class AtlAnzeigenGlobalUmsetzung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
			 _umsetzungsObjekt
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			> _template = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			>(0, true);
			private String
			 _umsetzungsModul
			= new String
			()
			;
			private String
			 _attributGruppe
			= new String
			()
			;
			private Feld<String
			> _verwendeteAttributGruppenAspekte = new Feld<String
			>(0, true);
	
		/**
		Referenz auf beliebiges Objekt für Umsetzung (Information in spezieller ATG).
		<p>
		
		</p>
		
		@return der Wert von UmsetzungsObjekt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
			 getUmsetzungsObjekt() {
			return _umsetzungsObjekt;
		}
	
		/**
		Referenz auf beliebiges Objekt für Umsetzung (Information in spezieller ATG).
		<p>
		
		</p>
		
		@param _umsetzungsObjekt der neue Wert von UmsetzungsObjekt.
		*/
		public void setUmsetzungsObjekt(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
		 _umsetzungsObjekt) {
			this._umsetzungsObjekt = _umsetzungsObjekt;
		}
	
		/**
		Template mit Vorgabe des Telegrammaufbaus unter Verwendung von speziellen Zahlenwerten für Variablen (&gt; 255). Muss vermutlich ausserhalb der Datenliste definiert werden, damit die DTD das mehrfache Auftreten auch zulässt -&gt; ggf Rücksprache mit Herrn Schmitz!!!.
		<p>
		
		</p>
		
		@return der Wert von Template.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			> getTemplate() {
			return _template;
		}
	
	
		/**
		Das für die Umsetzung des Protokolls (Lesen und Schreiben) verwendete Modul an diesem Knoten. Wird kein Modul angegeben, wird jeweils das Standardumsetzungmodul für diesen Objekttyp verwendet. Text ist der Klassennamen des UmsetzungsModuls.
		<p>
		
		</p>
		
		@return der Wert von UmsetzungsModul.
		*/
			public String
			 getUmsetzungsModul() {
			return _umsetzungsModul;
		}
	
		/**
		Das für die Umsetzung des Protokolls (Lesen und Schreiben) verwendete Modul an diesem Knoten. Wird kein Modul angegeben, wird jeweils das Standardumsetzungmodul für diesen Objekttyp verwendet. Text ist der Klassennamen des UmsetzungsModuls.
		<p>
		
		</p>
		
		@param _umsetzungsModul der neue Wert von UmsetzungsModul.
		*/
		public void setUmsetzungsModul(String
		 _umsetzungsModul) {
			if (_umsetzungsModul.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._umsetzungsModul = _umsetzungsModul;
		}
	
		/**
		Für die Umsetzung zu verwendende AttributGruppe, wenn gesetzt, ansonsten default AttributGruppe verwenden.
		<p>
		
		</p>
		
		@return der Wert von AttributGruppe.
		*/
			public String
			 getAttributGruppe() {
			return _attributGruppe;
		}
	
		/**
		Für die Umsetzung zu verwendende AttributGruppe, wenn gesetzt, ansonsten default AttributGruppe verwenden.
		<p>
		
		</p>
		
		@param _attributGruppe der neue Wert von AttributGruppe.
		*/
		public void setAttributGruppe(String
		 _attributGruppe) {
			if (_attributGruppe.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._attributGruppe = _attributGruppe;
		}
	
		/**
		Für die Umsetzung verwendete AttributGruppen-Aspekt-Kombinationen (Attributgruppen werden auch für das Versenden verwendet).
		<p>
		
		</p>
		
		@return der Wert von VerwendeteAttributGruppenAspekte.
		*/
			public Feld<String
			> getVerwendeteAttributGruppenAspekte() {
			return _verwendeteAttributGruppenAspekte;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soUmsetzungsObjekt = getUmsetzungsObjekt();
					final SystemObject tmpUmsetzungsObjekt;
						if (soUmsetzungsObjekt instanceof SystemObject) {
							tmpUmsetzungsObjekt = (SystemObject)soUmsetzungsObjekt;
						} else if(soUmsetzungsObjekt instanceof SystemObjekt){
							tmpUmsetzungsObjekt = ((SystemObjekt)soUmsetzungsObjekt).getSystemObject();
						} else{
							tmpUmsetzungsObjekt = null;
						}
					datum.getReferenceValue("UmsetzungsObjekt").setSystemObject(tmpUmsetzungsObjekt);
				// GanzzahlAttributTyp
				if (getTemplate() != null) {
					final Data.NumberArray arrayTemplate = datum.
						getUnscaledArray
						("Template");
					arrayTemplate.setLength(getTemplate().size());
					for (int i = 0; i < arrayTemplate.getLength(); ++i) {
						arrayTemplate.getValue(i).set(getTemplate().get(i).getValue());
					}
				}
				// ZeichenkettenAttributTyp
				if (getUmsetzungsModul() != null) {
					datum.getTextValue("UmsetzungsModul").setText(getUmsetzungsModul());
				}
				// ZeichenkettenAttributTyp
				if (getAttributGruppe() != null) {
					datum.getTextValue("AttributGruppe").setText(getAttributGruppe());
				}
				// ZeichenkettenAttributTyp
				if (getVerwendeteAttributGruppenAspekte() != null) {
					final Data.TextArray arrayVerwendeteAttributGruppenAspekte = datum.getTextArray("VerwendeteAttributGruppenAspekte");
					arrayVerwendeteAttributGruppenAspekte.setLength(getVerwendeteAttributGruppenAspekte().size());
					for (int i = 0; i < arrayVerwendeteAttributGruppenAspekte.getLength(); ++i) {
						arrayVerwendeteAttributGruppenAspekte.getTextValue(i).setText(getVerwendeteAttributGruppenAspekte().get(i));
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idUmsetzungsObjekt = daten.getReferenceValue("UmsetzungsObjekt").getId();
					final SystemObjekt tmpUmsetzungsObjekt;
					if (idUmsetzungsObjekt == 0) {
						tmpUmsetzungsObjekt = null;
					} else {
						final SystemObject soUmsetzungsObjekt = factory.getDav().getDataModel().getObject(idUmsetzungsObjekt);
						if (soUmsetzungsObjekt == null) {
								tmpUmsetzungsObjekt = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.KonfigurationsObjektUngueltig(idUmsetzungsObjekt);
						} else {
							tmpUmsetzungsObjekt = factory.getModellobjekt(soUmsetzungsObjekt);
						}
					}
					setUmsetzungsObjekt((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
					) tmpUmsetzungsObjekt);
				// GanzzahlAttributTyp
					final Data.NumberArray arrayTemplate = daten.
						getUnscaledArray
					("Template");
	
					for (int i = 0; i < arrayTemplate.getLength(); ++i) {
	                    getTemplate().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
	                    (arrayTemplate.
	                    		longValue
	                    (i)));
	                }
				// ZeichenkettenAttributTyp
					setUmsetzungsModul(daten.getTextValue("UmsetzungsModul").getText());
				// ZeichenkettenAttributTyp
					setAttributGruppe(daten.getTextValue("AttributGruppe").getText());
				// ZeichenkettenAttributTyp
					final Data.TextArray arrayVerwendeteAttributGruppenAspekte = daten.getTextArray("VerwendeteAttributGruppenAspekte");
					for (int i = 0; i < arrayVerwendeteAttributGruppenAspekte.getLength(); ++i) {
						getVerwendeteAttributGruppenAspekte().add(arrayVerwendeteAttributGruppenAspekte.getText(i));
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAnzeigenGlobalUmsetzung clone() {
		AtlAnzeigenGlobalUmsetzung klon = new AtlAnzeigenGlobalUmsetzung();
		
						klon.setUmsetzungsObjekt(getUmsetzungsObjekt());
					klon._template = getTemplate().clone();
						klon.setUmsetzungsModul(getUmsetzungsModul());
						klon.setAttributGruppe(getAttributGruppe());
					klon._verwendeteAttributGruppenAspekte = getVerwendeteAttributGruppenAspekte().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
