/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Info.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlAblaufMitTemplate implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
			 _fahrtrichtung
			;
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.FahrSpur
			> _fahrSpurenVonRechtsNachLinks = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.FahrSpur
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
			> _querschnitteInFahrtrichtung = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
			>(0, true);
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.objekte.AblaufTemplate
			 _template
			;
	
		/**
		Fahrtrichtung, die für dieses Template gilt. Auf diese
								Richtung beziehen sich auch die folgenden Listen.
		<p>
		
		</p>
		
		@return der Wert von Fahrtrichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
			 getFahrtrichtung() {
			return _fahrtrichtung;
		}
	
		/**
		Fahrtrichtung, die für dieses Template gilt. Auf diese
								Richtung beziehen sich auch die folgenden Listen.
		<p>
		
		</p>
		
		@param _fahrtrichtung der neue Wert von Fahrtrichtung.
		*/
		public void setFahrtrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
		 _fahrtrichtung) {
			this._fahrtrichtung = _fahrtrichtung;
		}
	
		/**
		Diese Liste definiert eine Ordnung in Fahrtrichtung, auf
								die sich die Schaltungen innerhalb der Templates bezeihen.
		<p>
		
		</p>
		
		@return der Wert von FahrSpurenVonRechtsNachLinks.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.FahrSpur
			> getFahrSpurenVonRechtsNachLinks() {
			return _fahrSpurenVonRechtsNachLinks;
		}
	
	
		/**
		Eine Liste mit in Fahrtrichtung geordneten
								Anzeigequerschnitten. Wird in Template wie
								eine relative
								Fahrspurreferenz aufgelöst.
		<p>
		
		</p>
		
		@return der Wert von QuerschnitteInFahrtrichtung.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
			> getQuerschnitteInFahrtrichtung() {
			return _querschnitteInFahrtrichtung;
		}
	
	
		/**
		Referenz auf ein Ablauftemplate.
		<p>
		
		</p>
		
		@return der Wert von Template.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.objekte.AblaufTemplate
			 getTemplate() {
			return _template;
		}
	
		/**
		Referenz auf ein Ablauftemplate.
		<p>
		
		</p>
		
		@param _template der neue Wert von Template.
		*/
		public void setTemplate(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.objekte.AblaufTemplate
		 _template) {
			this._template = _template;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getFahrtrichtung() != null) {
	                if (getFahrtrichtung().isZustand()) {
	                    datum.getUnscaledValue("Fahrtrichtung").setText(getFahrtrichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Fahrtrichtung").set(getFahrtrichtung().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayFahrSpurenVonRechtsNachLinks = datum.getReferenceArray("FahrSpurenVonRechtsNachLinks");
					arrayFahrSpurenVonRechtsNachLinks.setLength(getFahrSpurenVonRechtsNachLinks().size());
					for (int i = 0; i < arrayFahrSpurenVonRechtsNachLinks.getLength(); ++i) {
						final Object soFahrSpurenVonRechtsNachLinks = getFahrSpurenVonRechtsNachLinks().get(i);
						final SystemObject tmpFahrSpurenVonRechtsNachLinks;
						if (soFahrSpurenVonRechtsNachLinks instanceof SystemObject) {
							tmpFahrSpurenVonRechtsNachLinks = (SystemObject)soFahrSpurenVonRechtsNachLinks;
						} else if(soFahrSpurenVonRechtsNachLinks instanceof SystemObjekt){
							tmpFahrSpurenVonRechtsNachLinks = ((SystemObjekt)soFahrSpurenVonRechtsNachLinks).getSystemObject();
						} else{
							tmpFahrSpurenVonRechtsNachLinks = null;
						}
						arrayFahrSpurenVonRechtsNachLinks.getReferenceValue(i).setSystemObject(tmpFahrSpurenVonRechtsNachLinks);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayQuerschnitteInFahrtrichtung = datum.getReferenceArray("QuerschnitteInFahrtrichtung");
					arrayQuerschnitteInFahrtrichtung.setLength(getQuerschnitteInFahrtrichtung().size());
					for (int i = 0; i < arrayQuerschnitteInFahrtrichtung.getLength(); ++i) {
						final Object soQuerschnitteInFahrtrichtung = getQuerschnitteInFahrtrichtung().get(i);
						final SystemObject tmpQuerschnitteInFahrtrichtung;
						if (soQuerschnitteInFahrtrichtung instanceof SystemObject) {
							tmpQuerschnitteInFahrtrichtung = (SystemObject)soQuerschnitteInFahrtrichtung;
						} else if(soQuerschnitteInFahrtrichtung instanceof SystemObjekt){
							tmpQuerschnitteInFahrtrichtung = ((SystemObjekt)soQuerschnitteInFahrtrichtung).getSystemObject();
						} else{
							tmpQuerschnitteInFahrtrichtung = null;
						}
						arrayQuerschnitteInFahrtrichtung.getReferenceValue(i).setSystemObject(tmpQuerschnitteInFahrtrichtung);
					}
				// ObjektReferenzAttributTyp
					final Object soTemplate = getTemplate();
					final SystemObject tmpTemplate;
						if (soTemplate instanceof SystemObject) {
							tmpTemplate = (SystemObject)soTemplate;
						} else if(soTemplate instanceof SystemObjekt){
							tmpTemplate = ((SystemObjekt)soTemplate).getSystemObject();
						} else{
							tmpTemplate = null;
						}
					datum.getReferenceValue("Template").setSystemObject(tmpTemplate);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Fahrtrichtung").isState()) {
							setFahrtrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
							.getZustand(daten.getScaledValue("Fahrtrichtung").getText()));
						} else {
						setFahrtrichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
						(daten.
							getUnscaledValue
						("Fahrtrichtung").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayFahrSpurenVonRechtsNachLinks = daten.getReferenceArray("FahrSpurenVonRechtsNachLinks");
					for (int i = 0; i < arrayFahrSpurenVonRechtsNachLinks.getLength(); ++i) {
						final long idFahrSpurenVonRechtsNachLinks = daten.getReferenceArray("FahrSpurenVonRechtsNachLinks").getReferenceValue(i).getId();
						final SystemObjekt tmpFahrSpurenVonRechtsNachLinks;
						if (idFahrSpurenVonRechtsNachLinks == 0) {
							tmpFahrSpurenVonRechtsNachLinks = null;
						} else {
							final SystemObject soFahrSpurenVonRechtsNachLinks = factory.getDav().getDataModel().getObject(idFahrSpurenVonRechtsNachLinks);
							if (soFahrSpurenVonRechtsNachLinks == null) {
									tmpFahrSpurenVonRechtsNachLinks = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.impl.FahrSpurUngueltig(idFahrSpurenVonRechtsNachLinks);
							} else {
								tmpFahrSpurenVonRechtsNachLinks = factory.getModellobjekt(soFahrSpurenVonRechtsNachLinks);
							}
						}
							getFahrSpurenVonRechtsNachLinks().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.FahrSpur
							) tmpFahrSpurenVonRechtsNachLinks);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayQuerschnitteInFahrtrichtung = daten.getReferenceArray("QuerschnitteInFahrtrichtung");
					for (int i = 0; i < arrayQuerschnitteInFahrtrichtung.getLength(); ++i) {
						final long idQuerschnitteInFahrtrichtung = daten.getReferenceArray("QuerschnitteInFahrtrichtung").getReferenceValue(i).getId();
						final SystemObjekt tmpQuerschnitteInFahrtrichtung;
						if (idQuerschnitteInFahrtrichtung == 0) {
							tmpQuerschnitteInFahrtrichtung = null;
						} else {
							final SystemObject soQuerschnitteInFahrtrichtung = factory.getDav().getDataModel().getObject(idQuerschnitteInFahrtrichtung);
							if (soQuerschnitteInFahrtrichtung == null) {
									tmpQuerschnitteInFahrtrichtung = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeQuerschnittUngueltig(idQuerschnitteInFahrtrichtung);
							} else {
								tmpQuerschnitteInFahrtrichtung = factory.getModellobjekt(soQuerschnitteInFahrtrichtung);
							}
						}
							getQuerschnitteInFahrtrichtung().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
							) tmpQuerschnitteInFahrtrichtung);
					}
				// ObjektReferenzAttributTyp
					final long idTemplate = daten.getReferenceValue("Template").getId();
					final SystemObjekt tmpTemplate;
					if (idTemplate == 0) {
						tmpTemplate = null;
					} else {
						final SystemObject soTemplate = factory.getDav().getDataModel().getObject(idTemplate);
						if (soTemplate == null) {
								tmpTemplate = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.objekte.impl.AblaufTemplateUngueltig(idTemplate);
						} else {
							tmpTemplate = factory.getModellobjekt(soTemplate);
						}
					}
					setTemplate((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.objekte.AblaufTemplate
					) tmpTemplate);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAblaufMitTemplate clone() {
		AtlAblaufMitTemplate klon = new AtlAblaufMitTemplate();
		
						klon.setFahrtrichtung(getFahrtrichtung());
					klon._fahrSpurenVonRechtsNachLinks = getFahrSpurenVonRechtsNachLinks().clone();
					klon._querschnitteInFahrtrichtung = getQuerschnitteInFahrtrichtung().clone();
						klon.setTemplate(getTemplate());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
