/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Info.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlAblaufTemplateSchritt implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _pauseNachSchaltung
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlRelativProgramm
			> _relativProgramme = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlRelativProgramm
			>(0, true);
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@return der Wert von PauseNachSchaltung.
		*/
			public 	Zeitstempel
			 getPauseNachSchaltung() {
			return _pauseNachSchaltung;
		}
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@param _pauseNachSchaltung der neue Wert von PauseNachSchaltung.
		*/
		public void setPauseNachSchaltung(	Zeitstempel
		 _pauseNachSchaltung) {
			this._pauseNachSchaltung = _pauseNachSchaltung;
		}
	
		/**
		Ein Relativprogramm definiert einen Anzeigeinhalt für
							EIN
							bestimmtes Anzeigeelement. Dieses Anzeigeelement
							kann relativ zu
							einer Liste mit Anzeigequerschnitten
							und einer Liste mit Fahrspuren
							addressiert werden.
							Der Anzeigeinhalt wird hier als Objektreferenz
							übergeben.
		<p>
		
		</p>
		
		@return der Wert von RelativProgramme.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlRelativProgramm
			> getRelativProgramme() {
			return _relativProgramme;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("PauseNachSchaltung").setMillis(getPauseNachSchaltung().getTime());
				// AttributListenDefinition
					final Data.Array arrayRelativProgramme = datum.getArray("RelativProgramme");
					arrayRelativProgramme.setLength(getRelativProgramme().size());
					for (int i = 0; i < arrayRelativProgramme.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlRelativProgramm
						 atl = getRelativProgramme().get(i);
						atl.bean2Atl(arrayRelativProgramme.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setPauseNachSchaltung(new
						Zeitstempel
						(daten.getTimeValue("PauseNachSchaltung").getMillis()));
				// AttributListenDefinition
					final Data.Array arrayRelativProgramme = daten.getArray("RelativProgramme");
					for (int i = 0; i < arrayRelativProgramme.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlRelativProgramm
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlRelativProgramm
						 ();
						atl.atl2Bean(arrayRelativProgramme.getItem(i), factory);
						getRelativProgramme().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAblaufTemplateSchritt clone() {
		AtlAblaufTemplateSchritt klon = new AtlAblaufTemplateSchritt();
		
						klon.setPauseNachSchaltung(getPauseNachSchaltung());
					klon._relativProgramme = getRelativProgramme().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
