/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt ein Kommando des Ablaufservers.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlBcAblaufServerKommando implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _applikationsID
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _anfrageID
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _progressObjektID
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttBcAblaufServerKommandoTyp
			 _kommandoTyp
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttBcAblaufServerAntwortTyp
			 _antwortTyp
			;
			private String
			 _verursacher
			= new String
			()
			;
			private String
			 _nachricht
			= new String
			()
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanforderung.objekte.Anforderung
			 _anforderung
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 _direktSchaltung
			;
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@return der Wert von ApplikationsID.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getApplikationsID() {
			return _applikationsID;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@param _applikationsID der neue Wert von ApplikationsID.
		*/
		public void setApplikationsID(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _applikationsID) {
			this._applikationsID = _applikationsID;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@return der Wert von AnfrageID.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getAnfrageID() {
			return _anfrageID;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@param _anfrageID der neue Wert von AnfrageID.
		*/
		public void setAnfrageID(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _anfrageID) {
			this._anfrageID = _anfrageID;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@return der Wert von ProgressObjektID.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getProgressObjektID() {
			return _progressObjektID;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@param _progressObjektID der neue Wert von ProgressObjektID.
		*/
		public void setProgressObjektID(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _progressObjektID) {
			this._progressObjektID = _progressObjektID;
		}
	
		/**
		Typ eines Kommandos an den Ablaufprogramm-Server.
		<p>
		
		</p>
		
		@return der Wert von KommandoTyp.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttBcAblaufServerKommandoTyp
			 getKommandoTyp() {
			return _kommandoTyp;
		}
	
		/**
		Typ eines Kommandos an den Ablaufprogramm-Server.
		<p>
		
		</p>
		
		@param _kommandoTyp der neue Wert von KommandoTyp.
		*/
		public void setKommandoTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttBcAblaufServerKommandoTyp
		 _kommandoTyp) {
			this._kommandoTyp = _kommandoTyp;
		}
	
		/**
		Typ einer Antwort vom Ablaufprogramm-Server.
		<p>
		
		</p>
		
		@return der Wert von AntwortTyp.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttBcAblaufServerAntwortTyp
			 getAntwortTyp() {
			return _antwortTyp;
		}
	
		/**
		Typ einer Antwort vom Ablaufprogramm-Server.
		<p>
		
		</p>
		
		@param _antwortTyp der neue Wert von AntwortTyp.
		*/
		public void setAntwortTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttBcAblaufServerAntwortTyp
		 _antwortTyp) {
			this._antwortTyp = _antwortTyp;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Verursacher.
		*/
			public String
			 getVerursacher() {
			return _verursacher;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _verursacher der neue Wert von Verursacher.
		*/
		public void setVerursacher(String
		 _verursacher) {
			if (_verursacher.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._verursacher = _verursacher;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Nachricht.
		*/
			public String
			 getNachricht() {
			return _nachricht;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _nachricht der neue Wert von Nachricht.
		*/
		public void setNachricht(String
		 _nachricht) {
			if (_nachricht.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._nachricht = _nachricht;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@return der Wert von Anforderung.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanforderung.objekte.Anforderung
			 getAnforderung() {
			return _anforderung;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@param _anforderung der neue Wert von Anforderung.
		*/
		public void setAnforderung(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanforderung.objekte.Anforderung
		 _anforderung) {
			this._anforderung = _anforderung;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@return der Wert von DirektSchaltung.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 getDirektSchaltung() {
			return _direktSchaltung;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@param _direktSchaltung der neue Wert von DirektSchaltung.
		*/
		public void setDirektSchaltung(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
		 _direktSchaltung) {
			this._direktSchaltung = _direktSchaltung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getApplikationsID() != null) {
	                if (getApplikationsID().isZustand()) {
	                    datum.getUnscaledValue("ApplikationsID").setText(getApplikationsID().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ApplikationsID").set(getApplikationsID().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAnfrageID() != null) {
	                if (getAnfrageID().isZustand()) {
	                    datum.getUnscaledValue("AnfrageID").setText(getAnfrageID().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AnfrageID").set(getAnfrageID().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getProgressObjektID() != null) {
	                if (getProgressObjektID().isZustand()) {
	                    datum.getUnscaledValue("ProgressObjektID").setText(getProgressObjektID().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ProgressObjektID").set(getProgressObjektID().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getKommandoTyp() != null) {
	                if (getKommandoTyp().isZustand()) {
	                    datum.getUnscaledValue("KommandoTyp").setText(getKommandoTyp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("KommandoTyp").set(getKommandoTyp().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAntwortTyp() != null) {
	                if (getAntwortTyp().isZustand()) {
	                    datum.getUnscaledValue("AntwortTyp").setText(getAntwortTyp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AntwortTyp").set(getAntwortTyp().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getVerursacher() != null) {
					datum.getTextValue("Verursacher").setText(getVerursacher());
				}
				// ZeichenkettenAttributTyp
				if (getNachricht() != null) {
					datum.getTextValue("Nachricht").setText(getNachricht());
				}
				// ObjektReferenzAttributTyp
					final Object soAnforderung = getAnforderung();
					final SystemObject tmpAnforderung;
						if (soAnforderung instanceof SystemObject) {
							tmpAnforderung = (SystemObject)soAnforderung;
						} else if(soAnforderung instanceof SystemObjekt){
							tmpAnforderung = ((SystemObjekt)soAnforderung).getSystemObject();
						} else{
							tmpAnforderung = null;
						}
					datum.getReferenceValue("Anforderung").setSystemObject(tmpAnforderung);
				// ObjektReferenzAttributTyp
					final Object soDirektSchaltung = getDirektSchaltung();
					final SystemObject tmpDirektSchaltung;
						if (soDirektSchaltung instanceof SystemObject) {
							tmpDirektSchaltung = (SystemObject)soDirektSchaltung;
						} else if(soDirektSchaltung instanceof SystemObjekt){
							tmpDirektSchaltung = ((SystemObjekt)soDirektSchaltung).getSystemObject();
						} else{
							tmpDirektSchaltung = null;
						}
					datum.getReferenceValue("DirektSchaltung").setSystemObject(tmpDirektSchaltung);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setApplikationsID(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("ApplikationsID").
								longValue
						()));
				// GanzzahlAttributTyp
						setAnfrageID(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("AnfrageID").
								longValue
						()));
				// GanzzahlAttributTyp
						setProgressObjektID(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("ProgressObjektID").
								longValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("KommandoTyp").isState()) {
							setKommandoTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttBcAblaufServerKommandoTyp
							.getZustand(daten.getScaledValue("KommandoTyp").getText()));
						} else {
						setKommandoTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttBcAblaufServerKommandoTyp
						(daten.
							getUnscaledValue
						("KommandoTyp").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("AntwortTyp").isState()) {
							setAntwortTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttBcAblaufServerAntwortTyp
							.getZustand(daten.getScaledValue("AntwortTyp").getText()));
						} else {
						setAntwortTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttBcAblaufServerAntwortTyp
						(daten.
							getUnscaledValue
						("AntwortTyp").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setVerursacher(daten.getTextValue("Verursacher").getText());
				// ZeichenkettenAttributTyp
					setNachricht(daten.getTextValue("Nachricht").getText());
				// ObjektReferenzAttributTyp
					final long idAnforderung = daten.getReferenceValue("Anforderung").getId();
					final SystemObjekt tmpAnforderung;
					if (idAnforderung == 0) {
						tmpAnforderung = null;
					} else {
						final SystemObject soAnforderung = factory.getDav().getDataModel().getObject(idAnforderung);
						if (soAnforderung == null) {
								tmpAnforderung = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanforderung.objekte.impl.AnforderungUngueltig(idAnforderung);
						} else {
							tmpAnforderung = factory.getModellobjekt(soAnforderung);
						}
					}
					setAnforderung((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanforderung.objekte.Anforderung
					) tmpAnforderung);
				// ObjektReferenzAttributTyp
					final long idDirektSchaltung = daten.getReferenceValue("DirektSchaltung").getId();
					final SystemObjekt tmpDirektSchaltung;
					if (idDirektSchaltung == 0) {
						tmpDirektSchaltung = null;
					} else {
						final SystemObject soDirektSchaltung = factory.getDav().getDataModel().getObject(idDirektSchaltung);
						if (soDirektSchaltung == null) {
								tmpDirektSchaltung = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idDirektSchaltung);
						} else {
							tmpDirektSchaltung = factory.getModellobjekt(soDirektSchaltung);
						}
					}
					setDirektSchaltung((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
					) tmpDirektSchaltung);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBcAblaufServerKommando clone() {
		AtlBcAblaufServerKommando klon = new AtlBcAblaufServerKommando();
		
						klon.setApplikationsID(getApplikationsID());
						klon.setAnfrageID(getAnfrageID());
						klon.setProgressObjektID(getProgressObjektID());
						klon.setKommandoTyp(getKommandoTyp());
						klon.setAntwortTyp(getAntwortTyp());
						klon.setVerursacher(getVerursacher());
						klon.setNachricht(getNachricht());
						klon.setAnforderung(getAnforderung());
						klon.setDirektSchaltung(getDirektSchaltung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
