/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Info.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlSchritt implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _schrittId
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttSchrittTyp
			 _typ
			;
			private String
			 _schrittInfo
			= new String
			()
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 _schaltung
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttAblaufPause
			 _pause
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlBedienerAbfrage
			 _bedienerAbfrage
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlBedienerAbfrage
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlSystemAbfrage
			 _systemAbfrage
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlSystemAbfrage
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlAblaufMeldung
			 _meldung
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlAblaufMeldung
			()
			;
			private String
			 _beiAbbruchSchritt
			= new String
			()
			;
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von SchrittId.
		*/
			public String
			 getSchrittId() {
			return _schrittId;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _schrittId der neue Wert von SchrittId.
		*/
		public void setSchrittId(String
		 _schrittId) {
			if (_schrittId.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._schrittId = _schrittId;
		}
	
		/**
		In jedem Schritt kann genau eine der hier
							definierten
							Aktionen stattfinden (siehe Pflichtenheft
							Kapitel 4.4.2.3.4.1).
		<p>
		
		</p>
		
		@return der Wert von Typ.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttSchrittTyp
			 getTyp() {
			return _typ;
		}
	
		/**
		In jedem Schritt kann genau eine der hier
							definierten
							Aktionen stattfinden (siehe Pflichtenheft
							Kapitel 4.4.2.3.4.1).
		<p>
		
		</p>
		
		@param _typ der neue Wert von Typ.
		*/
		public void setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttSchrittTyp
		 _typ) {
			this._typ = _typ;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von SchrittInfo.
		*/
			public String
			 getSchrittInfo() {
			return _schrittInfo;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _schrittInfo der neue Wert von SchrittInfo.
		*/
		public void setSchrittInfo(String
		 _schrittInfo) {
			if (_schrittInfo.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._schrittInfo = _schrittInfo;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@return der Wert von Schaltung.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 getSchaltung() {
			return _schaltung;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@param _schaltung der neue Wert von Schaltung.
		*/
		public void setSchaltung(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
		 _schaltung) {
			this._schaltung = _schaltung;
		}
	
		/**
		Angabe einer relativen Wartezeit in Sekunden.
		<p>
		Auf Zehntelsekunden genau. Wird in der Regel durch
							den
							Ablaufserver verwendet, um eine absolute Startzeit für den
							NÄCHSTEN
							Schritt zu errechnen, wenn dieser eine Programmschaltung
							ist.
		</p>
		
		@return der Wert von Pause.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttAblaufPause
			 getPause() {
			return _pause;
		}
	
		/**
		Angabe einer relativen Wartezeit in Sekunden.
		<p>
		Auf Zehntelsekunden genau. Wird in der Regel durch
							den
							Ablaufserver verwendet, um eine absolute Startzeit für den
							NÄCHSTEN
							Schritt zu errechnen, wenn dieser eine Programmschaltung
							ist.
		</p>
		
		@param _pause der neue Wert von Pause.
		*/
		public void setPause(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttAblaufPause
		 _pause) {
			this._pause = _pause;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@return der Wert von BedienerAbfrage.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlBedienerAbfrage
			 getBedienerAbfrage() {
			return _bedienerAbfrage;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@param _bedienerAbfrage der neue Wert von BedienerAbfrage.
		*/
		public void setBedienerAbfrage(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlBedienerAbfrage
		 _bedienerAbfrage) {
			this._bedienerAbfrage = _bedienerAbfrage;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@return der Wert von SystemAbfrage.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlSystemAbfrage
			 getSystemAbfrage() {
			return _systemAbfrage;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@param _systemAbfrage der neue Wert von SystemAbfrage.
		*/
		public void setSystemAbfrage(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlSystemAbfrage
		 _systemAbfrage) {
			this._systemAbfrage = _systemAbfrage;
		}
	
		/**
		Nicht-blockierende Meldung des
							Ablaufservers an den Bediener.
		<p>
		
		</p>
		
		@return der Wert von Meldung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlAblaufMeldung
			 getMeldung() {
			return _meldung;
		}
	
		/**
		Nicht-blockierende Meldung des
							Ablaufservers an den Bediener.
		<p>
		
		</p>
		
		@param _meldung der neue Wert von Meldung.
		*/
		public void setMeldung(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlAblaufMeldung
		 _meldung) {
			this._meldung = _meldung;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von BeiAbbruchSchritt.
		*/
			public String
			 getBeiAbbruchSchritt() {
			return _beiAbbruchSchritt;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _beiAbbruchSchritt der neue Wert von BeiAbbruchSchritt.
		*/
		public void setBeiAbbruchSchritt(String
		 _beiAbbruchSchritt) {
			if (_beiAbbruchSchritt.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._beiAbbruchSchritt = _beiAbbruchSchritt;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getSchrittId() != null) {
					datum.getTextValue("SchrittId").setText(getSchrittId());
				}
				// GanzzahlAttributTyp
				if (getTyp() != null) {
	                if (getTyp().isZustand()) {
	                    datum.getUnscaledValue("Typ").setText(getTyp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Typ").set(getTyp().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getSchrittInfo() != null) {
					datum.getTextValue("SchrittInfo").setText(getSchrittInfo());
				}
				// ObjektReferenzAttributTyp
					final Object soSchaltung = getSchaltung();
					final SystemObject tmpSchaltung;
						if (soSchaltung instanceof SystemObject) {
							tmpSchaltung = (SystemObject)soSchaltung;
						} else if(soSchaltung instanceof SystemObjekt){
							tmpSchaltung = ((SystemObjekt)soSchaltung).getSystemObject();
						} else{
							tmpSchaltung = null;
						}
					datum.getReferenceValue("Schaltung").setSystemObject(tmpSchaltung);
				// GanzzahlAttributTyp
				if (getPause() != null) {
	                if (getPause().isZustand()) {
	                    datum.getUnscaledValue("Pause").setText(getPause().toString());
	                } else {
						datum.
						getScaledValue
	                	("Pause").set(getPause().getValue());
	                }
				}
				// AttributListenDefinition
					getBedienerAbfrage().bean2Atl(datum.getItem("BedienerAbfrage"), factory);
				// AttributListenDefinition
					getSystemAbfrage().bean2Atl(datum.getItem("SystemAbfrage"), factory);
				// AttributListenDefinition
					getMeldung().bean2Atl(datum.getItem("Meldung"), factory);
				// ZeichenkettenAttributTyp
				if (getBeiAbbruchSchritt() != null) {
					datum.getTextValue("BeiAbbruchSchritt").setText(getBeiAbbruchSchritt());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setSchrittId(daten.getTextValue("SchrittId").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Typ").isState()) {
							setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttSchrittTyp
							.getZustand(daten.getScaledValue("Typ").getText()));
						} else {
						setTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttSchrittTyp
						(daten.
							getUnscaledValue
						("Typ").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setSchrittInfo(daten.getTextValue("SchrittInfo").getText());
				// ObjektReferenzAttributTyp
					final long idSchaltung = daten.getReferenceValue("Schaltung").getId();
					final SystemObjekt tmpSchaltung;
					if (idSchaltung == 0) {
						tmpSchaltung = null;
					} else {
						final SystemObject soSchaltung = factory.getDav().getDataModel().getObject(idSchaltung);
						if (soSchaltung == null) {
								tmpSchaltung = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idSchaltung);
						} else {
							tmpSchaltung = factory.getModellobjekt(soSchaltung);
						}
					}
					setSchaltung((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
					) tmpSchaltung);
				// GanzzahlAttributTyp
						setPause(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttAblaufPause
						(daten.
							getScaledValue
						("Pause").
							doubleValue
						()));
				// AttributListenDefinition
					getBedienerAbfrage().atl2Bean(daten.getItem("BedienerAbfrage"), factory);
				// AttributListenDefinition
					getSystemAbfrage().atl2Bean(daten.getItem("SystemAbfrage"), factory);
				// AttributListenDefinition
					getMeldung().atl2Bean(daten.getItem("Meldung"), factory);
				// ZeichenkettenAttributTyp
					setBeiAbbruchSchritt(daten.getTextValue("BeiAbbruchSchritt").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlSchritt clone() {
		AtlSchritt klon = new AtlSchritt();
		
						klon.setSchrittId(getSchrittId());
						klon.setTyp(getTyp());
						klon.setSchrittInfo(getSchrittInfo());
						klon.setSchaltung(getSchaltung());
						klon.setPause(getPause());
						klon._bedienerAbfrage = getBedienerAbfrage().clone();
						klon._systemAbfrage = getSystemAbfrage().clone();
						klon._meldung = getMeldung().clone();
						klon.setBeiAbbruchSchritt(getBeiAbbruchSchritt());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
