/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Info.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlSystemAbfrage implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _ausdruck
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
			 _timeout
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlBedienerAntwort
			> _moeglicheAntworten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlBedienerAntwort
			>(0, true);
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Ausdruck.
		*/
			public String
			 getAusdruck() {
			return _ausdruck;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _ausdruck der neue Wert von Ausdruck.
		*/
		public void setAusdruck(String
		 _ausdruck) {
			if (_ausdruck.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._ausdruck = _ausdruck;
		}
	
		/**
		Attributtyp zur Definition von Timeouts in der Auflösung ms.
		<p>
		
		</p>
		
		@return der Wert von Timeout.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
			 getTimeout() {
			return _timeout;
		}
	
		/**
		Attributtyp zur Definition von Timeouts in der Auflösung ms.
		<p>
		
		</p>
		
		@param _timeout der neue Wert von Timeout.
		*/
		public void setTimeout(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
		 _timeout) {
			this._timeout = _timeout;
		}
	
		/**
		Beschreibt eine Antwort eines Bedieners auf eine
							Frage.
		<p>
		
		</p>
		
		@return der Wert von MoeglicheAntworten.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlBedienerAntwort
			> getMoeglicheAntworten() {
			return _moeglicheAntworten;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getAusdruck() != null) {
					datum.getTextValue("Ausdruck").setText(getAusdruck());
				}
				// GanzzahlAttributTyp
				if (getTimeout() != null) {
	                if (getTimeout().isZustand()) {
	                    datum.getUnscaledValue("Timeout").setText(getTimeout().toString());
	                } else {
						datum.
						getScaledValue
	                	("Timeout").set(getTimeout().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayMoeglicheAntworten = datum.getArray("MoeglicheAntworten");
					arrayMoeglicheAntworten.setLength(getMoeglicheAntworten().size());
					for (int i = 0; i < arrayMoeglicheAntworten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlBedienerAntwort
						 atl = getMoeglicheAntworten().get(i);
						atl.bean2Atl(arrayMoeglicheAntworten.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setAusdruck(daten.getTextValue("Ausdruck").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Timeout").isState()) {
							setTimeout(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
							.getZustand(daten.getScaledValue("Timeout").getText()));
						} else {
						setTimeout(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
						(daten.
							getScaledValue
						("Timeout").
							doubleValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayMoeglicheAntworten = daten.getArray("MoeglicheAntworten");
					for (int i = 0; i < arrayMoeglicheAntworten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlBedienerAntwort
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlBedienerAntwort
						 ();
						atl.atl2Bean(arrayMoeglicheAntworten.getItem(i), factory);
						getMoeglicheAntworten().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlSystemAbfrage clone() {
		AtlSystemAbfrage klon = new AtlSystemAbfrage();
		
						klon.setAusdruck(getAusdruck());
						klon.setTimeout(getTimeout());
					klon._moeglicheAntworten = getMoeglicheAntworten().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
