/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Info.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlUebergangsMatrixEintrag implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanforderung.objekte.Anforderung
			 _anforderung
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.objekte.Ablauf
			 _ablauf
			;
	
		/**
		Verweis auf ein Objekt vom Typ Anforderung.
		<p>
		
		</p>
		
		@return der Wert von Anforderung.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanforderung.objekte.Anforderung
			 getAnforderung() {
			return _anforderung;
		}
	
		/**
		Verweis auf ein Objekt vom Typ Anforderung.
		<p>
		
		</p>
		
		@param _anforderung der neue Wert von Anforderung.
		*/
		public void setAnforderung(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanforderung.objekte.Anforderung
		 _anforderung) {
			this._anforderung = _anforderung;
		}
	
		/**
		Verweis auf ein Objekt vom Typ SchaltAblauf.
		<p>
		
		</p>
		
		@return der Wert von Ablauf.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.objekte.Ablauf
			 getAblauf() {
			return _ablauf;
		}
	
		/**
		Verweis auf ein Objekt vom Typ SchaltAblauf.
		<p>
		
		</p>
		
		@param _ablauf der neue Wert von Ablauf.
		*/
		public void setAblauf(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.objekte.Ablauf
		 _ablauf) {
			this._ablauf = _ablauf;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soAnforderung = getAnforderung();
					final SystemObject tmpAnforderung;
						if (soAnforderung instanceof SystemObject) {
							tmpAnforderung = (SystemObject)soAnforderung;
						} else if(soAnforderung instanceof SystemObjekt){
							tmpAnforderung = ((SystemObjekt)soAnforderung).getSystemObject();
						} else{
							tmpAnforderung = null;
						}
					datum.getReferenceValue("Anforderung").setSystemObject(tmpAnforderung);
				// ObjektReferenzAttributTyp
					final Object soAblauf = getAblauf();
					final SystemObject tmpAblauf;
						if (soAblauf instanceof SystemObject) {
							tmpAblauf = (SystemObject)soAblauf;
						} else if(soAblauf instanceof SystemObjekt){
							tmpAblauf = ((SystemObjekt)soAblauf).getSystemObject();
						} else{
							tmpAblauf = null;
						}
					datum.getReferenceValue("Ablauf").setSystemObject(tmpAblauf);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idAnforderung = daten.getReferenceValue("Anforderung").getId();
					final SystemObjekt tmpAnforderung;
					if (idAnforderung == 0) {
						tmpAnforderung = null;
					} else {
						final SystemObject soAnforderung = factory.getDav().getDataModel().getObject(idAnforderung);
						if (soAnforderung == null) {
								tmpAnforderung = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanforderung.objekte.impl.AnforderungUngueltig(idAnforderung);
						} else {
							tmpAnforderung = factory.getModellobjekt(soAnforderung);
						}
					}
					setAnforderung((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanforderung.objekte.Anforderung
					) tmpAnforderung);
				// ObjektReferenzAttributTyp
					final long idAblauf = daten.getReferenceValue("Ablauf").getId();
					final SystemObjekt tmpAblauf;
					if (idAblauf == 0) {
						tmpAblauf = null;
					} else {
						final SystemObject soAblauf = factory.getDav().getDataModel().getObject(idAblauf);
						if (soAblauf == null) {
								tmpAblauf = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.objekte.impl.AblaufUngueltig(idAblauf);
						} else {
							tmpAblauf = factory.getModellobjekt(soAblauf);
						}
					}
					setAblauf((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.objekte.Ablauf
					) tmpAblauf);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlUebergangsMatrixEintrag clone() {
		AtlUebergangsMatrixEintrag klon = new AtlUebergangsMatrixEintrag();
		
						klon.setAnforderung(getAnforderung());
						klon.setAblauf(getAblauf());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
