/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Info.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlUebergangsMatrixZeile implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 _zustand
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.objekte.Ablauf
			 _defaultAblauf
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlUebergangsMatrixEintrag
			> _eintraege = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlUebergangsMatrixEintrag
			>(0, true);
	
		/**
		Info.
		<p>
		
		</p>
		
		@return der Wert von Zustand.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 getZustand() {
			return _zustand;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@param _zustand der neue Wert von Zustand.
		*/
		public void setZustand(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
		 _zustand) {
			this._zustand = _zustand;
		}
	
		/**
		Verweis auf ein Objekt vom Typ SchaltAblauf.
		<p>
		
		</p>
		
		@return der Wert von DefaultAblauf.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.objekte.Ablauf
			 getDefaultAblauf() {
			return _defaultAblauf;
		}
	
		/**
		Verweis auf ein Objekt vom Typ SchaltAblauf.
		<p>
		
		</p>
		
		@param _defaultAblauf der neue Wert von DefaultAblauf.
		*/
		public void setDefaultAblauf(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.objekte.Ablauf
		 _defaultAblauf) {
			this._defaultAblauf = _defaultAblauf;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@return der Wert von Eintraege.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlUebergangsMatrixEintrag
			> getEintraege() {
			return _eintraege;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soZustand = getZustand();
					final SystemObject tmpZustand;
						if (soZustand instanceof SystemObject) {
							tmpZustand = (SystemObject)soZustand;
						} else if(soZustand instanceof SystemObjekt){
							tmpZustand = ((SystemObjekt)soZustand).getSystemObject();
						} else{
							tmpZustand = null;
						}
					datum.getReferenceValue("Zustand").setSystemObject(tmpZustand);
				// ObjektReferenzAttributTyp
					final Object soDefaultAblauf = getDefaultAblauf();
					final SystemObject tmpDefaultAblauf;
						if (soDefaultAblauf instanceof SystemObject) {
							tmpDefaultAblauf = (SystemObject)soDefaultAblauf;
						} else if(soDefaultAblauf instanceof SystemObjekt){
							tmpDefaultAblauf = ((SystemObjekt)soDefaultAblauf).getSystemObject();
						} else{
							tmpDefaultAblauf = null;
						}
					datum.getReferenceValue("DefaultAblauf").setSystemObject(tmpDefaultAblauf);
				// AttributListenDefinition
					final Data.Array arrayEintraege = datum.getArray("Eintraege");
					arrayEintraege.setLength(getEintraege().size());
					for (int i = 0; i < arrayEintraege.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlUebergangsMatrixEintrag
						 atl = getEintraege().get(i);
						atl.bean2Atl(arrayEintraege.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idZustand = daten.getReferenceValue("Zustand").getId();
					final SystemObjekt tmpZustand;
					if (idZustand == 0) {
						tmpZustand = null;
					} else {
						final SystemObject soZustand = factory.getDav().getDataModel().getObject(idZustand);
						if (soZustand == null) {
								tmpZustand = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idZustand);
						} else {
							tmpZustand = factory.getModellobjekt(soZustand);
						}
					}
					setZustand((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
					) tmpZustand);
				// ObjektReferenzAttributTyp
					final long idDefaultAblauf = daten.getReferenceValue("DefaultAblauf").getId();
					final SystemObjekt tmpDefaultAblauf;
					if (idDefaultAblauf == 0) {
						tmpDefaultAblauf = null;
					} else {
						final SystemObject soDefaultAblauf = factory.getDav().getDataModel().getObject(idDefaultAblauf);
						if (soDefaultAblauf == null) {
								tmpDefaultAblauf = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.objekte.impl.AblaufUngueltig(idDefaultAblauf);
						} else {
							tmpDefaultAblauf = factory.getModellobjekt(soDefaultAblauf);
						}
					}
					setDefaultAblauf((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.objekte.Ablauf
					) tmpDefaultAblauf);
				// AttributListenDefinition
					final Data.Array arrayEintraege = daten.getArray("Eintraege");
					for (int i = 0; i < arrayEintraege.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlUebergangsMatrixEintrag
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlUebergangsMatrixEintrag
						 ();
						atl.atl2Bean(arrayEintraege.getItem(i), factory);
						getEintraege().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlUebergangsMatrixZeile clone() {
		AtlUebergangsMatrixZeile klon = new AtlUebergangsMatrixZeile();
		
						klon.setZustand(getZustand());
						klon.setDefaultAblauf(getDefaultAblauf());
					klon._eintraege = getEintraege().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
