/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
In jedem Schritt kann genau eine der hier
					definierten
					Aktionen stattfinden (siehe Pflichtenheft
					Kapitel 4.4.2.3.4.1).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttSchrittTyp extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Schaltung von einem oder mehreren
								Anzeigeelementen.
	<p>
	
	</p>
	*/
	public static final AttSchrittTyp ZUSTAND_0_SCHALTUNG = new AttSchrittTyp("Schaltung", 		Byte
	.valueOf("0"));

	/**
	Bedienerabfrage mit Verzweigung des
								Ablaufs in
								Abhängigkeit vom Ergebnis.
	<p>
	
	</p>
	*/
	public static final AttSchrittTyp ZUSTAND_1_BEDIENERABFRAGE = new AttSchrittTyp("Bedienerabfrage", 		Byte
	.valueOf("1"));

	/**
	Systemabfrage mit Verzweigung des Ablaufs
								in
								Abhängigkeit vom Ergebnis.
	<p>
	
	</p>
	*/
	public static final AttSchrittTyp ZUSTAND_2_SYSTEMABFRAGE = new AttSchrittTyp("Systemabfrage", 		Byte
	.valueOf("2"));

	/**
	Meldung an den Bediener, ohne
								Rückbestätigung
								(nicht blockierend).
	<p>
	
	</p>
	*/
	public static final AttSchrittTyp ZUSTAND_3_MELDUNG = new AttSchrittTyp("Meldung", 		Byte
	.valueOf("3"));

	/**
	Ablauf hier beenden.
	<p>
	
	</p>
	*/
	public static final AttSchrittTyp ZUSTAND_4_ENDE = new AttSchrittTyp("Ende", 		Byte
	.valueOf("4"));

	/**
	Realisiert eine Wartezeit als eigenen Schritt.
	<p>
	
	</p>
	*/
	public static final AttSchrittTyp ZUSTAND_5_PAUSE = new AttSchrittTyp("Pause", 		Byte
	.valueOf("5"));

	/**
	Entfernt ein leufendes Programm.
	<p>
	
	</p>
	*/
	public static final AttSchrittTyp ZUSTAND_6_ENTFERNEN = new AttSchrittTyp("Entfernen", 		Byte
	.valueOf("6"));

	/**
	Setzt eine neue Anforderung innerhalb eines
								Ablaufes ab.
	<p>
	
	</p>
	*/
	public static final AttSchrittTyp ZUSTAND_7_ANFORDERUNG = new AttSchrittTyp("Anforderung", 		Byte
	.valueOf("7"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttSchrittTyp getZustand(final 		Byte
	 value) {
		for (AttSchrittTyp e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttSchrittTyp getZustand(final String value) {
		for (AttSchrittTyp e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttSchrittTyp> getZustaende() {
		List<AttSchrittTyp> list = new ArrayList<AttSchrittTyp>();
		list.add(ZUSTAND_0_SCHALTUNG);
		list.add(ZUSTAND_1_BEDIENERABFRAGE);
		list.add(ZUSTAND_2_SYSTEMABFRAGE);
		list.add(ZUSTAND_3_MELDUNG);
		list.add(ZUSTAND_4_ENDE);
		list.add(ZUSTAND_5_PAUSE);
		list.add(ZUSTAND_6_ENTFERNEN);
		list.add(ZUSTAND_7_ANFORDERUNG);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut SchrittTyp.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttSchrittTyp(final 		Byte
	 value) {
		super(value);
	}
	
	private AttSchrittTyp(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
