/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanforderung.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eine Liste von Referenzen auf Schaltprogrammgruppen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlSchaltProgrammGruppenListe implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
			 _schaltProgrammGruppe
			;
	
		/**
		Verweis auf ein Objekt vom Typ SchaltProgrammGruppe.
		<p>
		
		</p>
		
		@return der Wert von SchaltProgrammGruppe.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
			 getSchaltProgrammGruppe() {
			return _schaltProgrammGruppe;
		}
	
		/**
		Verweis auf ein Objekt vom Typ SchaltProgrammGruppe.
		<p>
		
		</p>
		
		@param _schaltProgrammGruppe der neue Wert von SchaltProgrammGruppe.
		*/
		public void setSchaltProgrammGruppe(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
		 _schaltProgrammGruppe) {
			this._schaltProgrammGruppe = _schaltProgrammGruppe;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soSchaltProgrammGruppe = getSchaltProgrammGruppe();
					final SystemObject tmpSchaltProgrammGruppe;
						if (soSchaltProgrammGruppe instanceof SystemObject) {
							tmpSchaltProgrammGruppe = (SystemObject)soSchaltProgrammGruppe;
						} else if(soSchaltProgrammGruppe instanceof SystemObjekt){
							tmpSchaltProgrammGruppe = ((SystemObjekt)soSchaltProgrammGruppe).getSystemObject();
						} else{
							tmpSchaltProgrammGruppe = null;
						}
					datum.getReferenceValue("SchaltProgrammGruppe").setSystemObject(tmpSchaltProgrammGruppe);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idSchaltProgrammGruppe = daten.getReferenceValue("SchaltProgrammGruppe").getId();
					final SystemObjekt tmpSchaltProgrammGruppe;
					if (idSchaltProgrammGruppe == 0) {
						tmpSchaltProgrammGruppe = null;
					} else {
						final SystemObject soSchaltProgrammGruppe = factory.getDav().getDataModel().getObject(idSchaltProgrammGruppe);
						if (soSchaltProgrammGruppe == null) {
								tmpSchaltProgrammGruppe = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammGruppeUngueltig(idSchaltProgrammGruppe);
						} else {
							tmpSchaltProgrammGruppe = factory.getModellobjekt(soSchaltProgrammGruppe);
						}
					}
					setSchaltProgrammGruppe((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
					) tmpSchaltProgrammGruppe);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlSchaltProgrammGruppenListe clone() {
		AtlSchaltProgrammGruppenListe klon = new AtlSchaltProgrammGruppenListe();
		
						klon.setSchaltProgrammGruppe(getSchaltProgrammGruppe());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
